/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractVkDeviceMemoryAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = 5092764356119724470L;
    private final long allocationSize;
    private final long memoryTypeIndex;

    public AbstractVkDeviceMemoryAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, long allocationSize, long memoryTypeIndex) {
        super(KapiSpec.VULKAN.assetTables.DEVICEMEMORY_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, handle);
        this.allocationSize = allocationSize;
        this.memoryTypeIndex = memoryTypeIndex;
    }

    public long getAllocationSize() {
        return this.allocationSize;
    }

    public long getMemoryTypeIndex() {
        return this.memoryTypeIndex;
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("allocationSize", ValueAssetProperty.create(String.valueOf(this.getAllocationSize())));
        properties.put("memoryTypeIndex", ValueAssetProperty.create(String.valueOf(this.getMemoryTypeIndex())));
        return properties;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull StringBuilder sb = new StringBuilder();
        sb.append(this.getAssetSpec().getSingularName());
        sb.append(" ").append(this.toString());
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull String toString() {
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.getId()).toString();
    }
}

