/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.VkDescriptorSetAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractVkDescriptorPoolAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = 5607074260748484769L;
    private @NonNull List<VkDescriptorSetAsset> descriptorSets = new ArrayList<VkDescriptorSetAsset>();

    public AbstractVkDescriptorPoolAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle) {
        super(KapiSpec.VULKAN.assetTables.DESCRIPTORPOOL_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, handle);
    }

    public @NonNull List<VkDescriptorSetAsset> getDescriptorSets() {
        return this.descriptorSets;
    }

    public List<VkDescriptorSetAsset> setDescriptorSets(@NonNull List<VkDescriptorSetAsset> descriptorSets) {
        List<VkDescriptorSetAsset> previousValueToReturn = this.descriptorSets;
        this.descriptorSets = descriptorSets;
        return previousValueToReturn;
    }

    public @NonNull List<VkDescriptorSetAsset> getDescriptorSetsCollection() {
        return Collections.unmodifiableList(this.descriptorSets);
    }

    public void setDescriptorSetsCollection(@NonNull List<VkDescriptorSetAsset> descriptorSets) {
        this.descriptorSets.clear();
        this.descriptorSets.addAll(descriptorSets);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        ArrayList<IAssetProperty> descriptorSetslist = new ArrayList<IAssetProperty>();
        for (VkDescriptorSetAsset property : this.getDescriptorSets()) {
            descriptorSetslist.add(VkAssetPropertyFormatter.getAssetViewProperty(property));
        }
        properties.put("descriptorSets", new ListAssetProperty(descriptorSetslist));
        return properties;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull StringBuilder sb = new StringBuilder();
        sb.append(this.getAssetSpec().getSingularName());
        sb.append(" ").append(this.toString());
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull String toString() {
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.getId()).toString();
    }
}

