/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.VkBufferAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractVkBufferViewAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = -955815728331552438L;
    private final @NonNull VkBufferAsset buffer;
    private final @NonNull Bitfield flags;
    private final @NonNull AbstractConstantOrAliasSpecExtended format;
    private final long offset;
    private final long range;

    public AbstractVkBufferViewAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, @NonNull VkBufferAsset buffer, @NonNull Bitfield flags, @NonNull AbstractConstantOrAliasSpecExtended format, long offset, long range) {
        super(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, handle);
        this.buffer = buffer;
        this.flags = flags;
        this.format = format;
        this.offset = offset;
        this.range = range;
    }

    public @NonNull VkBufferAsset getBuffer() {
        return this.buffer;
    }

    public @NonNull Bitfield getFlags() {
        return this.flags;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getFormat() {
        return this.format;
    }

    public long getOffset() {
        return this.offset;
    }

    public long getRange() {
        return this.range;
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("buffer", VkAssetPropertyFormatter.getAssetViewProperty(this.getBuffer()));
        properties.put("flags", VkAssetPropertyFormatter.getAssetViewProperty(this.getFlags()));
        properties.put("format", VkAssetPropertyFormatter.getAssetViewProperty(this.getFormat()));
        properties.put("offset", ValueAssetProperty.create(String.valueOf(this.getOffset())));
        properties.put("range", ValueAssetProperty.create(String.valueOf(this.getRange())));
        return properties;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull StringBuilder sb = new StringBuilder();
        sb.append(this.getAssetSpec().getSingularName());
        sb.append(" ").append(this.toString());
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull String toString() {
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.getId()).toString();
    }
}

