/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractVkBufferAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = -3288608007749012886L;
    private final @NonNull Bitfield flags;
    private final @NonNull LongsArgAttachment queueFamilyIndices;
    private final @NonNull AbstractConstantOrAliasSpecExtended sharingMode;
    private final long size;
    private final @NonNull Bitfield usage;

    public AbstractVkBufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, @NonNull Bitfield flags, @NonNull LongsArgAttachment queueFamilyIndices, @NonNull AbstractConstantOrAliasSpecExtended sharingMode, long size, @NonNull Bitfield usage) {
        super(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, handle);
        this.flags = flags;
        this.queueFamilyIndices = queueFamilyIndices;
        this.sharingMode = sharingMode;
        this.size = size;
        this.usage = usage;
    }

    public @NonNull Bitfield getFlags() {
        return this.flags;
    }

    public @NonNull LongsArgAttachment getQueueFamilyIndices() {
        return this.queueFamilyIndices;
    }

    public @NonNull AbstractConstantOrAliasSpecExtended getSharingMode() {
        return this.sharingMode;
    }

    public long getSize() {
        return this.size;
    }

    public @NonNull Bitfield getUsage() {
        return this.usage;
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("flags", VkAssetPropertyFormatter.getAssetViewProperty(this.getFlags()));
        properties.put("queueFamilyIndices", VkAssetPropertyFormatter.getAssetViewProperty(this.getQueueFamilyIndices()));
        properties.put("sharingMode", VkAssetPropertyFormatter.getAssetViewProperty(this.getSharingMode()));
        properties.put("size", ValueAssetProperty.create(String.valueOf(this.getSize())));
        properties.put("usage", VkAssetPropertyFormatter.getAssetViewProperty(this.getUsage()));
        return properties;
    }

    @Override
    public @NonNull String getLabelText() {
        @NonNull StringBuilder sb = new StringBuilder();
        sb.append(this.getAssetSpec().getSingularName());
        sb.append(" ").append(this.toString());
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    @Override
    public @NonNull String toString() {
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, this.getId()).toString();
    }
}

