/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset.objects.gen;

import com.arm.mgd.core.asset.EglAsset;
import com.arm.mgd.core.asset.EglConfigAsset;
import com.arm.mgd.core.asset.EglDisplayAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public abstract class AbstractEglSurfaceAsset
extends EglAsset {
    private static final long serialVersionUID = 2927566952583710900L;
    private final @NonNull Map<AbstractConstantOrAliasSpecExtended, Long> attributes;
    private final @NonNull EglConfigAsset config;
    private Boolean locked;
    private final EglDisplayAsset parentDisplay;
    private final Map<AbstractConstantOrAliasSpecExtended, Long> pendingAttributes;

    public AbstractEglSurfaceAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id, @NonNull EglConfigAsset config, EglDisplayAsset parentDisplay) {
        super(KapiSpec.EGL.assetTables.EGLSURFACE_TRAITS.SPEC, snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
        this.config = config;
        this.parentDisplay = parentDisplay;
        this.attributes = new HashMap<AbstractConstantOrAliasSpecExtended, Long>();
        this.pendingAttributes = new HashMap<AbstractConstantOrAliasSpecExtended, Long>();
    }

    public Long getAttribute(@NonNull AbstractConstantOrAliasSpecExtended key) {
        return this.attributes.get(key);
    }

    public Long setAttribute(@NonNull AbstractConstantOrAliasSpecExtended key, @NonNull Long attributes) {
        return this.attributes.put(key, attributes);
    }

    public @NonNull EglConfigAsset getConfig() {
        return this.config;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public Boolean setLocked(Boolean locked) {
        Boolean previousValueToReturn = this.locked;
        this.locked = locked;
        return previousValueToReturn;
    }

    public EglDisplayAsset getParentDisplay() {
        return this.parentDisplay;
    }

    public Long getPendingAttribute(@NonNull AbstractConstantOrAliasSpecExtended key) {
        return this.pendingAttributes.get(key);
    }

    public Long setPendingAttribute(@NonNull AbstractConstantOrAliasSpecExtended key, Long pendingAttributes) {
        return this.pendingAttributes.put(key, pendingAttributes);
    }

    public @NonNull Map<AbstractConstantOrAliasSpecExtended, Long> getAttributesCollection() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public void setAttributesCollection(@NonNull Map<AbstractConstantOrAliasSpecExtended, Long> attributes) {
        this.attributes.clear();
        this.attributes.putAll(attributes);
    }

    public @NonNull Map<AbstractConstantOrAliasSpecExtended, Long> getPendingAttributesCollection() {
        return Collections.unmodifiableMap(this.pendingAttributes);
    }

    public void setPendingAttributesCollection(@NonNull Map<AbstractConstantOrAliasSpecExtended, Long> pendingAttributes) {
        this.pendingAttributes.clear();
        this.pendingAttributes.putAll(pendingAttributes);
    }
}

