/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.VkShaderModuleAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.Bitfield;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public class VkShaderStage
implements Serializable {
    private static final long serialVersionUID = -7701158296599180711L;
    private static final Map<Long, String> stageNames = new HashMap<Long, String>();
    private Bitfield stage;
    private VkShaderModuleAsset module;
    private String moduleEntryPointName;

    static {
        stageNames.put(KapiSpec.VULKAN.constants.VK_SHADER_STAGE_VERTEX_BIT.getResolvedValue(), "Vertex Shader Stage");
        stageNames.put(KapiSpec.VULKAN.constants.VK_SHADER_STAGE_FRAGMENT_BIT.getResolvedValue(), "Fragment Shader Stage");
        stageNames.put(KapiSpec.VULKAN.constants.VK_SHADER_STAGE_COMPUTE_BIT.getResolvedValue(), "Compute Shader Stage");
        stageNames.put(KapiSpec.VULKAN.constants.VK_SHADER_STAGE_GEOMETRY_BIT.getResolvedValue(), "Geometry Shader Stage");
        stageNames.put(KapiSpec.VULKAN.constants.VK_SHADER_STAGE_TESSELLATION_CONTROL_BIT.getResolvedValue(), "Tessellation Control Shader Stage");
        stageNames.put(KapiSpec.VULKAN.constants.VK_SHADER_STAGE_TESSELLATION_EVALUATION_BIT.getResolvedValue(), "Tessellation Evaluation Shader Stage");
    }

    public VkShaderStage(Bitfield stage, VkShaderModuleAsset module, String moduleEntryPointName) {
        this.stage = stage;
        this.module = module;
        this.moduleEntryPointName = moduleEntryPointName;
    }

    public VkShaderModuleAsset getModule() {
        return this.module;
    }

    public String getName() {
        return this.moduleEntryPointName;
    }

    public Bitfield getStage() {
        return this.stage;
    }

    public String toString() {
        String name = stageNames.get(this.getStage().getAsLong());
        return name != null ? name : "Stage " + this.getStage().toString();
    }
}

