/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ICreatableAndModifiable;
import com.arm.mgd.core.asset.VkCommand;
import com.arm.mgd.core.asset.VkCommandBufferAsset;
import com.arm.mgd.core.asset.VkFramebufferAsset;
import com.arm.mgd.core.asset.VkRenderPassAsset;
import com.arm.mgd.core.asset.VkSubpass;
import com.arm.mgd.core.asset.VkSubpassContentsSecondaryCommandBuffers;
import com.arm.mgd.core.asset.VkSubpassInline;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetPropertyProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VkRenderPassInstance
implements Serializable,
ICreatableAndModifiable,
IAssetPropertyProvider {
    private static final long serialVersionUID = -3126550744645044853L;
    private final @NonNull VkCommand beginCommand;
    private @Nullable FunctionCall previousModificationFunctionCall;
    private @Nullable VkCommand endCommand;
    private final @NonNull VkRenderPassAsset renderPassAsset;
    private final @NonNull VkFramebufferAsset framebufferAsset;
    private final @NonNull VkCommandBufferAsset commandBufferAsset;
    private final @NonNull List<@NonNull VkSubpass> subpasses;
    private boolean ended;
    private final long instanceNo;
    private final long instanceNoInCommandBuffer;

    private VkRenderPassInstance(@NonNull VkCommand beginCommand, long instanceNo, @NonNull VkRenderPassAsset renderPassAsset, @NonNull VkFramebufferAsset framebufferAsset, @NonNull VkCommandBufferAsset commandBufferAsset, long commandBufferInstanceNo) {
        this.beginCommand = beginCommand;
        this.endCommand = null;
        this.instanceNo = instanceNo;
        this.renderPassAsset = renderPassAsset;
        this.framebufferAsset = framebufferAsset;
        this.commandBufferAsset = commandBufferAsset;
        this.subpasses = new ArrayList<VkSubpass>();
        this.ended = false;
        this.instanceNoInCommandBuffer = commandBufferInstanceNo;
    }

    public static @NonNull VkRenderPassInstance create(@NonNull VkCommand beginCommand, long instanceNo, @NonNull VkRenderPassAsset renderPassAsset, @NonNull VkFramebufferAsset framebufferAsset, @NonNull AbstractConstantOrAliasSpecExtended subpassContents, @NonNull VkCommandBufferAsset commandBufferAsset, long instanceNoInCommandBuffer) {
        assert (beginCommand.getFunction().getFunctionSpec().equals(KapiSpec.VULKAN.functions.VKCMDBEGINRENDERPASS));
        VkRenderPassInstance renderPassInstance = new VkRenderPassInstance(beginCommand, instanceNo, renderPassAsset, framebufferAsset, commandBufferAsset, instanceNoInCommandBuffer);
        renderPassInstance.nextSubpass(subpassContents);
        return renderPassInstance;
    }

    public @NonNull String getId() {
        return String.valueOf(Long.toHexString(this.renderPassAsset.getId())) + "_" + this.instanceNo;
    }

    public @NonNull String toString() {
        return "Render Pass Instance " + this.instanceNoInCommandBuffer;
    }

    public @NonNull VkFramebufferAsset getFramebuffer() {
        return this.framebufferAsset;
    }

    public void nextSubpass(AbstractConstantOrAliasSpecExtended subpassContents) {
        if (KapiSpec.VULKAN.constants.VK_SUBPASS_CONTENTS_INLINE.equals(subpassContents)) {
            VkSubpassInline subpass = new VkSubpassInline();
            this.subpasses.add(subpass);
        } else if (KapiSpec.VULKAN.constants.VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS.equals(subpassContents)) {
            VkSubpassContentsSecondaryCommandBuffers subpass = new VkSubpassContentsSecondaryCommandBuffers();
            this.subpasses.add(subpass);
        }
    }

    public void record(@NonNull TraceStateSnapshot currentState, @NonNull VkCommand command) {
        FunctionCall functionCall;
        this.previousModificationFunctionCall = functionCall = command.getFunction();
        boolean isVkCmdExecuteCommands = functionCall.getFunctionSpec().equals(KapiSpec.VULKAN.functions.VKCMDEXECUTECOMMANDS);
        VkSubpass currentSubpass = this.getCurrentSubpass();
        if (currentSubpass instanceof VkSubpassContentsSecondaryCommandBuffers && !isVkCmdExecuteCommands) {
            TraceAnalysisLogger.error(currentState, functionCall, "Only secondary command buffers may be executed within a subpass started with VK_SUBPASS_CONTENTS_SECONDARY_COMMAND_BUFFERS");
        }
        if (currentSubpass instanceof VkSubpassInline && isVkCmdExecuteCommands) {
            TraceAnalysisLogger.error(currentState, functionCall, "Secondary command buffers must not be executed within a subpass started with VK_SUBPASS_CONTENTS_INLINE");
        }
        if (!this.ended && currentSubpass instanceof VkSubpassInline) {
            ((VkSubpassInline)currentSubpass).addCommand(command);
        }
    }

    public void recordExecuteCommands(@NonNull VkCommand vkCmdExecuteCommands, @NonNull List<@NonNull VkCommandBufferAsset> secondaryCommandBuffers) {
        VkSubpass currentSubpass;
        if (!this.ended && (currentSubpass = this.getCurrentSubpass()) instanceof VkSubpassContentsSecondaryCommandBuffers) {
            ((VkSubpassContentsSecondaryCommandBuffers)currentSubpass).recordExecuteCommands(vkCmdExecuteCommands, secondaryCommandBuffers);
        }
    }

    private VkSubpass getCurrentSubpass() {
        assert (!this.subpasses.isEmpty());
        return this.subpasses.get(this.subpasses.size() - 1);
    }

    public void end(@NonNull VkCommand endRenderPassCommand) {
        assert (this.endCommand == null);
        assert (endRenderPassCommand.getFunction().getFunctionSpec().equals(KapiSpec.VULKAN.functions.VKCMDENDRENDERPASS));
        this.endCommand = endRenderPassCommand;
        this.previousModificationFunctionCall = endRenderPassCommand.getFunction();
        this.ended = true;
    }

    public @NonNull List<@NonNull VkCommand> getCommands() {
        return this.subpasses.stream().flatMap(e -> e.getCommands().stream()).collect(Collectors.toList());
    }

    public @NonNull List<@NonNull VkSubpass> getSubpasses() {
        return NullUtils.unmodifiableList(this.subpasses);
    }

    public @NonNull VkCommand getBeginCommand() {
        return this.beginCommand;
    }

    public @Nullable VkCommand getEndCommand() {
        return this.endCommand;
    }

    public @NonNull VkRenderPassAsset getParentRenderPass() {
        return this.renderPassAsset;
    }

    @Override
    public @NonNull FunctionCall getCreatedByFunction() {
        return this.beginCommand.getFunction();
    }

    @Override
    public @Nullable FunctionCall getPreviousModificationFunction() {
        return this.previousModificationFunctionCall;
    }

    @Override
    public void setPreviousModificationFunction(@NonNull FunctionCall previousModificationFunction) {
        assert (false);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Framebuffer", this.framebufferAsset);
        properties.put("Command Buffer", this.commandBufferAsset);
        return properties;
    }

    @Override
    public @NonNull String getSimpleValue() {
        return (String)NullUtils.neverNull((Object)String.format("Instance %s", this.getId()));
    }
}

