/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.IVulkanHandleAsset;
import com.arm.mgd.core.asset.VkDescriptorSetLayoutAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractVkPipelineLayoutAsset;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VkPipelineLayoutAsset
extends AbstractVkPipelineLayoutAsset
implements IVulkanHandleAsset {
    private static final long serialVersionUID = 70038833035682471L;

    public VkPipelineLayoutAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, @NonNull Bitfield flags, @NonNull List< @NonNull VULKAN.Structs.VkPushConstantRange> pushConstants, @NonNull List<@NonNull VkDescriptorSetLayoutAsset> setLayouts) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, handle, flags, pushConstants, setLayouts);
    }

    public VkPipelineLayoutAsset(@NonNull ISnapshotAssetParent asSnapshotAssetParent, @NonNull FunctionCall functionCall, long id, @NonNull Bitfield flags, @NonNull List< @NonNull VULKAN.Structs.VkPushConstantRange> pushConstants, @NonNull List<@NonNull VkDescriptorSetLayoutAsset> setLayouts) {
        this(asSnapshotAssetParent, functionCall, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, flags, pushConstants, setLayouts);
    }

    public boolean isPushConstantCompatibleWith(@Nullable VkPipelineLayoutAsset other) {
        if (other == null) {
            return false;
        }
        if (this.equals(other)) {
            return true;
        }
        @NonNull List<VULKAN.Structs.VkPushConstantRange> pushConstantRanges = this.getPushConstants();
        @NonNull List<VULKAN.Structs.VkPushConstantRange> otherPushConstantRanges = other.getPushConstants();
        if (pushConstantRanges.size() != otherPushConstantRanges.size()) {
            return false;
        }
        for (VULKAN.Structs.VkPushConstantRange pushConstantRange : pushConstantRanges) {
            assert (pushConstantRange != null);
            Long size = pushConstantRange.getSize();
            Long offset = pushConstantRange.getOffset();
            Bitfield stageFlags = pushConstantRange.getStageFlags();
            boolean foundEqual = false;
            for (VULKAN.Structs.VkPushConstantRange otherPushConstantRange : otherPushConstantRanges) {
                assert (otherPushConstantRange != null);
                boolean sizeEquals = size.equals(otherPushConstantRange.getSize());
                boolean offsetEquals = offset.equals(otherPushConstantRange.getOffset());
                boolean stageFlagsEquals = stageFlags.equals(otherPushConstantRange.getStageFlags());
                if (!sizeEquals || !offsetEquals || !stageFlagsEquals) continue;
                foundEqual = true;
                break;
            }
            if (foundEqual) continue;
            return false;
        }
        return true;
    }
}

