/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.texture.ASTCHeader;
import com.arm.mgd.core.asset.texture.AstcExe;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.VulkanImageSubresourceLayoutAttachment;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.Dimension3D;
import com.arm.mgd.core.util.image.IntegerTextureConverter;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNull;

public class VkImageAssetConverter {
    private static boolean isTilingOptimalAndNoDataCopied(@NonNull VkImageAsset image) {
        return KapiSpec.VULKAN.constants.VK_IMAGE_TILING_OPTIMAL.equals(image.getTiling()) && !image.isImageDataCopiedFromOtherAsset();
    }

    public static @NonNull RGBAImageData getImageData(@NonNull VkImageAsset imageAsset) throws IImageProvider.ImageDataUnavailableException, IOException, IImageProvider.ImageConversionException {
        IntegerTextureConverter.ImageConversionSpec conversionSpec;
        if (VkImageAssetConverter.isTilingOptimalAndNoDataCopied(imageAsset)) {
            throw new IImageProvider.ImageDataUnavailableException("Optimally tiled images can only be displayed after a copy from another resource has been performed.");
        }
        byte[] data = imageAsset.getDataFromBackingMemory();
        if (data == null) {
            throw new IImageProvider.ImageDataUnavailableException("No data available.");
        }
        VkImageAsset localImageAsset = (VkImageAsset)NullUtils.nonNullOrDefault((Object)imageAsset.getSourceImageAsset(), (Object)imageAsset);
        long rowPitch = 0L;
        VulkanImageSubresourceLayoutAttachment subresourceLayout = localImageAsset.getSubresourceLayout(0, 0);
        if (subresourceLayout != null && localImageAsset.getTiling().equals(KapiSpec.VULKAN.constants.VK_IMAGE_TILING_LINEAR)) {
            rowPitch = subresourceLayout.getRowPitch();
        }
        Dimension imageSize = new Dimension(localImageAsset.getExtent().getWidth().intValue(), localImageAsset.getExtent().getHeight().intValue());
        AbstractConstantOrAliasSpecExtended format = localImageAsset.getFormat();
        if (localImageAsset.isCompressed()) {
            data = VkImageAssetConverter.decompressData(format, data, imageSize, rowPitch);
            format = KapiSpec.VULKAN.constants.VK_FORMAT_R8G8B8A8_UNORM;
            rowPitch = 0L;
        }
        if ((conversionSpec = IntegerTextureConverter.getVulkanImageConversionSpec(format)) == null) {
            throw new IImageProvider.ImageConversionException("Format " + imageAsset.getFormat() + " is not supported.");
        }
        IntegerTextureConverter.Result result = null;
        try {
            result = IntegerTextureConverter.convertTextureData(NullUtils.asReadOnlyByteBuffer((byte[])data), imageSize, conversionSpec, IntegerTextureConverter.AlphaChannel.INLINE_ALPHA, (int)rowPitch);
        }
        catch (Exception e) {
            throw new IImageProvider.ImageConversionException("Problem in converting data with format " + imageAsset.getFormat(), e);
        }
        return new RGBAImageData(imageSize, IByteDataProvider.createMemoryProvider(result.getData()), RGBAImageData.CoordinateOrigin.BOTTOM_LEFT);
    }

    private static boolean isASTCCompressedImageFormat(AbstractConstantOrAliasSpecExtended format) {
        return KapiSpec.VULKAN.constantGroups.ASTCCOMPRESSEDIMAGEFORMATS.contains(format);
    }

    private static byte @NonNull [] decompressData(AbstractConstantOrAliasSpecExtended format, byte @NonNull [] compressedData, Dimension imageSize, long rowPitch) throws IOException, IImageProvider.ImageConversionException {
        if (VkImageAssetConverter.isASTCCompressedImageFormat(format)) {
            byte[] resultData = null;
            Dimension3D tmpImageSize = new Dimension3D(imageSize.getWidth(), imageSize.getHeight());
            ASTCHeader header = new ASTCHeader(format, tmpImageSize);
            resultData = rowPitch > 0L ? AstcExe.getCompressedDataWithoutRowPitch(compressedData, (Dimension3D)NullUtils.neverNull((Object)ASTCHeader.ASTC_BLOCK_SIZE_LOOKUP.get(format)), tmpImageSize, (int)rowPitch) : compressedData;
            return AstcExe.getUncompressedData(header, NullUtils.asReadOnlyByteBuffer((byte[])resultData));
        }
        throw new IImageProvider.ImageConversionException("Unsupported compressed format " + format);
    }
}

