/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.IVkDeviceMemoryBackedAsset;
import com.arm.mgd.core.asset.IVulkanHandleAsset;
import com.arm.mgd.core.asset.VkDeviceMemoryAsset;
import com.arm.mgd.core.asset.VkImageAssetConverter;
import com.arm.mgd.core.asset.objects.gen.AbstractVkImageAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.asset.texture.RGBAImageData;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.AbstractFreeAttachment;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.VulkanImageMemoryRequirementsAttachment;
import com.arm.mgd.core.target.data.VulkanImageSubresourceLayoutAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VkImageAsset
extends AbstractVkImageAsset
implements IVkDeviceMemoryBackedAsset,
IVulkanHandleAsset,
IImageProvider {
    private static final long serialVersionUID = -1849239010554761638L;
    private long offset = 0L;
    private @Nullable VkDeviceMemoryAsset memoryBinding;
    private long size = 0L;
    private long alignment = 0L;
    private long memoryTypeBits = 0L;
    private @Nullable VkImageAsset sourceImageAsset = null;
    private boolean imageDataIsCopiedFromOtherAsset = false;

    public VkImageAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, long arrayLayers,  @NonNull VULKAN.Structs.VkExtent3D extent, @NonNull Bitfield flags, @NonNull AbstractConstantOrAliasSpecExtended format, @NonNull AbstractConstantOrAliasSpecExtended imageType, @NonNull AbstractConstantOrAliasSpecExtended initialLayout, long mipLevels, @NonNull LongsArgAttachment pQueueFamilyIndices, @NonNull Bitfield samples, @NonNull AbstractConstantOrAliasSpecExtended sharingMode, @NonNull AbstractConstantOrAliasSpecExtended tiling, @NonNull Bitfield usage) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, handle, arrayLayers, extent, flags, format, imageType, initialLayout, mipLevels, pQueueFamilyIndices, samples, sharingMode, tiling, usage);
    }

    public VkImageAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long handle, long arrayLayers,  @NonNull VULKAN.Structs.VkExtent3D extent, @NonNull Bitfield flags, @NonNull AbstractConstantOrAliasSpecExtended format, @NonNull AbstractConstantOrAliasSpecExtended imageType, @NonNull AbstractConstantOrAliasSpecExtended initialLayout, long mipLevels, @NonNull LongsArgAttachment pQueueFamilyIndices, @NonNull Bitfield samples, @NonNull AbstractConstantOrAliasSpecExtended sharingMode, @NonNull AbstractConstantOrAliasSpecExtended tiling, @NonNull Bitfield usage) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, handle, arrayLayers, extent, flags, format, imageType, initialLayout, mipLevels, pQueueFamilyIndices, samples, sharingMode, tiling, usage);
    }

    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public long getOffset() {
        assert (this.isBound());
        return this.offset;
    }

    @Override
    public boolean isBound() {
        return this.memoryBinding != null;
    }

    @Override
    public void bind(@NonNull VkDeviceMemoryAsset deviceMemory, long deviceOffset) {
        this.offset = deviceOffset;
        this.memoryBinding = deviceMemory;
    }

    @Override
    public @Nullable VkDeviceMemoryAsset getBackingMemory() {
        return this.memoryBinding;
    }

    public long getAlignment() {
        return this.alignment;
    }

    public void setAlignment(long alignment) {
        this.alignment = alignment;
    }

    public @NonNull List<@NonNull VulkanImageSubresourceLayoutAttachment> getSubresourceLayouts() {
        if (this.getTiling().equals(KapiSpec.VULKAN.constants.VK_IMAGE_TILING_OPTIMAL)) {
            return NullUtils.emptyList();
        }
        @NonNull List<@NonNull AbstractFreeAttachment> attachments = this.getCreatedByFunction().getFreeAttachments();
        for (AbstractFreeAttachment att : attachments) {
            if (!(att instanceof VulkanImageMemoryRequirementsAttachment)) continue;
            VulkanImageMemoryRequirementsAttachment req = (VulkanImageMemoryRequirementsAttachment)att;
            return req.getSubresourceLayouts();
        }
        assert (false) : String.format("Image %s was not provided with subresource layer data", this.toString());
        return new ArrayList<VulkanImageSubresourceLayoutAttachment>();
    }

    public @Nullable VulkanImageSubresourceLayoutAttachment getSubresourceLayout(int level, int layer) {
        @NonNull List<@NonNull AbstractFreeAttachment> attachments = this.getCreatedByFunction().getFreeAttachments();
        for (AbstractFreeAttachment att : attachments) {
            if (!(att instanceof VulkanImageMemoryRequirementsAttachment)) continue;
            @NonNull VulkanImageMemoryRequirementsAttachment req = (VulkanImageMemoryRequirementsAttachment)att;
            for (VulkanImageSubresourceLayoutAttachment subresourceLayout : req.getSubresourceLayouts()) {
                if (subresourceLayout.getMipLevel() != level || subresourceLayout.getArrayLayer() != layer) continue;
                return subresourceLayout;
            }
        }
        return null;
    }

    public long getMemoryTypeBits() {
        return this.memoryTypeBits;
    }

    public void setMemoryTypeBits(long memoryTypeBits) {
        this.memoryTypeBits = memoryTypeBits;
    }

    public void setSourceImageAsset(@NonNull VkImageAsset sourceImageAsset) {
        this.sourceImageAsset = sourceImageAsset;
    }

    public @Nullable VkImageAsset getSourceImageAsset() {
        return this.sourceImageAsset;
    }

    public boolean isImageDataCopiedFromOtherAsset() {
        return this.imageDataIsCopiedFromOtherAsset;
    }

    public void setImageDataCopiedFromOtherAsset(boolean value) {
        this.imageDataIsCopiedFromOtherAsset = value;
    }

    @Override
    public @NonNull RGBAImageData getImageData() throws IImageProvider.ImageDataUnavailableException, IOException, IImageProvider.ImageConversionException {
        return VkImageAssetConverter.getImageData(this);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = super.getProperties();
        properties.put("Memory", this.memoryBinding != null ? this.memoryBinding : ValueAssetProperty.NONE);
        return properties;
    }

    public boolean isCompressed() {
        return KapiSpec.VULKAN.constantGroups.BLOCKCOMPRESSEDIMAGEFORMATS.contains(this.getFormat()) || KapiSpec.VULKAN.constantGroups.ETCCOMPRESSEDIMAGEFORMATS.contains(this.getFormat()) || KapiSpec.VULKAN.constantGroups.ASTCCOMPRESSEDIMAGEFORMATS.contains(this.getFormat());
    }

    @Override
    public IImageProvider getImageForm() {
        return this;
    }
}

