/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.IVkDeviceMemoryBackedAsset;
import com.arm.mgd.core.asset.IVulkanHandleAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractVkDeviceMemoryAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IMemoryRegionAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.utils.VersionProperties;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VkDeviceMemoryAsset
extends AbstractVkDeviceMemoryAsset
implements IVulkanHandleAsset {
    private static final long serialVersionUID = -6596295727151623210L;
    private final @NonNull Set<@NonNull IVkDeviceMemoryBackedAsset> boundMemoryAssets = new LinkedHashSet<IVkDeviceMemoryBackedAsset>(0);
    private final @NonNull List<@NonNull IMemoryRegionAttachment> contentsData = new ArrayList<IMemoryRegionAttachment>();

    public VkDeviceMemoryAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long handle, long allocationSize, long memoryTypeIndex) {
        super(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, handle, allocationSize, memoryTypeIndex);
    }

    public void addDataRegion(@Nullable FunctionCall previousModificationFunctionCall, @NonNull IMemoryRegionAttachment region) {
        this.contentsData.add(region);
        if (previousModificationFunctionCall != null) {
            this.setPreviousModificationFunction(previousModificationFunctionCall);
            for (IVkDeviceMemoryBackedAsset deviceMemoryBackedAsset : this.boundMemoryAssets) {
                deviceMemoryBackedAsset.setPreviousModificationFunction(previousModificationFunctionCall);
            }
        }
    }

    public byte @Nullable [] constructData(@NonNull IVkDeviceMemoryBackedAsset memoryAsset) {
        if (!this.boundMemoryAssets.contains(memoryAsset) || memoryAsset.getSize() > Integer.MAX_VALUE || memoryAsset.getSize() < 0L) {
            assert (this.boundMemoryAssets.contains(memoryAsset)) : "VkDeviceMemory cannot construct data for a buffer that was not bound to it.";
            assert (memoryAsset.getSize() < Integer.MAX_VALUE) : "Buffer is too big to be tracked by " + VersionProperties.FULL_PRODUCT_NAME + ".";
            assert (memoryAsset.getSize() > 0L) : "Buffer size is negative. (Possible overflow or bad constructor?)";
            return null;
        }
        byte[] returnVal = new byte[(int)memoryAsset.getSize()];
        for (IMemoryRegionAttachment attachment : this.contentsData) {
            attachment.copyIntoByteArray(memoryAsset.getOffset(), returnVal);
        }
        return returnVal;
    }

    public void bindMemoryAsset(@NonNull TraceStateSnapshot currentState, @Nullable FunctionCall functionCall, @NonNull IVkDeviceMemoryBackedAsset memoryAsset, long offset) {
        if (memoryAsset.isBound()) {
            TraceAnalysisLogger.warning(currentState, functionCall, "Attempt to bind a buffer to backing memory more than once.");
        }
        memoryAsset.bind(this, offset);
        this.boundMemoryAssets.add(memoryAsset);
    }

    public void unbindMemoryAsset(@NonNull IVkDeviceMemoryBackedAsset memoryAsset) {
        assert (this.boundMemoryAssets.contains(memoryAsset)) : String.format("Attempted to unbind buffer %s from DeviceMemory %s, but it was not bound.", memoryAsset.toString(), this.getHandle().toString());
        this.boundMemoryAssets.remove(memoryAsset);
    }

    public @NonNull Set<@NonNull IVkDeviceMemoryBackedAsset> getBoundMemoryAssets() {
        return this.boundMemoryAssets;
    }

    public @NonNull List<@NonNull IMemoryRegionAttachment> getMemoryRegionHistory() {
        return this.contentsData;
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = super.getProperties();
        properties.put("Bound Assets", new ListAssetProperty(new ArrayList<IVkDeviceMemoryBackedAsset>(this.boundMemoryAssets)));
        return properties;
    }
}

