/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.IVulkanHandleAsset;
import com.arm.mgd.core.asset.VkBufferAsset;
import com.arm.mgd.core.asset.VkBufferViewAsset;
import com.arm.mgd.core.asset.VkDescriptor;
import com.arm.mgd.core.asset.VkDescriptorBufferInfo;
import com.arm.mgd.core.asset.VkDescriptorImageInfo;
import com.arm.mgd.core.asset.VkDescriptorPoolAsset;
import com.arm.mgd.core.asset.VkDescriptorSetLayoutAsset;
import com.arm.mgd.core.asset.VkDescriptorTexelBufferView;
import com.arm.mgd.core.asset.VkImageViewAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractVkDescriptorSetAsset;
import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;

public class VkDescriptorSetAsset
extends AbstractVkDescriptorSetAsset
implements IVulkanHandleAsset {
    private static final long serialVersionUID = 4933600176854684455L;
    private Map<@NonNull Long, @NonNull List<@NonNull VkDescriptor>> bindings = new HashMap<Long, List<VkDescriptor>>();

    public VkDescriptorSetAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long handle, @NonNull VkDescriptorPoolAsset descriptorPool, @NonNull VkDescriptorSetLayoutAsset layoutAsset) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, handle, descriptorPool, layoutAsset);
    }

    public VkDescriptorSetAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long handle, @NonNull VkDescriptorPoolAsset descriptorPool, @NonNull VkDescriptorSetLayoutAsset layoutAsset) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, handle, descriptorPool, layoutAsset);
    }

    public void allocateDescriptors( @NonNull VULKAN.Structs.VkDescriptorSetLayoutBinding binding) {
        Long bindingNumber = binding.getBinding();
        @NonNull List<@NonNull VkDescriptor> descriptorArray = VkDescriptor.create(this, binding);
        this.bindings.put(bindingNumber, descriptorArray);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void updateDescriptors(@NonNull TraceStateSnapshot currentState,  @NonNull VULKAN.Structs.VkWriteDescriptorSet writeDescriptorSet) throws AbortActionException {
        Long dstBinding = writeDescriptorSet.getDstBinding();
        int dstArrayElement = (int)writeDescriptorSet.getDstArrayElement().longValue();
        int descriptorCount = (int)writeDescriptorSet.getDescriptorCount().longValue();
        @NonNull @NonNull List boundValues = (List)NullUtils.neverNull(this.bindings.get(dstBinding));
        if (descriptorCount <= 0 || dstArrayElement + descriptorCount > boundValues.size()) {
            throw new AbortActionException("Cannot update/write " + descriptorCount + " descriptors starting from " + dstArrayElement + " since bindings size is " + boundValues.size() + ".");
        }
        int i = dstArrayElement;
        while (i < dstArrayElement + descriptorCount) {
            VkDescriptor descriptor = (VkDescriptor)boundValues.get(dstArrayElement);
            if (descriptor instanceof VkDescriptorBufferInfo) {
                @NonNull List<VULKAN.Structs.VkDescriptorBufferInfo> bufferInfos = writeDescriptorSet.getPBufferInfo();
                this.writeDescriptorBufferInfo(currentState, (VkDescriptorBufferInfo)descriptor, bufferInfos.get(i));
            } else if (descriptor instanceof VkDescriptorImageInfo) {
                @NonNull List<VULKAN.Structs.VkDescriptorImageInfo> imageInfos = writeDescriptorSet.getPImageInfo();
                this.writeDescriptorImageInfo(currentState, (VkDescriptorImageInfo)descriptor, imageInfos.get(i));
            } else if (descriptor instanceof VkDescriptorTexelBufferView) {
                HandleArrayAttachment bufferViewsHandles = writeDescriptorSet.getPTexelBufferView();
                Handle bufferViewhandle = bufferViewsHandles.get(i);
                AssetTable bufferViewAssetTable = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFERVIEW_TRAITS.SPEC);
                assert (bufferViewAssetTable != null);
                VkBufferViewAsset bufferViewAsset = (VkBufferViewAsset)bufferViewAssetTable.get((Long)AssetProcessorBase.asAssetID(bufferViewhandle));
                if (bufferViewAsset == null) {
                    throw new AbortActionException("Failed getting buffer view asset " + bufferViewhandle + " on writing descriptor " + descriptor.getBinding() + " of descriptor set " + this.getHandle() + ".");
                }
                VkDescriptorSetAsset.writeDescriptorBufferView((VkDescriptorTexelBufferView)descriptor, bufferViewAsset);
            }
            ++i;
        }
    }

    private void writeDescriptorBufferInfo(@NonNull TraceStateSnapshot currentState, @NonNull VkDescriptorBufferInfo descriptor, VULKAN.Structs.VkDescriptorBufferInfo bufferInfo) throws AbortActionException {
        AssetTable bufferAssetTable = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS.SPEC);
        assert (bufferAssetTable != null);
        Handle bufferHandle = bufferInfo.getBuffer();
        VkBufferAsset bufferAsset = (VkBufferAsset)bufferAssetTable.get((Long)AssetProcessorBase.asAssetID(bufferHandle));
        if (bufferAsset == null) {
            throw new AbortActionException("Failed getting buffer asset " + bufferHandle + "on writing descriptor " + descriptor.getBinding() + " of descriptor set " + this.getHandle() + ".");
        }
        descriptor.write(bufferAsset, (int)bufferInfo.getOffset().longValue(), (int)bufferInfo.getRange().longValue());
    }

    private void writeDescriptorImageInfo(@NonNull TraceStateSnapshot currentState, @NonNull VkDescriptorImageInfo descriptor, VULKAN.Structs.VkDescriptorImageInfo imageInfo) throws AbortActionException {
        AssetTable imageViewAssetTable = currentState.getAssetTableBySpec(KapiSpec.VULKAN.assetTables.IMAGEVIEW_TRAITS.SPEC);
        assert (imageViewAssetTable != null);
        Handle samplerHandle = imageInfo.getSampler();
        AbstractConstantOrAliasSpecExtended imageLayout = imageInfo.getImageLayout();
        Handle imageViewHandle = imageInfo.getImageView();
        VkImageViewAsset imageViewAsset = (VkImageViewAsset)imageViewAssetTable.get((Long)AssetProcessorBase.asAssetID(imageViewHandle));
        if (imageViewAsset == null) {
            throw new AbortActionException("Failed getting image view asset " + imageViewHandle + " on writing descriptor " + descriptor.getBinding() + " of descriptor set " + this.getHandle() + ".");
        }
        descriptor.write(samplerHandle, imageViewAsset, imageLayout);
    }

    private static void writeDescriptorBufferView(@NonNull VkDescriptorTexelBufferView descriptor, @NonNull VkBufferViewAsset bufferViewAsset) {
        descriptor.write(bufferViewAsset);
    }

    public void updateDescriptors(@NonNull TraceStateSnapshot currentState,  @NonNull VULKAN.Structs.VkCopyDescriptorSet copyDescriptorSet) {
    }
}

