/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.VkDescriptorBufferInfo;
import com.arm.mgd.core.asset.VkDescriptorImageInfo;
import com.arm.mgd.core.asset.VkDescriptorSetAsset;
import com.arm.mgd.core.asset.VkDescriptorTexelBufferView;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.DefaultLocation;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;

@NonNullByDefault(value={DefaultLocation.FIELD, DefaultLocation.PARAMETER, DefaultLocation.RETURN_TYPE})
public abstract class VkDescriptor
implements Serializable {
    private static final long serialVersionUID = 7363856268046087895L;
    protected static final byte[] EMPTY_ARRAY = new byte[0];
    private VkDescriptorSetAsset parentDescriptorSetAsset;
    private VULKAN.Structs.VkDescriptorSetLayoutBinding binding;
    private int arrayElement = 0;

    public static List<@NonNull VkDescriptor> create(VkDescriptorSetAsset parentDescriptorSetAsset, VULKAN.Structs.VkDescriptorSetLayoutBinding binding) {
        @NonNull ArrayList<@NonNull VkDescriptor> descriptorArray = new ArrayList<VkDescriptor>();
        if (binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_SAMPLER) || binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER) || binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE) || binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_STORAGE_IMAGE) || binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT)) {
            int i = 0;
            while ((long)i < binding.getDescriptorCount()) {
                VkDescriptorImageInfo descriptorImageInfo = new VkDescriptorImageInfo(parentDescriptorSetAsset, binding, i);
                descriptorArray.add(descriptorImageInfo);
                ++i;
            }
        } else if (binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER) || binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER)) {
            int i = 0;
            while ((long)i < binding.getDescriptorCount()) {
                VkDescriptorTexelBufferView descriptorBufferView = new VkDescriptorTexelBufferView(parentDescriptorSetAsset, binding, i);
                descriptorArray.add(descriptorBufferView);
                ++i;
            }
        } else if (binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER) || binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_STORAGE_BUFFER) || binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC) || binding.getDescriptorType().equals(KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC)) {
            int i = 0;
            while ((long)i < binding.getDescriptorCount()) {
                VkDescriptorBufferInfo descriptorBufferInfo = new VkDescriptorBufferInfo(parentDescriptorSetAsset, binding, i);
                descriptorArray.add(descriptorBufferInfo);
                ++i;
            }
        } else {
            throw new IllegalArgumentException("Cannot create descriptor using binding type: " + binding.toString());
        }
        return descriptorArray;
    }

    protected VkDescriptor(VkDescriptorSetAsset parentDescriptorSetAsset, VULKAN.Structs.VkDescriptorSetLayoutBinding binding, int arrayElement) {
        this.parentDescriptorSetAsset = parentDescriptorSetAsset;
        this.binding = binding;
        this.arrayElement = arrayElement;
    }

    public VkDescriptorSetAsset getParentDescriptorSet() {
        return this.parentDescriptorSetAsset;
    }

    public long getBinding() {
        return this.binding.getBinding();
    }

    public AbstractConstantOrAliasSpecExtended getDescriptorType() {
        return this.binding.getDescriptorType();
    }

    public byte[] getData() {
        return EMPTY_ARRAY;
    }

    public String getContent() {
        if (this.getData().length > 0) {
            StringBuilder sb = new StringBuilder();
            ByteBuffer bb = ByteBuffer.wrap(this.getData());
            sb.append(Long.toHexString(bb.getLong()));
            return (String)NullUtils.neverNull((Object)sb.toString());
        }
        return "<no data>";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Descriptor (binding point: ");
        sb.append(this.getBinding());
        if (this.getDescriptorCount() > 1L) {
            sb.append(", array element: ").append(this.arrayElement);
        }
        sb.append(")");
        return (String)NullUtils.neverNull((Object)sb.toString());
    }

    private long getDescriptorCount() {
        return this.binding.getDescriptorCount();
    }
}

