/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.VkBufferAsset;
import com.arm.mgd.core.asset.VkCommand;
import com.arm.mgd.core.asset.VkDeviceMemoryAsset;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.processors.MissingAssetException;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.target.data.AbstractContainerWrapperType;
import com.arm.mgd.core.target.data.ApiUsageException;
import com.arm.mgd.core.target.data.EmulatedVulkanDeviceMemoryContents;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;

public class VkCommandsSequence
implements Serializable {
    private static final long serialVersionUID = 4346157410685258157L;
    private final @NonNull List<@NonNull VkCommand> commands = new ArrayList<VkCommand>();

    public void record(@NonNull VkCommand command) {
        this.commands.add(command);
    }

    public @NonNull List<@NonNull VkCommand> getCommands() {
        return NullUtils.unmodifiableList(this.commands);
    }

    public void updateDeviceMemory(@NonNull TraceStateSnapshot snapshot, @NonNull FunctionCall modifyingFunctionCall) {
        List<VkCommand> localCommands = this.getCommands();
        for (VkCommand command : localCommands) {
            @NonNull FunctionCall fc = command.getFunction();
            @NonNull IFunctionOrAliasSpecExtended spec = fc.getFunctionSpec();
            try {
                VkImageAsset dstImage;
                long dstImageId;
                VkImageAsset srcImage;
                List<AbstractContainerWrapperType> regions;
                VkBufferAsset dstBuffer;
                long dstBufferId;
                VkBufferAsset srcBuffer;
                if (spec.equals(KapiSpec.VULKAN.functions.VKCMDCOPYBUFFER)) {
                    long srcBufferId = AssetProcessorBase.asAssetID(VULKAN.VkCmdCopyBufferDecorator.getArgumentSrcBuffer(fc));
                    srcBuffer = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, snapshot, modifyingFunctionCall, AssetProcessorBase.getVkBufferAsset(snapshot, modifyingFunctionCall, srcBufferId), srcBufferId);
                    dstBufferId = AssetProcessorBase.asAssetID(VULKAN.VkCmdCopyBufferDecorator.getArgumentDstBuffer(fc));
                    dstBuffer = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, snapshot, modifyingFunctionCall, AssetProcessorBase.getVkBufferAsset(snapshot, modifyingFunctionCall, dstBufferId), dstBufferId);
                    regions = VULKAN.VkCmdCopyBufferDecorator.getArgumentPRegions(fc);
                    VkCommandsSequence.emulateVkCmdCopyBuffer(modifyingFunctionCall, srcBuffer, dstBuffer, regions);
                    continue;
                }
                if (spec.equals(KapiSpec.VULKAN.functions.VKCMDCOPYIMAGE)) {
                    long srcImageId = AssetProcessorBase.asAssetID(VULKAN.VkCmdCopyImageDecorator.getArgumentSrcImage(fc));
                    srcImage = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, snapshot, modifyingFunctionCall, AssetProcessorBase.getVkImageAsset(snapshot, modifyingFunctionCall, srcImageId), srcImageId);
                    dstImageId = AssetProcessorBase.asAssetID(VULKAN.VkCmdCopyImageDecorator.getArgumentDstImage(fc));
                    dstImage = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, snapshot, modifyingFunctionCall, AssetProcessorBase.getVkImageAsset(snapshot, modifyingFunctionCall, dstImageId), dstImageId);
                    regions = VULKAN.VkCmdCopyImageDecorator.getArgumentPRegions(fc);
                    VkCommandsSequence.emulateVkCmdCopyImage(modifyingFunctionCall, srcImage, dstImage, regions);
                    continue;
                }
                if (spec.equals(KapiSpec.VULKAN.functions.VKCMDCOPYBUFFERTOIMAGE)) {
                    long srcBufferId = AssetProcessorBase.asAssetID(VULKAN.VkCmdCopyBufferToImageDecorator.getArgumentSrcBuffer(fc));
                    srcBuffer = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, snapshot, modifyingFunctionCall, AssetProcessorBase.getVkBufferAsset(snapshot, modifyingFunctionCall, srcBufferId), srcBufferId);
                    dstImageId = AssetProcessorBase.asAssetID(VULKAN.VkCmdCopyBufferToImageDecorator.getArgumentDstImage(fc));
                    dstImage = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, snapshot, modifyingFunctionCall, AssetProcessorBase.getVkImageAsset(snapshot, modifyingFunctionCall, dstImageId), dstImageId);
                    regions = VULKAN.VkCmdCopyBufferToImageDecorator.getArgumentPRegions(fc);
                    VkCommandsSequence.emulateVkCmdCopyBufferToImage(modifyingFunctionCall, srcBuffer, dstImage, regions);
                    continue;
                }
                if (!spec.equals(KapiSpec.VULKAN.functions.VKCMDCOPYIMAGETOBUFFER)) continue;
                long srcImageId = AssetProcessorBase.asAssetID(VULKAN.VkCmdCopyImageToBufferDecorator.getArgumentSrcImage(fc));
                srcImage = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.IMAGE_TRAITS, snapshot, modifyingFunctionCall, AssetProcessorBase.getVkImageAsset(snapshot, modifyingFunctionCall, srcImageId), srcImageId);
                dstBufferId = AssetProcessorBase.asAssetID(VULKAN.VkCmdCopyImageToBufferDecorator.getArgumentDstBuffer(fc));
                dstBuffer = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.BUFFER_TRAITS, snapshot, modifyingFunctionCall, AssetProcessorBase.getVkBufferAsset(snapshot, modifyingFunctionCall, dstBufferId), dstBufferId);
                regions = VULKAN.VkCmdCopyImageToBufferDecorator.getArgumentPRegions(fc);
                VkCommandsSequence.emulateVkCmdCopyImageToBuffer(modifyingFunctionCall, srcImage, dstBuffer, regions);
            }
            catch (MissingAssetException | ApiUsageException e) {
                TraceAnalysisLogger.error(snapshot, fc, e.getMessage());
            }
            catch (AbortActionException e) {
                TraceAnalysisLogger.warning(snapshot, fc, e.getMessage());
            }
        }
    }

    public static void emulateVkCmdCopyBuffer(@NonNull FunctionCall modifyingFunctionCall, @NonNull VkBufferAsset source, @NonNull VkBufferAsset destination, @NonNull List< @NonNull VULKAN.Structs.VkBufferCopy> regions) throws ApiUsageException {
        VkDeviceMemoryAsset sourceMemory = source.getBackingMemory();
        if (!source.isBound() || sourceMemory == null) {
            throw new ApiUsageException("VkCmdCopyBuffer source buffer has no memory bound");
        }
        VkDeviceMemoryAsset destinationMemory = destination.getBackingMemory();
        if (!destination.isBound() || destinationMemory == null) {
            throw new ApiUsageException("VkCmdCopyBuffer destination buffer has no memory bound");
        }
        for (VULKAN.Structs.VkBufferCopy region : regions) {
            EmulatedVulkanDeviceMemoryContents memContents = new EmulatedVulkanDeviceMemoryContents(sourceMemory, source.getOffset() + region.getSrcOffset(), 0L, destinationMemory.getId(), destination.getOffset() + region.getDstOffset(), (int)region.getSize().longValue());
            destinationMemory.addDataRegion(modifyingFunctionCall, memContents);
        }
    }

    public static void emulateVkCmdCopyImage(@NonNull FunctionCall modifyingFunctionCall, @NonNull VkImageAsset source, @NonNull VkImageAsset destination, @NonNull List< @NonNull VULKAN.Structs.VkImageCopy> regions) throws AbortActionException {
        VULKAN.Structs.VkExtent3D dstExtent;
        VkDeviceMemoryAsset sourceMemory = source.getBackingMemory();
        if (!source.isBound() || sourceMemory == null) {
            throw new ApiUsageException("vkCmdCopyImage source image has no memory bound");
        }
        VkDeviceMemoryAsset destinationMemory = destination.getBackingMemory();
        if (!destination.isBound() || destinationMemory == null) {
            throw new ApiUsageException("vkCmdCopyImage destination image has no memory bound");
        }
        if (regions.isEmpty()) {
            throw new ApiUsageException("vkCmdCopyImage must have at least one region");
        }
        if (regions.size() != 1) {
            throw new AbortActionException("vkCmdCopyImage effects are not emulated for calls with more than one region");
        }
         @NonNull VULKAN.Structs.VkExtent3D srcExtent = source.getExtent();
        if (!VkCommandsSequence.compareExtent3D(srcExtent, dstExtent = destination.getExtent())) {
            throw new AbortActionException("vkCmdCopyImage effects are not emulated for calls with images with different extents");
        }
        VULKAN.Structs.VkImageCopy region = regions.get(0);
        VULKAN.Structs.VkImageSubresourceLayers sourceImageSubresource = region.getSrcSubresource();
        VULKAN.Structs.VkImageSubresourceLayers destImageSubresource = region.getDstSubresource();
        if (sourceImageSubresource.getMipLevel() != 0L || sourceImageSubresource.getBaseArrayLayer() != 0L) {
            throw new AbortActionException("vkCmdCopyImage effects are not emulated for calls where the source subresource is not mip level 0, layer 0");
        }
        if (destImageSubresource.getMipLevel() != 0L || destImageSubresource.getBaseArrayLayer() != 0L) {
            throw new AbortActionException("vkCmdCopyImage effects are not emulated for calls where the destination subresource is not mip level 0, layer 0");
        }
        if (sourceImageSubresource.getLayerCount() != 1L || destImageSubresource.getLayerCount() != 1L) {
            throw new AbortActionException("vkCmdCopyImage effects are not emulated for calls where the source or destination subresource layer count is not 1");
        }
        if (region.getSrcOffset().getX() != 0L || region.getSrcOffset().getY() != 0L || region.getSrcOffset().getZ() != 0L) {
            throw new AbortActionException("vkCmdCopyImage effects are not emulated for calls with a non-zero source offset");
        }
        if (region.getDstOffset().getX() != 0L || region.getDstOffset().getY() != 0L || region.getDstOffset().getZ() != 0L) {
            throw new AbortActionException("vkCmdCopyImage effects are not emulated for calls with a non-zero destination offset");
        }
        VULKAN.Structs.VkExtent3D sourceRegionExtent = region.getExtent();
        if (!VkCommandsSequence.compareExtent3D(sourceRegionExtent, srcExtent)) {
            throw new AbortActionException("vkCmdCopyImage effects are not emulated when the copy extent is not equal to the source image extent");
        }
        EmulatedVulkanDeviceMemoryContents memContents = new EmulatedVulkanDeviceMemoryContents(sourceMemory, source.getOffset(), 0L, destinationMemory.getId(), destination.getOffset(), (int)source.getSize());
        destinationMemory.addDataRegion(modifyingFunctionCall, memContents);
        destination.setSourceImageAsset(source);
        destination.setImageDataCopiedFromOtherAsset(true);
    }

    public static void emulateVkCmdCopyBufferToImage(@NonNull FunctionCall modifyingFunctionCall, @NonNull VkBufferAsset source, @NonNull VkImageAsset destination, @NonNull List< @NonNull VULKAN.Structs.VkBufferImageCopy> regions) throws AbortActionException {
        boolean isBufferImageHeightSupported;
        VkDeviceMemoryAsset sourceMemory = source.getBackingMemory();
        if (!source.isBound() || sourceMemory == null) {
            throw new ApiUsageException("vkCmdCopyBufferToImage source buffer has no bound memory");
        }
        VkDeviceMemoryAsset destinationMemory = destination.getBackingMemory();
        if (!destination.isBound() || destinationMemory == null) {
            throw new ApiUsageException("vkCmdCopyBufferToImage destination image has no bound memory");
        }
        if (regions.isEmpty()) {
            throw new ApiUsageException("vkCmdCopyBufferToImage must have at least one region");
        }
        if (regions.size() != 1) {
            throw new AbortActionException("vkCmdCopyBufferToImage effects are not emulated for calls with more than one region");
        }
        VULKAN.Structs.VkBufferImageCopy region = regions.get(0);
        boolean isBufferRowLengthSupported = destination.isCompressed() || region.getBufferRowLength() == 0L || region.getBufferRowLength().longValue() == region.getImageExtent().getWidth().longValue();
        boolean bl = isBufferImageHeightSupported = destination.isCompressed() || region.getBufferImageHeight() == 0L || region.getBufferImageHeight().longValue() == region.getImageExtent().getHeight().longValue();
        if (!isBufferRowLengthSupported || !isBufferImageHeightSupported) {
            throw new AbortActionException("vkCmdCopyBufferToImage effects are not emulated for copies with regions that are not tightly packed");
        }
        VULKAN.Structs.VkImageSubresourceLayers imageSubresource = region.getImageSubresource();
        if (imageSubresource.getMipLevel() != 0L || imageSubresource.getBaseArrayLayer() != 0L) {
            throw new AbortActionException("vkCmdCopyBufferToImage effects are not emulated for calls where the image subresource is not mip level 0, layer 0");
        }
        if (imageSubresource.getLayerCount() != 1L) {
            throw new AbortActionException("vkCmdCopyBufferToImage effects are not emulated for calls where the image subresource layer count is not 1");
        }
        if (region.getImageOffset().getX() != 0L || region.getImageOffset().getY() != 0L || region.getImageOffset().getZ() != 0L) {
            throw new AbortActionException("vkCmdCopyBufferToImage effects are not emulated for calls with a non-zero image offset");
        }
        EmulatedVulkanDeviceMemoryContents memContents = new EmulatedVulkanDeviceMemoryContents(sourceMemory, source.getOffset() + region.getBufferOffset(), 0L, destinationMemory.getId(), destination.getOffset(), (int)source.getSize());
        destinationMemory.addDataRegion(modifyingFunctionCall, memContents);
        destination.setImageDataCopiedFromOtherAsset(true);
    }

    public static void emulateVkCmdCopyImageToBuffer(@NonNull FunctionCall modifyingFunctionCall, @NonNull VkImageAsset source, @NonNull VkBufferAsset destination, @NonNull List< @NonNull VULKAN.Structs.VkBufferImageCopy> regions) throws AbortActionException {
        VkDeviceMemoryAsset sourceMemory = source.getBackingMemory();
        if (!source.isBound() || sourceMemory == null) {
            throw new ApiUsageException("vkCmdCopyImageToBuffer source buffer has no bound memory");
        }
        VkDeviceMemoryAsset destinationMemory = destination.getBackingMemory();
        if (!destination.isBound() || destinationMemory == null) {
            throw new ApiUsageException("vkCmdCopyImageToBuffer destination image has no bound memory");
        }
        if (regions.isEmpty()) {
            throw new ApiUsageException("vkCmdCopyImageToBuffer must have at least one region");
        }
        throw new AbortActionException("vkCmdCopyImageToBuffer effects are not emulated");
    }

    private static boolean compareExtent3D(VULKAN.Structs.VkExtent3D first, VULKAN.Structs.VkExtent3D second) {
        return first.getDepth().longValue() == second.getDepth().longValue() && first.getHeight().longValue() == second.getHeight().longValue() && first.getDepth().longValue() == second.getDepth().longValue();
    }
}

