/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.IVulkanHandleAsset;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.VkCommand;
import com.arm.mgd.core.asset.VkCommandsSequence;
import com.arm.mgd.core.asset.VkFramebufferAsset;
import com.arm.mgd.core.asset.VkRenderPassAsset;
import com.arm.mgd.core.asset.VkRenderPassInstance;
import com.arm.mgd.core.asset.objects.gen.AbstractVkCommandBufferAsset;
import com.arm.mgd.core.asset.processors.AbortActionException;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VkCommandBufferAsset
extends AbstractVkCommandBufferAsset
implements IVulkanHandleAsset {
    private static final long serialVersionUID = 5137753281483202386L;
    private final @NonNull List<@NonNull VkRenderPassInstance> renderPassInstances;
    private @NonNull VkCommandsSequence commandsSequence;
    private @Nullable VkRenderPassInstance currentRenderPassInstance = null;
    private long renderPassInstanceNo = 0L;
    private @Nullable VkFramebufferAsset inheritedFramebuffer = null;
    private @Nullable VkRenderPassAsset inheritedRenderpass = null;
    private State currentState = State.INITIAL;

    public VkCommandBufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id, @NonNull Handle commandPool, @NonNull Pointer device, @NonNull AbstractConstantOrAliasSpecExtended level) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id, commandPool, device, level);
        this.renderPassInstances = new ArrayList<VkRenderPassInstance>();
        this.commandsSequence = new VkCommandsSequence();
    }

    public VkCommandBufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id, @NonNull Handle commandPoolHandle, @NonNull Pointer deviceHandle, @NonNull AbstractConstantOrAliasSpecExtended level) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, commandPoolHandle, deviceHandle, level);
    }

    public void reset() {
        this.renderPassInstanceNo = 0L;
        this.renderPassInstances.clear();
        this.commandsSequence = new VkCommandsSequence();
        this.currentRenderPassInstance = null;
        this.currentState = State.INITIAL;
        this.inheritedFramebuffer = null;
        this.inheritedRenderpass = null;
    }

    public void begin(@NonNull TraceStateSnapshot currentSnapshot, @NonNull FunctionCall functionCall) throws AbortActionException {
        if (this.currentState == State.RECORDING) {
            throw new AbortActionException("The command buffer must not be in the recording state when it is begun");
        }
        this.reset();
        this.currentState = State.RECORDING;
        VULKAN.Structs.VkCommandBufferInheritanceInfo inheritanceInfo = this.getInheritanceInfo();
        if (inheritanceInfo != null && !inheritanceInfo.getContainer().isNull()) {
            Handle framebufferHandle = inheritanceInfo.getFramebuffer();
            Handle renderPassHandle = inheritanceInfo.getRenderPass();
            if (!framebufferHandle.isEmptyHandle()) {
                this.inheritedFramebuffer = AssetProcessorBase.getVkFramebufferAsset(currentSnapshot, functionCall, AssetProcessorBase.asAssetID(framebufferHandle));
            }
            if (!renderPassHandle.isEmptyHandle()) {
                this.inheritedRenderpass = AssetProcessorBase.getVkRenderPassAsset(currentSnapshot, functionCall, AssetProcessorBase.asAssetID(renderPassHandle));
            }
        }
    }

    public void end() throws AbortActionException {
        if (this.currentState != State.RECORDING) {
            throw new AbortActionException("The command buffer must be in the recording state before it can be ended");
        }
        this.currentState = State.EXECUTABLE;
    }

    public void record(@NonNull TraceStateSnapshot currentSnapshot, @NonNull VkCommand command) throws AbortActionException {
        FunctionCall functionCall = command.getFunction();
        if (this.getState().equals((Object)State.RECORDING)) {
            this.setPreviousModificationFunction(functionCall);
            boolean shouldAddCommandToRenderPassInstance = true;
            if (functionCall.getFunctionSpec().equals(KapiSpec.VULKAN.functions.VKCMDBEGINRENDERPASS)) {
                this.onRecordBeginRenderPass(currentSnapshot, command);
                shouldAddCommandToRenderPassInstance = false;
            } else if (functionCall.getFunctionSpec().equals(KapiSpec.VULKAN.functions.VKCMDENDRENDERPASS)) {
                this.onRecordEndRenderPass(command);
                shouldAddCommandToRenderPassInstance = false;
            } else if (functionCall.getFunctionSpec().equals(KapiSpec.VULKAN.functions.VKCMDNEXTSUBPASS)) {
                this.onRecordNextSubpass(command);
            } else if (functionCall.getFunctionSpec().equals(KapiSpec.VULKAN.functions.VKCMDEXECUTECOMMANDS)) {
                this.onRecordExecuteCommands(currentSnapshot, command);
            }
            this.commandsSequence.record(command);
            if (shouldAddCommandToRenderPassInstance && this.currentRenderPassInstance != null) {
                this.currentRenderPassInstance.record(currentSnapshot, command);
            }
        }
    }

    private void onRecordBeginRenderPass(@NonNull TraceStateSnapshot currentSnapshot, @NonNull VkCommand command) throws AbortActionException {
        if (this.currentRenderPassInstance != null) {
            throw new AbortActionException("Cannot begin render pass while there is already an active render pass");
        }
        FunctionCall fc = command.getFunction();
        AbstractConstantOrAliasSpecExtended contents = VULKAN.VkCmdBeginRenderPassDecorator.getArgumentContents(fc);
        VULKAN.Structs.VkRenderPassBeginInfo beginInfo = VULKAN.VkCmdBeginRenderPassDecorator.getArgumentPRenderPassBegin(fc);
        if (beginInfo.getContainer().isNull()) {
            throw new AbortActionException("Render pass begin info is null");
        }
        Handle renderPassHandle = beginInfo.getRenderPass();
        Handle framebufferHandle = beginInfo.getFramebuffer();
        long renderPassAssetId = AssetProcessorBase.asAssetID(renderPassHandle);
        VkRenderPassAsset renderPassAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.RENDERPASS_TRAITS, currentSnapshot, fc, AssetProcessorBase.getVkRenderPassAsset(currentSnapshot, fc, renderPassAssetId), renderPassAssetId);
        long framebufferAssetId = AssetProcessorBase.asAssetID(framebufferHandle);
        VkFramebufferAsset framebufferAsset = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.FRAMEBUFFER_TRAITS, currentSnapshot, fc, AssetProcessorBase.getVkFramebufferAsset(currentSnapshot, fc, framebufferAssetId), framebufferAssetId);
        VkRenderPassInstance renderPassInstance = renderPassAsset.createRenderPassInstance(command, framebufferAsset, contents, this, this.renderPassInstanceNo);
        this.renderPassInstances.add(renderPassInstance);
        this.currentRenderPassInstance = renderPassInstance;
        ++this.renderPassInstanceNo;
    }

    private void onRecordEndRenderPass(@NonNull VkCommand command) throws AbortActionException {
        if (this.currentRenderPassInstance == null) {
            throw new AbortActionException("Cannot end render pass while there is no active render pass");
        }
        this.currentRenderPassInstance.end(command);
        this.currentRenderPassInstance = null;
    }

    private void onRecordNextSubpass(@NonNull VkCommand command) throws AbortActionException {
        AbstractConstantOrAliasSpecExtended contents = VULKAN.VkCmdNextSubpassDecorator.getArgumentContents(command.getFunction());
        if (this.currentRenderPassInstance == null) {
            throw new AbortActionException("Cannot move to the next sub pass while there is no active render pass");
        }
        this.currentRenderPassInstance.nextSubpass(contents);
    }

    private void onRecordExecuteCommands(@NonNull TraceStateSnapshot currentSnapshot, @NonNull VkCommand command) throws AbortActionException {
        @NonNull FunctionCall fc = command.getFunction();
        @NonNull LongsArgAttachment pCommandBuffers = VULKAN.VkCmdExecuteCommandsDecorator.getArgumentPCommandBuffers(command.getFunction());
        ArrayList<@NonNull VkCommandBufferAsset> secondaryCommandBuffers = new ArrayList<VkCommandBufferAsset>(pCommandBuffers.size());
        for (Long secondaryCommandBufferAssetId : AssetProcessorBase.asAssetIDs(pCommandBuffers)) {
            VkCommandBufferAsset secondaryCommandBuffer = AssetProcessorBase.requireAsset(KapiSpec.VULKAN.assetTables.COMMANDBUFFER_TRAITS, currentSnapshot, fc, AssetProcessorBase.getVkCommandBufferAsset(currentSnapshot, fc, secondaryCommandBufferAssetId), (long)secondaryCommandBufferAssetId);
            if (secondaryCommandBuffer.getLevel() != KapiSpec.VULKAN.constants.VK_COMMAND_BUFFER_LEVEL_SECONDARY) {
                throw new AbortActionException("Command buffer " + secondaryCommandBufferAssetId + " must be a secondary command buffer to be executed");
            }
            if (secondaryCommandBuffer.getState() != State.EXECUTABLE) {
                throw new AbortActionException("Secondary command buffer " + secondaryCommandBufferAssetId + " must be in the executable state to be executed");
            }
            secondaryCommandBuffers.add(secondaryCommandBuffer);
        }
        if (this.currentRenderPassInstance != null) {
            this.currentRenderPassInstance.recordExecuteCommands(command, secondaryCommandBuffers);
        }
    }

    public void updateDeviceMemory(@NonNull TraceStateSnapshot snapshot, @NonNull FunctionCall modifyingFunctionCall) {
        this.commandsSequence.updateDeviceMemory(snapshot, modifyingFunctionCall);
    }

    public @NonNull List<@NonNull VkCommand> getCommands() {
        return this.commandsSequence.getCommands();
    }

    public State getState() {
        return this.currentState;
    }

    public static @NonNull VkCommandBufferAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull Handle commandPoolHandle, @NonNull Pointer deviceHandle, @NonNull AbstractConstantOrAliasSpecExtended level) {
        return new VkCommandBufferAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId(), commandPoolHandle, deviceHandle, level);
    }

    public @NonNull List<@NonNull VkRenderPassInstance> getRenderPassInstances() {
        return this.renderPassInstances;
    }

    private @NonNull List<@NonNull VkCommand.VkCommandAssetPropertyProvider> getCommandsAsAssetPropertyProviders() {
        @NonNull List<@NonNull VkCommand> commands = this.commandsSequence.getCommands();
        @NonNull ArrayList<@NonNull VkCommand.VkCommandAssetPropertyProvider> commandAssetProperties = new ArrayList<VkCommand.VkCommandAssetPropertyProvider>(commands.size());
        @NonNull TraceStateSnapshot snapshot = this.getSnapshotAssetParent().getTraceStateSnapshot();
        commands.forEach(command -> {
            boolean bl = commandAssetProperties.add(command.getAsAssetProperty(snapshot));
        });
        return commandAssetProperties;
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = super.getProperties();
        assert (properties.containsKey("inheritanceInfo"));
        if (this.inheritedFramebuffer != null || this.inheritedRenderpass != null) {
            HashMap<@NonNull String, @Nullable IAssetProperty> propertyResolutionMap = new HashMap<String, IAssetProperty>();
            propertyResolutionMap.put("framebuffer", this.inheritedFramebuffer);
            propertyResolutionMap.put("renderPass", this.inheritedRenderpass);
            properties.put("inheritanceInfo", VkAssetPropertyFormatter.getAssetViewProperty(this.getInheritanceInfo(), propertyResolutionMap));
        }
        properties.put("Commands", new ListAssetProperty(this.getCommandsAsAssetPropertyProviders()));
        return properties;
    }

    public static enum State {
        INITIAL,
        RECORDING,
        EXECUTABLE;

    }
}

