/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ICreatableAndModifiable;
import com.arm.mgd.core.asset.IVulkanHandleAsset;
import com.arm.mgd.core.asset.VkAssetPropertyFormatter;
import com.arm.mgd.core.asset.VkBufferAsset;
import com.arm.mgd.core.asset.VkCommandBufferAsset;
import com.arm.mgd.core.asset.VkDescriptorSetAsset;
import com.arm.mgd.core.asset.VkFramebufferAsset;
import com.arm.mgd.core.asset.VkGraphicsPipelineAsset;
import com.arm.mgd.core.asset.VkImageAsset;
import com.arm.mgd.core.asset.VkPipelineAsset;
import com.arm.mgd.core.asset.VkPipelineLayoutAsset;
import com.arm.mgd.core.asset.VkRenderPassAsset;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.IAssetPropertyProvider;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.IFunctionOrAliasSpecExtended;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.kapi.spec.VULKAN;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.lang.handle.Handle;
import com.arm.mgd.core.lang.handle.HandleArrayAttachment;
import com.arm.mgd.core.target.data.AbstractContainerWrapperType;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FloatsArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IArgument;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VkCommand
implements Serializable {
    private static final long serialVersionUID = -6707773560352971585L;
    private static final Map<@NonNull IFunctionOrAliasSpecExtended, @Nullable VkCommandFactory> commandCreateMap = VkCommand.createMap();
    protected final @NonNull FunctionCall functionCall;

    private VkCommand(@NonNull FunctionCall functionCall) {
        this.functionCall = functionCall;
    }

    public static @NonNull VkCommand createFromFunctionCall(@NonNull FunctionCall functionCall) {
        IFunctionOrAliasSpecExtended spec = functionCall.getFunctionSpec();
        assert (spec.isVulkanCommand());
        VkCommandFactory commandFactory = commandCreateMap.get(spec);
        if (commandFactory == null) {
            throw new AssertionError(functionCall);
        }
        return commandFactory.create(functionCall);
    }

    public @NonNull String getName() {
        return (String)NullUtils.neverNull((Object)this.functionCall.getFunctionSpec().getName());
    }

    public @NonNull FunctionCall getFunction() {
        return this.functionCall;
    }

    public boolean isDrawCommand() {
        return this.functionCall.getFunctionSpec().isVulkanDrawCommand();
    }

    public @NonNull Handle getCommandBufferHandle() {
        Pointer commandBufferHandle = (Pointer)this.functionCall.getArgValue(0);
        return Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, commandBufferHandle.address());
    }

    public @NonNull VkCommandAssetPropertyProvider getAsAssetProperty(@NonNull TraceStateSnapshot currentState) {
        return new VkCommandAssetPropertyProvider(this, currentState);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VkCommand) {
            return this.functionCall.equals(((VkCommand)obj).functionCall);
        }
        return false;
    }

    public int hashCode() {
        return this.functionCall.hashCode();
    }

    protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
    }

    protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
        return NullUtils.EMPTY_MAP;
    }

    private @NonNull VkCommandBufferState getCommandBufferState(@NonNull TraceStateSnapshot currentState) {
        VkCommandBufferState state = new VkCommandBufferState();
        @Nullable VkCommandBufferAsset commandBuffer = VkCommand.getVkCommandBufferAsset(currentState, this.functionCall, this.getCommandBufferHandle());
        if (commandBuffer != null) {
            List<@NonNull VkCommand> commands = commandBuffer.getCommands();
            for (VkCommand currentCommand : commands) {
                currentCommand.updateCommandState(currentState, state);
                if (this == currentCommand) break;
            }
        }
        return state;
    }

    private static @Nullable AssetPropertyContainer getAssetPropertiesForDescriptorSetBindings(@NonNull Map<Long, VkDescriptorSetBinding> descriptorSetBindings) {
        if (descriptorSetBindings.size() == 0) {
            return null;
        }
        AssetPropertyContainer properties = new AssetPropertyContainer();
        for (Map.Entry<Long, VkDescriptorSetBinding> set : descriptorSetBindings.entrySet()) {
            LinkedHashMap<@NonNull String, @Nullable IAssetProperty> setProps = new LinkedHashMap<String, IAssetProperty>();
            VkDescriptorSetBinding binding = set.getValue();
            setProps.put("Descriptor Set", binding.descriptorSet);
            setProps.put("Pipeline Layout", binding.pipelineLayout);
            if (binding.dynamicOffsets == null) continue;
            List<@NonNull Long> dynamicOffsets = binding.dynamicOffsets;
            int i = 0;
            while (i < dynamicOffsets.size()) {
                setProps.put("Dynamic Offset " + i, ValueAssetProperty.create((String)NullUtils.neverNull((Object)dynamicOffsets.get(i).toString())));
                ++i;
            }
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    private @NonNull AssetPropertyContainer getProperties(@NonNull TraceStateSnapshot currentState) {
        AssetPropertyContainer computeProperties;
        AssetPropertyContainer graphicsProperties;
        List<@NonNull IArgument> args = this.functionCall.getArguments();
        AssetPropertyContainer properties = new AssetPropertyContainer();
        int i = 1;
        while (i < args.size()) {
            IArgument arg = args.get(i);
            properties.put(arg.getArgumentName(), VkAssetPropertyFormatter.getAssetViewProperty(arg, this.getPropertyResolutionMap(currentState)));
            ++i;
        }
        AssetPropertyContainer stateProps = new AssetPropertyContainer();
        VkCommandBufferState state = this.getCommandBufferState(currentState);
        if (state.inRenderPass) {
            stateProps.put("Render Pass", state.currentRenderPass != null ? state.currentRenderPass : ValueAssetProperty.NULL);
            stateProps.put("Subpass Index", ValueAssetProperty.create((String)NullUtils.neverNull((Object)String.valueOf(state.subpassIndex))));
            stateProps.put("Framebuffer", state.currentFramebuffer != null ? state.currentFramebuffer : ValueAssetProperty.NULL);
        }
        if (state.graphicsPipeline != null) {
            stateProps.put("Graphics Pipeline", state.graphicsPipeline);
        }
        if ((graphicsProperties = VkCommand.getAssetPropertiesForDescriptorSetBindings(state.graphicsDescriptorSets)) != null) {
            stateProps.put("Graphics Descriptor Sets", graphicsProperties);
        }
        if (state.computePipeline != null) {
            stateProps.put("Compute Pipeline", state.computePipeline);
        }
        if ((computeProperties = VkCommand.getAssetPropertiesForDescriptorSetBindings(state.computeDescriptorSets)) != null) {
            stateProps.put("Compute Descriptor Sets", computeProperties);
        }
        if (state.indexBuffer != null) {
            stateProps.put("Index Buffer", state.indexBuffer);
            if (state.indexBufferOffset != null) {
                stateProps.put("Index Buffer Offset", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.indexBufferOffset.toString())));
            }
            if (state.indexType != null) {
                stateProps.put("Index Buffer Type", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.indexType.toString())));
            }
        }
        if (state.vertexBuffers.size() != 0) {
            AssetPropertyContainer vertexBufferProps = new AssetPropertyContainer();
            for (Map.Entry<Long, VkVertexBufferBinding> entry : state.vertexBuffers.entrySet()) {
                AssetPropertyContainer bindingProps = new AssetPropertyContainer();
                VkBufferAsset buffer = entry.getValue().buffer;
                bindingProps.put("Buffer", buffer != null ? buffer : ValueAssetProperty.NULL);
                bindingProps.put("Offset", ValueAssetProperty.create((String)NullUtils.neverNull((Object)entry.getValue().offset.toString())));
                vertexBufferProps.put((String)NullUtils.neverNull((Object)("Binding " + entry.getKey().toString())), bindingProps);
            }
            stateProps.put("Vertex Buffers", vertexBufferProps);
        }
        if (state.pushConstantLayout != null) {
            void var9_13;
            stateProps.put("Push Constant Layout", state.pushConstantLayout);
            AssetPropertyContainer pushConstantBindings = new AssetPropertyContainer();
            boolean bl = false;
            while (var9_13 < state.pushConstantBindings.size()) {
                VkPushConstantBinding binding = state.pushConstantBindings.get((int)var9_13);
                AssetPropertyContainer pushConstantProps = new AssetPropertyContainer();
                pushConstantProps.put("Push Constant Range", VkAssetPropertyFormatter.getAssetViewProperty(binding.range));
                pushConstantProps.put("Values", new ByteDataAssetProperty(binding.data));
                pushConstantBindings.put((String)NullUtils.neverNull((Object)String.format("[%d]", (int)var9_13)), pushConstantProps);
                ++var9_13;
            }
            stateProps.put("Push Constants", pushConstantBindings);
        }
        if (state.dynamicViewports.size() != 0) {
            AssetPropertyContainer viewportProps = new AssetPropertyContainer();
            for (Map.Entry<Long, Serializable> entry : state.dynamicViewports.entrySet()) {
                viewportProps.put((String)NullUtils.neverNull((Object)("Index " + entry.getKey().toString())), VkAssetPropertyFormatter.getAssetViewProperty((AbstractContainerWrapperType)entry.getValue()));
            }
            stateProps.put("Dynamic Viewports", viewportProps);
        }
        if (state.dynamicScissors.size() != 0) {
            AssetPropertyContainer scissorProps = new AssetPropertyContainer();
            for (Map.Entry<Long, Serializable> entry : state.dynamicScissors.entrySet()) {
                scissorProps.put((String)NullUtils.neverNull((Object)("Index " + entry.getKey().toString())), VkAssetPropertyFormatter.getAssetViewProperty((AbstractContainerWrapperType)entry.getValue()));
            }
            stateProps.put("Dynamic Scissors", scissorProps);
        }
        if (state.dynamicLineWidth != null) {
            stateProps.put("Dynamic Line Width", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicLineWidth.toString())));
        }
        if (state.dynamicDepthBiasConstantFactor != null) {
            stateProps.put("Dynamic Depth Bias Constant Factor", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicDepthBiasConstantFactor.toString())));
        }
        if (state.dynamicDepthBiasClamp != null) {
            stateProps.put("Dynamic Depth Bias Clamp", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicDepthBiasClamp.toString())));
        }
        if (state.dynamicDepthBiasSlopeFactor != null) {
            stateProps.put("Dynamic Depth Bias Slope Factor", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicDepthBiasSlopeFactor.toString())));
        }
        if (state.dynamicBlendConstants != null) {
            stateProps.put("Dynamic Blend Constants", VkAssetPropertyFormatter.getAssetViewProperty(state.dynamicBlendConstants));
        }
        if (state.dynamicMinDepthBounds != null) {
            stateProps.put("Dynamic Min Depth Bounds", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicMinDepthBounds.toString())));
        }
        if (state.dynamicMaxDepthBounds != null) {
            stateProps.put("Dynamic Max Depth Bounds", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicMaxDepthBounds.toString())));
        }
        if (state.dynamicStencilCompareFrontMask != null) {
            stateProps.put("Dynamic Stencil Compare Front Mask", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicStencilCompareFrontMask.toString())));
        }
        if (state.dynamicStencilCompareBackMask != null) {
            stateProps.put("Dynamic Stencil Compare Back Mask", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicStencilCompareBackMask.toString())));
        }
        if (state.dynamicStencilWriteFrontMask != null) {
            stateProps.put("Dynamic Stencil Write Front Mask", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicStencilWriteFrontMask.toString())));
        }
        if (state.dynamicStencilWriteBackMask != null) {
            stateProps.put("Dynamic Stencil Write Back Mask", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicStencilWriteBackMask.toString())));
        }
        if (state.dynamicStencilReferenceFront != null) {
            stateProps.put("Dynamic Stencil Reference Front", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicStencilReferenceFront.toString())));
        }
        if (state.dynamicStencilReferenceBack != null) {
            stateProps.put("Dynamic Stencil Reference Back", ValueAssetProperty.create((String)NullUtils.neverNull((Object)state.dynamicStencilReferenceBack.toString())));
        }
        properties.put("Command Buffer State", stateProps);
        return properties;
    }

    private static Map<@NonNull IFunctionOrAliasSpecExtended, @Nullable VkCommandFactory> createMap() {
        HashMap<@NonNull IFunctionOrAliasSpecExtended, @Nullable VkCommandFactory> map = new HashMap<IFunctionOrAliasSpecExtended, VkCommandFactory>();
        map.put(KapiSpec.VULKAN.functions.VKCMDBEGINQUERY, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDBEGINRENDERPASS, functionCall -> new VkCmdBeginRenderPass(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDBINDDESCRIPTORSETS, functionCall -> new VkCmdBindDescriptorSets(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDBINDINDEXBUFFER, functionCall -> new VkCmdBindIndexBuffer(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDBINDPIPELINE, functionCall -> new VkCmdBindPipeline(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDBINDVERTEXBUFFERS, functionCall -> new VkCmdBindVertexBuffers(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDBLITIMAGE, functionCall -> new VkCmdBlitImage(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDCLEARATTACHMENTS, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDCLEARCOLORIMAGE, functionCall -> new VkCmdClearColorImage(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDCLEARDEPTHSTENCILIMAGE, functionCall -> new VkCmdClearDepthStencilImage(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDCOPYBUFFER, functionCall -> new VkCmdCopyBuffer(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDCOPYBUFFERTOIMAGE, functionCall -> new VkCmdCopyBufferToImage(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDCOPYIMAGE, functionCall -> new VkCmdCopyImage(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDCOPYIMAGETOBUFFER, functionCall -> new VkCmdCopyImageToBuffer(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDCOPYQUERYPOOLRESULTS, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDEBUGMARKERBEGINEXT, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDEBUGMARKERENDEXT, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDEBUGMARKERINSERTEXT, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDISPATCH, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDISPATCHINDIRECT, functionCall -> new VkCmdDispatchIndirect(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDRAW, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDRAWINDEXED, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDRAWINDEXEDINDIRECT, functionCall -> new VkCmdDrawIndexedIndirect(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDDRAWINDIRECT, functionCall -> new VkCmdDrawIndirect(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDENDQUERY, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDENDRENDERPASS, functionCall -> new VkCmdEndRenderPass(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDEXECUTECOMMANDS, functionCall -> new VkCmdExecuteCommands(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDFILLBUFFER, functionCall -> new VkCmdFillBuffer(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDNEXTSUBPASS, functionCall -> new vkCmdNextSubpass(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDPIPELINEBARRIER, functionCall -> new VkCmdPipelineBarrier(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDPUSHCONSTANTS, functionCall -> new VkCmdPushConstants(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDRESETEVENT, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDRESETQUERYPOOL, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDRESOLVEIMAGE, functionCall -> new VkCmdResolveImage(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETBLENDCONSTANTS, functionCall -> new VkCmdSetBlendConstants(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETDEPTHBIAS, functionCall -> new VkCmdSetDepthBias(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETDEPTHBOUNDS, functionCall -> new VkCmdSetDepthBounds(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETEVENT, functionCall -> new VkCmdDefault(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETLINEWIDTH, functionCall -> new VkCmdSetLineWidth(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETSCISSOR, functionCall -> new VkCmdSetScissor(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETSTENCILCOMPAREMASK, functionCall -> new VkCmdSetStencilCompareMask(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETSTENCILREFERENCE, functionCall -> new VkCmdSetStencilReference(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETSTENCILWRITEMASK, functionCall -> new VkCmdSetStencilWriteMask(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDSETVIEWPORT, functionCall -> new VkCmdSetViewport(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDUPDATEBUFFER, functionCall -> new VkCmdUpdateBuffer(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDWAITEVENTS, functionCall -> new VkCmdWaitEvents(functionCall));
        map.put(KapiSpec.VULKAN.functions.VKCMDWRITETIMESTAMP, functionCall -> new VkCmdDefault(functionCall));
        assert (KapiSpec.VULKAN.getApi().getFunctions().getFunctions().stream().filter(spec -> spec.isVulkanCommand()).allMatch(spec -> map.containsKey(spec)));
        return map;
    }

    private static @Nullable VkBufferAsset getVkBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable Handle handle) {
        return handle == null || handle.isEmptyHandle() ? null : AssetProcessorBase.getVkBufferAsset(currentState, functionCall, AssetProcessorBase.asAssetID(handle));
    }

    private static @Nullable VkCommandBufferAsset getVkCommandBufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable Handle handle) {
        return handle == null || handle.isEmptyHandle() ? null : AssetProcessorBase.getVkCommandBufferAsset(currentState, functionCall, AssetProcessorBase.asAssetID(handle));
    }

    private static @Nullable VkDescriptorSetAsset getVkDescriptorSetAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable Handle handle) {
        return handle == null || handle.isEmptyHandle() ? null : AssetProcessorBase.getVkDescriptorSetAsset(currentState, functionCall, AssetProcessorBase.asAssetID(handle));
    }

    private static @Nullable VkFramebufferAsset getVkFramebufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable Handle handle) {
        return handle == null || handle.isEmptyHandle() ? null : AssetProcessorBase.getVkFramebufferAsset(currentState, functionCall, AssetProcessorBase.asAssetID(handle));
    }

    private static @Nullable VkImageAsset getVkImageAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable Handle handle) {
        return handle == null || handle.isEmptyHandle() ? null : AssetProcessorBase.getVkImageAsset(currentState, functionCall, AssetProcessorBase.asAssetID(handle));
    }

    private static @Nullable VkPipelineAsset getVkPipelineAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable Handle handle) {
        return handle == null || handle.isEmptyHandle() ? null : AssetProcessorBase.getVkPipelineAsset(currentState, functionCall, AssetProcessorBase.asAssetID(handle));
    }

    private static @Nullable VkPipelineLayoutAsset getVkPipelineLayoutAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable Handle handle) {
        return handle == null || handle.isEmptyHandle() ? null : AssetProcessorBase.getVkPipelineLayoutAsset(currentState, functionCall, AssetProcessorBase.asAssetID(handle));
    }

    private static @Nullable VkRenderPassAsset getVkRenderPassAsset(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @Nullable Handle handle) {
        return handle == null || handle.isEmptyHandle() ? null : AssetProcessorBase.getVkRenderPassAsset(currentState, functionCall, AssetProcessorBase.asAssetID(handle));
    }

    private class ByteDataAssetProperty
    implements IAssetProperty {
        private final byte @NonNull [] data;

        private ByteDataAssetProperty(byte[] data) {
            this.data = data;
        }

        @Override
        public @Nullable String getTextForm() {
            return StringUtils.commaSeparatedByteArrayHexFormat(true, 8, this.data);
        }

        @Override
        public @NonNull String getSimpleValue() {
            return (String)NullUtils.neverNull((Object)String.format("%d bytes", this.data.length));
        }
    }

    private static class PropertyResolutionMapBuilder {
        private final @NonNull Map<@NonNull String, @Nullable IAssetProperty> map = new HashMap<String, IAssetProperty>();

        private PropertyResolutionMapBuilder() {
        }

        private <T extends IVulkanHandleAsset & IAssetProperty> @Nullable T addAsset(@Nullable T asset) {
            if (asset != null) {
                this.map.put(asset.getHandle().toString(), asset);
            }
            return asset;
        }

        private @NonNull Map<@NonNull String, @Nullable IAssetProperty> build() {
            return this.map;
        }
    }

    private static class VkCmdBeginRenderPass
    extends VkCommand {
        private static final long serialVersionUID = 6972797683706758626L;

        public VkCmdBeginRenderPass(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            state.inRenderPass = true;
            VULKAN.Structs.VkRenderPassBeginInfo beginInfo = VULKAN.VkCmdBeginRenderPassDecorator.getArgumentPRenderPassBegin(this.functionCall);
            state.currentRenderPass = VkCommand.getVkRenderPassAsset(currentState, this.functionCall, beginInfo.getRenderPass());
            state.currentFramebuffer = VkCommand.getVkFramebufferAsset(currentState, this.functionCall, beginInfo.getFramebuffer());
            state.subpassIndex = 0;
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            VULKAN.Structs.VkRenderPassBeginInfo beginInfo = VULKAN.VkCmdBeginRenderPassDecorator.getArgumentPRenderPassBegin(this.functionCall);
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkRenderPassAsset(currentState, this.functionCall, beginInfo.getRenderPass()));
            builder.addAsset(VkCommand.getVkFramebufferAsset(currentState, this.functionCall, beginInfo.getFramebuffer()));
            return builder.build();
        }
    }

    private static class VkCmdBindDescriptorSets
    extends VkCommand {
        private static final long serialVersionUID = -5600355978159772157L;

        public VkCmdBindDescriptorSets(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        private @NonNull Map<Long, VkDescriptorSetBinding> getBindings(@NonNull TraceStateSnapshot currentState) {
            @NonNull HashMap<Long, VkDescriptorSetBinding> bindings = new HashMap<Long, VkDescriptorSetBinding>();
            VkPipelineLayoutAsset pipelineLayout = VkCommand.getVkPipelineLayoutAsset(currentState, this.functionCall, VULKAN.VkCmdBindDescriptorSetsDecorator.getArgumentLayout(this.functionCall));
            HandleArrayAttachment descriptorSets = VULKAN.VkCmdBindDescriptorSetsDecorator.getArgumentPDescriptorSets(this.functionCall);
            LongsArgAttachment dynamicOffsets = VULKAN.VkCmdBindDescriptorSetsDecorator.getArgumentPDynamicOffsets(this.functionCall);
            long currentSet = VULKAN.VkCmdBindDescriptorSetsDecorator.getArgumentFirstSet(this.functionCall);
            int dynamicOffsetsIndex = 0;
            for (Handle handle : descriptorSets) {
                VkDescriptorSetBinding binding = new VkDescriptorSetBinding();
                binding.descriptorSet = VkCommand.getVkDescriptorSetAsset(currentState, this.functionCall, handle);
                binding.pipelineLayout = pipelineLayout;
                if (binding.descriptorSet != null) {
                    for (VULKAN.Structs.VkDescriptorSetLayoutBinding layoutBinding : binding.descriptorSet.getLayout().getBindings()) {
                        AbstractConstantOrAliasSpecExtended descriptorType = layoutBinding.getDescriptorType();
                        boolean isUniformBufferDynamic = KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC.equals(descriptorType);
                        boolean isStorageBufferDynamic = KapiSpec.VULKAN.constants.VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC.equals(descriptorType);
                        Long descriptorCount = layoutBinding.getDescriptorCount();
                        if (!isUniformBufferDynamic && !isStorageBufferDynamic) continue;
                        ArrayList<Long> newDynamicOffsets = new ArrayList<Long>(descriptorCount.intValue());
                        binding.dynamicOffsets = newDynamicOffsets;
                        int i = 0;
                        while (i < descriptorCount.intValue()) {
                            if (dynamicOffsets != null && dynamicOffsets.size() > dynamicOffsetsIndex) {
                                newDynamicOffsets.add(dynamicOffsets.get(dynamicOffsetsIndex));
                            } else {
                                newDynamicOffsets.add(NullUtils.longValueOf((long)-1L));
                            }
                            ++dynamicOffsetsIndex;
                            ++i;
                        }
                    }
                }
                bindings.put(currentSet, binding);
                ++currentSet;
            }
            return bindings;
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            AbstractConstantOrAliasSpecExtended pipelineBindPoint = VULKAN.VkCmdBindDescriptorSetsDecorator.getArgumentPipelineBindPoint(this.functionCall);
            boolean isGraphicsPipeline = KapiSpec.VULKAN.constants.VK_PIPELINE_BIND_POINT_GRAPHICS.equals(pipelineBindPoint);
            boolean isComputePipeline = KapiSpec.VULKAN.constants.VK_PIPELINE_BIND_POINT_COMPUTE.equals(pipelineBindPoint);
            @NonNull Map<Long, VkDescriptorSetBinding> bindings = this.getBindings(currentState);
            if (isGraphicsPipeline) {
                state.graphicsDescriptorSets.putAll(bindings);
            } else if (isComputePipeline) {
                state.computeDescriptorSets.putAll(bindings);
            }
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            @NonNull Map<Long, VkDescriptorSetBinding> bindings = this.getBindings(currentState);
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkPipelineLayoutAsset(currentState, this.functionCall, VULKAN.VkCmdBindDescriptorSetsDecorator.getArgumentLayout(this.functionCall)));
            for (Map.Entry<Long, VkDescriptorSetBinding> entry : bindings.entrySet()) {
                builder.addAsset(entry.getValue().descriptorSet);
            }
            return builder.build();
        }
    }

    private static class VkCmdBindIndexBuffer
    extends VkCommand {
        private static final long serialVersionUID = 8596658897792371584L;

        public VkCmdBindIndexBuffer(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            VkBufferAsset indexBuffer;
            state.indexBuffer = indexBuffer = VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdBindIndexBufferDecorator.getArgumentBuffer(this.functionCall));
            state.indexBufferOffset = VULKAN.VkCmdBindIndexBufferDecorator.getArgumentOffset(this.functionCall);
            state.indexType = VULKAN.VkCmdBindIndexBufferDecorator.getArgumentIndexType(this.functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdBindIndexBufferDecorator.getArgumentBuffer(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdBindPipeline
    extends VkCommand {
        private static final long serialVersionUID = -4169300446092512398L;

        public VkCmdBindPipeline(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            VkPipelineAsset pipeline = VkCommand.getVkPipelineAsset(currentState, this.functionCall, VULKAN.VkCmdBindPipelineDecorator.getArgumentPipeline(this.functionCall));
            AbstractConstantOrAliasSpecExtended pipelineBindPoint = VULKAN.VkCmdBindPipelineDecorator.getArgumentPipelineBindPoint(this.functionCall);
            boolean isGraphicsPipeline = KapiSpec.VULKAN.constants.VK_PIPELINE_BIND_POINT_GRAPHICS.equals(pipelineBindPoint);
            boolean isComputePipeline = KapiSpec.VULKAN.constants.VK_PIPELINE_BIND_POINT_COMPUTE.equals(pipelineBindPoint);
            if (isGraphicsPipeline) {
                state.graphicsPipeline = pipeline;
                if (pipeline instanceof VkGraphicsPipelineAsset) {
                    VkGraphicsPipelineAsset graphicsPipeline = (VkGraphicsPipelineAsset)pipeline;
                    LongsArgAttachment dynamicStates = graphicsPipeline.getDynamicState().getPDynamicStates();
                    @NonNull List<@NonNull Long> values = dynamicStates.asList();
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_VIEWPORT.getResolvedValue())) {
                        state.dynamicViewports.clear();
                    }
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_SCISSOR.getResolvedValue())) {
                        state.dynamicScissors.clear();
                    }
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_LINE_WIDTH.getResolvedValue())) {
                        state.dynamicLineWidth = null;
                    }
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_DEPTH_BIAS.getResolvedValue())) {
                        state.dynamicDepthBiasConstantFactor = null;
                        state.dynamicDepthBiasClamp = null;
                        state.dynamicDepthBiasSlopeFactor = null;
                    }
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_BLEND_CONSTANTS.getResolvedValue())) {
                        state.dynamicBlendConstants = null;
                    }
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_DEPTH_BOUNDS.getResolvedValue())) {
                        state.dynamicMinDepthBounds = null;
                        state.dynamicMaxDepthBounds = null;
                    }
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_STENCIL_COMPARE_MASK.getResolvedValue())) {
                        state.dynamicStencilCompareFrontMask = null;
                        state.dynamicStencilCompareBackMask = null;
                    }
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_STENCIL_WRITE_MASK.getResolvedValue())) {
                        state.dynamicStencilWriteFrontMask = null;
                        state.dynamicStencilWriteBackMask = null;
                    }
                    if (!values.contains(KapiSpec.VULKAN.constants.VK_DYNAMIC_STATE_STENCIL_REFERENCE.getResolvedValue())) {
                        state.dynamicStencilReferenceFront = null;
                        state.dynamicStencilReferenceBack = null;
                    }
                }
            } else if (isComputePipeline) {
                state.computePipeline = pipeline;
            }
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkPipelineAsset(currentState, this.functionCall, VULKAN.VkCmdBindPipelineDecorator.getArgumentPipeline(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdBindVertexBuffers
    extends VkCommand {
        private static final long serialVersionUID = 7591737257524492212L;

        public VkCmdBindVertexBuffers(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        private @NonNull Map<Long, VkVertexBufferBinding> getVertexBuffers(@NonNull TraceStateSnapshot currentState) {
            @NonNull HashMap<Long, VkVertexBufferBinding> vertexBuffers = new HashMap<Long, VkVertexBufferBinding>();
            Long bindingCount = VULKAN.VkCmdBindVertexBuffersDecorator.getArgumentBindingCount(this.functionCall);
            HandleArrayAttachment buffers = VULKAN.VkCmdBindVertexBuffersDecorator.getArgumentPBuffers(this.functionCall);
            LongsArgAttachment offsets = VULKAN.VkCmdBindVertexBuffersDecorator.getArgumentPOffsets(this.functionCall);
            long currentBinding = VULKAN.VkCmdBindVertexBuffersDecorator.getArgumentFirstBinding(this.functionCall);
            int i = 0;
            while (i < bindingCount.intValue()) {
                VkBufferAsset buffer = null;
                Long offset = null;
                if (buffers.size() > i) {
                    buffer = VkCommand.getVkBufferAsset(currentState, this.functionCall, buffers.get(i));
                }
                if (offsets.size() > i) {
                    offset = offsets.get(i);
                }
                vertexBuffers.put(currentBinding, new VkVertexBufferBinding(buffer, offset));
                ++currentBinding;
                ++i;
            }
            return vertexBuffers;
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            state.vertexBuffers.putAll(this.getVertexBuffers(currentState));
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            for (Map.Entry<Long, VkVertexBufferBinding> entry : this.getVertexBuffers(currentState).entrySet()) {
                builder.addAsset(entry.getValue().buffer);
            }
            return builder.build();
        }
    }

    private static class VkCmdBlitImage
    extends VkCommand {
        private static final long serialVersionUID = 2687850502938434142L;

        public VkCmdBlitImage(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdBlitImageDecorator.getArgumentSrcImage(this.functionCall)));
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdBlitImageDecorator.getArgumentDstImage(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdClearColorImage
    extends VkCommand {
        private static final long serialVersionUID = 4421099557280381914L;

        public VkCmdClearColorImage(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdClearColorImageDecorator.getArgumentImage(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdClearDepthStencilImage
    extends VkCommand {
        private static final long serialVersionUID = -6845539439469199389L;

        public VkCmdClearDepthStencilImage(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdClearDepthStencilImageDecorator.getArgumentImage(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdCopyBuffer
    extends VkCommand {
        private static final long serialVersionUID = -8435343653369861877L;

        public VkCmdCopyBuffer(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdCopyBufferDecorator.getArgumentSrcBuffer(this.functionCall)));
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdCopyBufferDecorator.getArgumentDstBuffer(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdCopyBufferToImage
    extends VkCommand {
        private static final long serialVersionUID = 904953231041481092L;

        public VkCmdCopyBufferToImage(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdCopyBufferToImageDecorator.getArgumentSrcBuffer(this.functionCall)));
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdCopyBufferToImageDecorator.getArgumentDstImage(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdCopyImage
    extends VkCommand {
        private static final long serialVersionUID = -2999584341982483428L;

        public VkCmdCopyImage(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdCopyImageDecorator.getArgumentSrcImage(this.functionCall)));
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdCopyImageDecorator.getArgumentDstImage(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdCopyImageToBuffer
    extends VkCommand {
        private static final long serialVersionUID = 3924216799149333848L;

        public VkCmdCopyImageToBuffer(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdCopyImageToBufferDecorator.getArgumentSrcImage(this.functionCall)));
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdCopyImageToBufferDecorator.getArgumentDstBuffer(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdDefault
    extends VkCommand {
        private static final long serialVersionUID = -3579333368363009003L;

        public VkCmdDefault(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }
    }

    private static class VkCmdDispatchIndirect
    extends VkCommand {
        private static final long serialVersionUID = 7232207760645376233L;

        public VkCmdDispatchIndirect(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdDrawIndexedIndirectDecorator.getArgumentBuffer(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdDrawIndexedIndirect
    extends VkCommand {
        private static final long serialVersionUID = 7656282833888280196L;

        public VkCmdDrawIndexedIndirect(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdDrawIndexedIndirectDecorator.getArgumentBuffer(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdDrawIndirect
    extends VkCommand {
        private static final long serialVersionUID = 5384135753530229553L;

        public VkCmdDrawIndirect(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdDrawIndirectDecorator.getArgumentBuffer(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdEndRenderPass
    extends VkCommand {
        private static final long serialVersionUID = -2182474183860155423L;

        public VkCmdEndRenderPass(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            state.inRenderPass = false;
            state.currentRenderPass = null;
            state.currentFramebuffer = null;
            state.subpassIndex = 0;
        }
    }

    private static class VkCmdExecuteCommands
    extends VkCommand {
        private static final long serialVersionUID = 6593424481951645823L;

        public VkCmdExecuteCommands(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            LongsArgAttachment secondaryCommandBuffers = VULKAN.VkCmdExecuteCommandsDecorator.getArgumentPCommandBuffers(this.functionCall);
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            for (Long secondaryCommandBuffer : secondaryCommandBuffers) {
                builder.addAsset(VkCommand.getVkCommandBufferAsset(currentState, this.functionCall, Handle.valueOf(Handle.HandleType.VULKAN_NON_DISPATCHABLE_HANDLE, secondaryCommandBuffer)));
            }
            return builder.build();
        }
    }

    private static class VkCmdFillBuffer
    extends VkCommand {
        private static final long serialVersionUID = 5154137620940760326L;

        public VkCmdFillBuffer(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdFillBufferDecorator.getArgumentDstBuffer(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdPipelineBarrier
    extends VkCommand {
        private static final long serialVersionUID = -1080498407111051572L;

        public VkCmdPipelineBarrier(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            List<VULKAN.Structs.VkBufferMemoryBarrier> bufferBarriers = VULKAN.VkCmdPipelineBarrierDecorator.getArgumentPBufferMemoryBarriers(this.functionCall);
            for (VULKAN.Structs.VkBufferMemoryBarrier barrier : bufferBarriers) {
                if (barrier == null) continue;
                builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, barrier.getBuffer()));
            }
            List<VULKAN.Structs.VkImageMemoryBarrier> imageBarriers = VULKAN.VkCmdPipelineBarrierDecorator.getArgumentPImageMemoryBarriers(this.functionCall);
            for (VULKAN.Structs.VkImageMemoryBarrier barrier : imageBarriers) {
                if (barrier == null) continue;
                builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, barrier.getImage()));
            }
            return builder.build();
        }
    }

    private static class VkCmdPushConstants
    extends VkCommand {
        private static final long serialVersionUID = -7252101630467639031L;

        public VkCmdPushConstants(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            VkPipelineLayoutAsset pipelineLayout = VkCommand.getVkPipelineLayoutAsset(currentState, this.functionCall, VULKAN.VkCmdPushConstantsDecorator.getArgumentLayout(this.functionCall));
            if (pipelineLayout == null) {
                state.pushConstantBindings.clear();
            } else {
                if (!pipelineLayout.isPushConstantCompatibleWith(state.pushConstantLayout)) {
                    state.pushConstantBindings.clear();
                    for (VULKAN.Structs.VkPushConstantRange layout : pipelineLayout.getPushConstants()) {
                        assert (layout != null);
                        state.pushConstantBindings.add(new VkPushConstantBinding(layout));
                    }
                }
                for (VkPushConstantBinding binding : state.pushConstantBindings) {
                    boolean validEnd;
                    int rangeSize = binding.range.getSize().intValue();
                    int rangeOffset = binding.range.getOffset().intValue();
                    Bitfield rangeStageFlags = binding.range.getStageFlags();
                    int pushConstantSize = VULKAN.VkCmdPushConstantsDecorator.getArgumentSize(this.functionCall).intValue();
                    int pushConstantOffset = VULKAN.VkCmdPushConstantsDecorator.getArgumentOffset(this.functionCall).intValue();
                    Bitfield pushConstantStageFlags = VULKAN.VkCmdPushConstantsDecorator.getArgumentStageFlags(this.functionCall);
                    boolean validStart = pushConstantOffset >= rangeOffset;
                    boolean bl = validEnd = pushConstantOffset + pushConstantSize <= rangeOffset + rangeSize;
                    if (!rangeStageFlags.equals(pushConstantStageFlags) || !validStart || !validEnd) continue;
                    BufferArgAttachment values = VULKAN.VkCmdPushConstantsDecorator.getArgumentPValues(this.functionCall);
                    System.arraycopy(values.getData(), 0, binding.data, pushConstantOffset - rangeOffset, pushConstantSize);
                }
            }
            state.pushConstantLayout = pipelineLayout;
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkPipelineLayoutAsset(currentState, this.functionCall, VULKAN.VkCmdPushConstantsDecorator.getArgumentLayout(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdResolveImage
    extends VkCommand {
        private static final long serialVersionUID = -99172612619072973L;

        public VkCmdResolveImage(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdResolveImageDecorator.getArgumentSrcImage(this.functionCall)));
            builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, VULKAN.VkCmdResolveImageDecorator.getArgumentDstImage(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdSetBlendConstants
    extends VkCommand {
        private static final long serialVersionUID = 7808569273585787215L;

        public VkCmdSetBlendConstants(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            state.dynamicBlendConstants = VULKAN.VkCmdSetBlendConstantsDecorator.getArgumentBlendConstants(this.functionCall);
        }
    }

    private static class VkCmdSetDepthBias
    extends VkCommand {
        private static final long serialVersionUID = -6467404427683120643L;

        public VkCmdSetDepthBias(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            state.dynamicDepthBiasConstantFactor = VULKAN.VkCmdSetDepthBiasDecorator.getArgumentDepthBiasConstantFactor(this.functionCall);
            state.dynamicDepthBiasClamp = VULKAN.VkCmdSetDepthBiasDecorator.getArgumentDepthBiasClamp(this.functionCall);
            state.dynamicDepthBiasSlopeFactor = VULKAN.VkCmdSetDepthBiasDecorator.getArgumentDepthBiasSlopeFactor(this.functionCall);
        }
    }

    private static class VkCmdSetDepthBounds
    extends VkCommand {
        private static final long serialVersionUID = -8238781553114721084L;

        public VkCmdSetDepthBounds(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            state.dynamicMinDepthBounds = VULKAN.VkCmdSetDepthBoundsDecorator.getArgumentMinDepthBounds(this.functionCall);
            state.dynamicMaxDepthBounds = VULKAN.VkCmdSetDepthBoundsDecorator.getArgumentMaxDepthBounds(this.functionCall);
        }
    }

    private static class VkCmdSetLineWidth
    extends VkCommand {
        private static final long serialVersionUID = -4681756707498659104L;

        public VkCmdSetLineWidth(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            state.dynamicLineWidth = VULKAN.VkCmdSetLineWidthDecorator.getArgumentLineWidth(this.functionCall);
        }
    }

    private static class VkCmdSetScissor
    extends VkCommand {
        private static final long serialVersionUID = -5135637548068668356L;

        public VkCmdSetScissor(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            long currentScissor = VULKAN.VkCmdSetScissorDecorator.getArgumentFirstScissor(this.functionCall);
            for (VULKAN.Structs.VkRect2D scissor : VULKAN.VkCmdSetScissorDecorator.getArgumentPScissors(this.functionCall)) {
                state.dynamicScissors.put(currentScissor, scissor);
                ++currentScissor;
            }
        }
    }

    private static class VkCmdSetStencilCompareMask
    extends VkCommand {
        private static final long serialVersionUID = -1490742346558233365L;

        public VkCmdSetStencilCompareMask(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            Bitfield faceMask = VULKAN.VkCmdSetStencilCompareMaskDecorator.getArgumentFaceMask(this.functionCall);
            Long compareMask = VULKAN.VkCmdSetStencilCompareMaskDecorator.getArgumentCompareMask(this.functionCall);
            if (faceMask.contains(KapiSpec.VULKAN.constants.VK_STENCIL_FACE_FRONT_BIT)) {
                state.dynamicStencilCompareFrontMask = compareMask;
            }
            if (faceMask.contains(KapiSpec.VULKAN.constants.VK_STENCIL_FACE_BACK_BIT)) {
                state.dynamicStencilCompareBackMask = compareMask;
            }
        }
    }

    private static class VkCmdSetStencilReference
    extends VkCommand {
        private static final long serialVersionUID = -8501265255265450217L;

        public VkCmdSetStencilReference(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            Bitfield faceMask = VULKAN.VkCmdSetStencilReferenceDecorator.getArgumentFaceMask(this.functionCall);
            Long reference = VULKAN.VkCmdSetStencilReferenceDecorator.getArgumentReference(this.functionCall);
            if (faceMask.contains(KapiSpec.VULKAN.constants.VK_STENCIL_FACE_FRONT_BIT)) {
                state.dynamicStencilReferenceFront = reference;
            }
            if (faceMask.contains(KapiSpec.VULKAN.constants.VK_STENCIL_FACE_BACK_BIT)) {
                state.dynamicStencilReferenceBack = reference;
            }
        }
    }

    private static class VkCmdSetStencilWriteMask
    extends VkCommand {
        private static final long serialVersionUID = 2539742594977468399L;

        public VkCmdSetStencilWriteMask(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            Bitfield faceMask = VULKAN.VkCmdSetStencilWriteMaskDecorator.getArgumentFaceMask(this.functionCall);
            Long writeMask = VULKAN.VkCmdSetStencilWriteMaskDecorator.getArgumentWriteMask(this.functionCall);
            if (faceMask.contains(KapiSpec.VULKAN.constants.VK_STENCIL_FACE_FRONT_BIT)) {
                state.dynamicStencilWriteFrontMask = writeMask;
            }
            if (faceMask.contains(KapiSpec.VULKAN.constants.VK_STENCIL_FACE_BACK_BIT)) {
                state.dynamicStencilWriteBackMask = writeMask;
            }
        }
    }

    private static class VkCmdSetViewport
    extends VkCommand {
        private static final long serialVersionUID = 3106279732195544033L;

        public VkCmdSetViewport(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            long currentViewport = VULKAN.VkCmdSetViewportDecorator.getArgumentFirstViewport(this.functionCall);
            for (VULKAN.Structs.VkViewport viewport : VULKAN.VkCmdSetViewportDecorator.getArgumentPViewports(this.functionCall)) {
                state.dynamicViewports.put(currentViewport, viewport);
                ++currentViewport;
            }
        }
    }

    private static class VkCmdUpdateBuffer
    extends VkCommand {
        private static final long serialVersionUID = 4590976882283900528L;

        public VkCmdUpdateBuffer(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, VULKAN.VkCmdUpdateBufferDecorator.getArgumentDstBuffer(this.functionCall)));
            return builder.build();
        }
    }

    private static class VkCmdWaitEvents
    extends VkCommand {
        private static final long serialVersionUID = 8249194022927211762L;

        public VkCmdWaitEvents(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected @NonNull Map<@NonNull String, @Nullable IAssetProperty> getPropertyResolutionMap(@NonNull TraceStateSnapshot currentState) {
            List<VULKAN.Structs.VkBufferMemoryBarrier> bufferBarriers = VULKAN.VkCmdWaitEventsDecorator.getArgumentPBufferMemoryBarriers(this.functionCall);
            PropertyResolutionMapBuilder builder = new PropertyResolutionMapBuilder();
            for (VULKAN.Structs.VkBufferMemoryBarrier barrier : bufferBarriers) {
                if (barrier == null) continue;
                builder.addAsset(VkCommand.getVkBufferAsset(currentState, this.functionCall, barrier.getBuffer()));
            }
            List<VULKAN.Structs.VkImageMemoryBarrier> imageBarriers = VULKAN.VkCmdWaitEventsDecorator.getArgumentPImageMemoryBarriers(this.functionCall);
            for (VULKAN.Structs.VkImageMemoryBarrier barrier : imageBarriers) {
                if (barrier == null) continue;
                builder.addAsset(VkCommand.getVkImageAsset(currentState, this.functionCall, barrier.getImage()));
            }
            return builder.build();
        }
    }

    public static class VkCommandAssetPropertyProvider
    implements IAssetPropertyProvider,
    ICreatableAndModifiable {
        private final @NonNull VkCommand command;
        private final @NonNull TraceStateSnapshot snapshot;

        private VkCommandAssetPropertyProvider(@NonNull VkCommand command, @NonNull TraceStateSnapshot snapshot) {
            this.command = command;
            this.snapshot = snapshot;
        }

        @Override
        public @NonNull String getSimpleValue() {
            return this.command.getName();
        }

        @Override
        public @NonNull AssetPropertyContainer getProperties() {
            return this.command.getProperties(this.snapshot);
        }

        @Override
        public @NonNull FunctionCall getCreatedByFunction() {
            return this.command.getFunction();
        }

        @Override
        public @Nullable FunctionCall getPreviousModificationFunction() {
            return null;
        }

        @Override
        public void setPreviousModificationFunction(@NonNull FunctionCall previousModificationFunction) {
            assert (false);
        }
    }

    private static class VkCommandBufferState {
        public boolean inRenderPass = false;
        public @Nullable VkRenderPassAsset currentRenderPass = null;
        public @Nullable VkFramebufferAsset currentFramebuffer = null;
        public int subpassIndex = 0;
        public final @NonNull Map<Long, VkDescriptorSetBinding> graphicsDescriptorSets = new TreeMap<Long, VkDescriptorSetBinding>();
        public final @NonNull Map<Long, VkDescriptorSetBinding> computeDescriptorSets = new TreeMap<Long, VkDescriptorSetBinding>();
        public @Nullable VkBufferAsset indexBuffer = null;
        public @Nullable Long indexBufferOffset = null;
        public @Nullable AbstractConstantOrAliasSpecExtended indexType = null;
        public @Nullable VkPipelineAsset graphicsPipeline = null;
        public @Nullable VkPipelineAsset computePipeline = null;
        public final @NonNull Map<Long, VkVertexBufferBinding> vertexBuffers = new TreeMap<Long, VkVertexBufferBinding>();
        public @Nullable VkPipelineLayoutAsset pushConstantLayout = null;
        public final @NonNull List<@NonNull VkPushConstantBinding> pushConstantBindings = new ArrayList<VkPushConstantBinding>();
        public final @NonNull Map<Long, VULKAN.Structs.VkViewport> dynamicViewports = new TreeMap<Long, VULKAN.Structs.VkViewport>();
        public final @NonNull Map<Long, VULKAN.Structs.VkRect2D> dynamicScissors = new TreeMap<Long, VULKAN.Structs.VkRect2D>();
        public @Nullable Float dynamicLineWidth = null;
        public @Nullable Float dynamicDepthBiasConstantFactor = null;
        public @Nullable Float dynamicDepthBiasClamp = null;
        public @Nullable Float dynamicDepthBiasSlopeFactor = null;
        public @Nullable FloatsArgAttachment dynamicBlendConstants = null;
        public @Nullable Float dynamicMinDepthBounds = null;
        public @Nullable Float dynamicMaxDepthBounds = null;
        public @Nullable Long dynamicStencilCompareFrontMask = null;
        public @Nullable Long dynamicStencilCompareBackMask = null;
        public @Nullable Long dynamicStencilWriteFrontMask = null;
        public @Nullable Long dynamicStencilWriteBackMask = null;
        public @Nullable Long dynamicStencilReferenceFront = null;
        public @Nullable Long dynamicStencilReferenceBack = null;

        private VkCommandBufferState() {
        }
    }

    @FunctionalInterface
    private static interface VkCommandFactory {
        public @NonNull VkCommand create(@NonNull FunctionCall var1);
    }

    private static class VkDescriptorSetBinding
    implements Serializable {
        private static final long serialVersionUID = 7249684761147670540L;
        public @Nullable VkDescriptorSetAsset descriptorSet = null;
        public @Nullable VkPipelineLayoutAsset pipelineLayout = null;
        public @Nullable List<@NonNull Long> dynamicOffsets = null;

        private VkDescriptorSetBinding() {
        }
    }

    private static class VkPushConstantBinding
    implements Serializable {
        private static final long serialVersionUID = -8283723165933824885L;
        public final  @NonNull VULKAN.Structs.VkPushConstantRange range;
        public final byte @NonNull [] data;

        private VkPushConstantBinding( @NonNull VULKAN.Structs.VkPushConstantRange range) {
            this.range = range;
            this.data = new byte[range.getSize().intValue()];
        }
    }

    private static class VkVertexBufferBinding
    implements Serializable {
        private static final long serialVersionUID = 2461479160073847948L;
        public final @Nullable VkBufferAsset buffer;
        public final @NonNull Long offset;

        private VkVertexBufferBinding(@Nullable VkBufferAsset buffer, @Nullable Long offset) {
            this.buffer = buffer;
            this.offset = offset != null ? offset : NullUtils.longValueOf((long)-1L);
        }
    }

    private static class vkCmdNextSubpass
    extends VkCommand {
        private static final long serialVersionUID = 1001137855863481823L;

        public vkCmdNextSubpass(@NonNull FunctionCall functionCall) {
            super(functionCall);
        }

        @Override
        protected void updateCommandState(@NonNull TraceStateSnapshot currentState, @NonNull VkCommandBufferState state) {
            ++state.subpassIndex;
        }
    }
}

