/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.IVkDeviceMemoryBackedAsset;
import com.arm.mgd.core.asset.IVulkanHandleAsset;
import com.arm.mgd.core.asset.VkDeviceMemoryAsset;
import com.arm.mgd.core.asset.objects.IBufferUsage;
import com.arm.mgd.core.asset.objects.KAPIBufferUsage;
import com.arm.mgd.core.asset.objects.gen.AbstractVkBufferAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VkBufferAsset
extends AbstractVkBufferAsset
implements IBufferItem,
IVulkanHandleAsset,
IVkDeviceMemoryBackedAsset {
    private static final long serialVersionUID = 3808981313168007071L;
    private @Nullable VkDeviceMemoryAsset memoryBinding;
    private long offset = 0L;

    public VkBufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long handle, @NonNull Bitfield flags, @NonNull LongsArgAttachment queueFamilyIndices, @NonNull AbstractConstantOrAliasSpecExtended sharingMode, long size, @NonNull Bitfield usage) {
        super(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, handle, flags, queueFamilyIndices, sharingMode, size, usage);
    }

    @Override
    public void bind(@NonNull VkDeviceMemoryAsset deviceMemory, long deviceOffset) {
        this.offset = deviceOffset;
        this.memoryBinding = deviceMemory;
    }

    @Override
    public long getOffset() {
        assert (this.isBound());
        return this.offset;
    }

    @Override
    public boolean isBound() {
        return this.memoryBinding != null;
    }

    @Override
    public @Nullable VkDeviceMemoryAsset getBackingMemory() {
        return this.memoryBinding;
    }

    @Override
    public long getSizeOfBuffer() {
        return this.getSize();
    }

    @Override
    public byte @Nullable [] getDataForBuffer() {
        return this.getDataFromBackingMemory();
    }

    @Override
    public @NonNull IBufferUsage getBufferUsage() {
        return new KAPIBufferUsage(this.getUsage());
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = super.getProperties();
        properties.put("Memory", this.memoryBinding != null ? this.memoryBinding : ValueAssetProperty.NONE);
        return properties;
    }
}

