/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.target.data.AbstractContainerWrapperType;
import com.arm.mgd.core.target.data.ArgumentContainerArrayAttachment;
import com.arm.mgd.core.target.data.ArgumentContainerAttachment;
import com.arm.mgd.core.target.data.ArgumentHierarchyBranch;
import com.arm.mgd.core.target.data.ArgumentHierarchyLeaf;
import com.arm.mgd.core.target.data.ArgumentHierarchyNode;
import com.arm.mgd.core.target.data.IArgument;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class VkAssetPropertyFormatter {
    public static @NonNull IAssetProperty getAssetViewProperty(@NonNull LongsArgAttachment property) {
        if (property.isNull()) {
            return ValueAssetProperty.NULL;
        }
        return ValueAssetProperty.create(StringUtils.listToString(property.asList()));
    }

    public static <T extends IAssetItem> @NonNull IAssetProperty getAssetViewProperty(@NonNull List<T> property) {
        return new ListAssetProperty(property);
    }

    public static @NonNull IAssetProperty getAssetViewProperty(@Nullable AbstractContainerWrapperType property, @NonNull Map<@NonNull String, @Nullable IAssetProperty> propertyResolutionMap) {
        if (property == null || property.getContainer().isNull()) {
            return ValueAssetProperty.NULL;
        }
        AssetPropertyContainer properties = new AssetPropertyContainer();
        for (IArgument argument : property.getContainer().getArguments()) {
            if (argument instanceof ArgumentContainerArrayAttachment) {
                properties.put(argument.getArgumentName(), VkAssetPropertyFormatter.getAssetViewProperty(argument));
                continue;
            }
            IAssetProperty replacementProperty = propertyResolutionMap.get(argument.getArgumentName());
            if (replacementProperty == null) {
                replacementProperty = ValueAssetProperty.create(argument.getDescriptiveText());
            }
            properties.put(argument.getArgumentName(), replacementProperty);
        }
        return properties;
    }

    public static @NonNull IAssetProperty getAssetViewProperty(@Nullable AbstractContainerWrapperType property) {
        return VkAssetPropertyFormatter.getAssetViewProperty(property, (Map<String, IAssetProperty>)NullUtils.EMPTY_MAP);
    }

    public static @NonNull IAssetProperty getAssetViewProperty(@Nullable ArgumentContainerAttachment property) {
        if (property == null || property.getContainer().isNull()) {
            return ValueAssetProperty.NULL;
        }
        AssetPropertyContainer properties = new AssetPropertyContainer();
        for (IArgument argument : property.getContainer().getArguments()) {
            if (argument instanceof ArgumentContainerArrayAttachment) {
                properties.put(argument.getArgumentName(), VkAssetPropertyFormatter.getAssetViewProperty(argument));
                continue;
            }
            properties.put(argument.getArgumentName(), ValueAssetProperty.create(argument.getDescriptiveText()));
        }
        return properties;
    }

    public static @NonNull IAssetProperty getAssetViewProperty(@Nullable ArgumentContainerArrayAttachment property) {
        if (property == null || property.isNull()) {
            return ValueAssetProperty.NULL;
        }
        ArrayList<IAssetProperty> properties = new ArrayList<IAssetProperty>();
        for (ArgumentContainerAttachment argument : property.getElements()) {
            properties.add(VkAssetPropertyFormatter.getAssetViewProperty(argument));
        }
        return new ListAssetProperty(properties);
    }

    public static @NonNull IAssetProperty getAssetViewProperty(@NonNull IAssetItem property) {
        return property;
    }

    public static @NonNull IAssetProperty getAssetViewProperty(@NonNull IArgument property, @NonNull Map<@NonNull String, @Nullable IAssetProperty> propertyResolutionMap) {
        return VkAssetPropertyFormatter.getAssetViewPropertyForArgumentHierarchy(property.getArgumentHierarchy(), propertyResolutionMap);
    }

    public static @NonNull IAssetProperty getAssetViewProperty(@NonNull IArgument property) {
        return VkAssetPropertyFormatter.getAssetViewProperty(property, (Map<String, IAssetProperty>)NullUtils.EMPTY_MAP);
    }

    private static @NonNull IAssetProperty getAssetViewPropertyForArgumentHierarchy(@NonNull ArgumentHierarchyNode node, @NonNull Map<@NonNull String, @Nullable IAssetProperty> propertyResolutionMap) {
        if (node instanceof ArgumentHierarchyBranch) {
            ArgumentHierarchyBranch branch = (ArgumentHierarchyBranch)node;
            List<@NonNull ArgumentHierarchyNode> children = branch.getChildren();
            ArgumentHierarchyBranch.BranchType branchType = branch.getType();
            if (branchType.equals((Object)ArgumentHierarchyBranch.BranchType.BITFIELD)) {
                if (children.size() == 0) {
                    return ValueAssetProperty.ZERO;
                }
                StringBuilder builder = new StringBuilder();
                int i = 0;
                while (i < children.size()) {
                    ArgumentHierarchyLeaf child = (ArgumentHierarchyLeaf)children.get(i);
                    builder.append(child.getValue());
                    if (i != children.size() - 1) {
                        builder.append(branchType.getChildrenSeparator());
                    }
                    ++i;
                }
                return ValueAssetProperty.create((String)NullUtils.neverNull((Object)builder.toString()));
            }
            if (branchType.equals((Object)ArgumentHierarchyBranch.BranchType.ARRAY)) {
                AssetPropertyContainer properties = new AssetPropertyContainer();
                int i = 0;
                while (i < children.size()) {
                    ArgumentHierarchyNode child = children.get(i);
                    properties.put(NullUtils.stringValueOf((long)i), VkAssetPropertyFormatter.getAssetViewPropertyForArgumentHierarchy(child, propertyResolutionMap));
                    ++i;
                }
                return properties;
            }
            AssetPropertyContainer properties = new AssetPropertyContainer();
            for (ArgumentHierarchyNode child : children) {
                String childName = child.getName();
                assert (childName != null) : "Child of " + branch.getName() + " (type:" + (Object)((Object)branch.getType()) + ") doesn't have a name.";
                properties.put(childName, VkAssetPropertyFormatter.getAssetViewPropertyForArgumentHierarchy(child, propertyResolutionMap));
            }
            return properties;
        }
        assert (node instanceof ArgumentHierarchyLeaf);
        String value = ((ArgumentHierarchyLeaf)node).getValue();
        @Nullable IAssetProperty replacementProperty = propertyResolutionMap.get(value);
        if (replacementProperty != null) {
            return replacementProperty;
        }
        return ValueAssetProperty.create(value);
    }

    public static @NonNull IAssetProperty getAssetViewProperty(@Nullable Object property) {
        if (property == null) {
            return ValueAssetProperty.NULL;
        }
        if (property instanceof LongsArgAttachment) {
            return VkAssetPropertyFormatter.getAssetViewProperty((LongsArgAttachment)property);
        }
        if (property instanceof AbstractContainerWrapperType) {
            return VkAssetPropertyFormatter.getAssetViewProperty((AbstractContainerWrapperType)property);
        }
        if (property instanceof ArgumentContainerAttachment) {
            return VkAssetPropertyFormatter.getAssetViewProperty((ArgumentContainerAttachment)property);
        }
        if (property instanceof ArgumentContainerArrayAttachment) {
            return VkAssetPropertyFormatter.getAssetViewProperty((ArgumentContainerArrayAttachment)property);
        }
        if (property instanceof IAssetItem) {
            return VkAssetPropertyFormatter.getAssetViewProperty((IAssetItem)property);
        }
        if (property instanceof IArgument) {
            return VkAssetPropertyFormatter.getAssetViewProperty(property);
        }
        return ValueAssetProperty.create((String)NullUtils.neverNull((Object)property.toString()));
    }
}

