/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateData;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import com.arm.mgd.kapi.gen.ScopeSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;

public class TargetAssetMap
implements Serializable {
    private static final long serialVersionUID = -2828268664438631058L;
    private final KapiSpec apiSpec;
    private final Map<AssetTableSpec, AssetTable> assetTableMap;

    public TargetAssetMap(@NonNull TraceStateData parentStateData, KapiSpec apiSpec, ScopeSpec limitScope, @NonNull FunctionCall currentFunctionCall) {
        this.apiSpec = apiSpec;
        TreeMap<AssetTableSpec, AssetTable> sortedMap = new TreeMap<AssetTableSpec, AssetTable>();
        for (AssetTableSpec assetTableSpec : apiSpec.getApi().getAssetTables().getAssetTable()) {
            assert (assetTableSpec != null);
            if (limitScope != null && assetTableSpec.getScope() != limitScope) continue;
            sortedMap.put(assetTableSpec, new AssetTable(parentStateData, assetTableSpec));
        }
        this.assetTableMap = new LinkedHashMap<AssetTableSpec, AssetTable>(sortedMap);
        this.resetAll(currentFunctionCall);
    }

    public AssetTable getAssetTable(AssetTableSpec assetTableSpec) {
        AssetTable table = this.assetTableMap.get(assetTableSpec);
        assert (table != null);
        return table;
    }

    private void resetAll(@NonNull FunctionCall currentFunctionCall) {
        for (AssetTable t : this.assetTableMap.values()) {
            t.resetToDefault(currentFunctionCall);
        }
    }

    public Collection<AssetTable> getAssetTables() {
        return new ArrayList<AssetTable>(this.assetTableMap.values());
    }

    public void clearGlobalAssetState(@NonNull FunctionCall currentFunctionCall) {
        this.resetAll(currentFunctionCall);
    }
}

