/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ClProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.ComparatorUtils;
import com.arm.mgd.core.util.CoreLogging;

public class SourceProvider {
    private String source;
    private final String name;
    private boolean isDirtyFlag = false;
    private SourceType sourceType;

    public SourceProvider(GlShaderAsset shaderAsset) {
        this.source = shaderAsset.getSource();
        if (KapiSpec.GLES.constants.GL_VERTEX_SHADER.equals(shaderAsset.getType())) {
            this.sourceType = SourceType.VERTEX;
        } else if (KapiSpec.GLES.constants.GL_FRAGMENT_SHADER.equals(shaderAsset.getType())) {
            this.sourceType = SourceType.FRAGMENT;
        } else if (KapiSpec.GLES.constants.GL_COMPUTE_SHADER.equals(shaderAsset.getType())) {
            this.sourceType = SourceType.COMPUTE;
        } else if (KapiSpec.GLES.constants.GL_GEOMETRY_SHADER.equals(shaderAsset.getType())) {
            this.sourceType = SourceType.GEOMETRY;
        } else if (KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER.equals(shaderAsset.getType())) {
            this.sourceType = SourceType.TESS_CONTROL;
        } else if (KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER.equals(shaderAsset.getType())) {
            this.sourceType = SourceType.TESS_EVALUATION;
        } else {
            CoreLogging.severe(null, "Unknown Shader Type");
        }
        this.name = shaderAsset.getLabelText();
    }

    public SourceProvider(ClProgramAsset programAsset) {
        this.source = programAsset.getSource();
        this.sourceType = SourceType.CL;
        this.name = programAsset.getLabelText();
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String newSource) {
        this.source = newSource;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirty() {
        return this.isDirtyFlag;
    }

    public void setDirty(boolean dirtyValue) {
        this.isDirtyFlag = dirtyValue;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SourceProvider) {
            SourceProvider that = (SourceProvider)obj;
            return ComparatorUtils.equalNullables(this.sourceType, that.sourceType) && ComparatorUtils.equalNullables(this.source, that.source);
        }
        return false;
    }

    public int hashCode() {
        return this.sourceType.hashCode();
    }

    public static enum SourceType {
        VERTEX,
        FRAGMENT,
        COMPUTE,
        GEOMETRY,
        TESS_CONTROL,
        TESS_EVALUATION,
        CL;

    }
}

