/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AbstractAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AssetTableSpec;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class SourceAsset
extends AbstractAssetItem {
    private static final long serialVersionUID = 6374692521507164497L;
    protected ISourceProvider sourceProvider;

    protected SourceAsset(@NonNull AssetTableSpec assetSpec, @NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id) {
        super(assetSpec, snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
    }

    public String getSource() {
        if (this.sourceProvider != null) {
            return this.sourceProvider.getConcatenatedString();
        }
        return null;
    }

    public @Nullable ISourceProvider getSourceProvider() {
        return this.sourceProvider;
    }

    public void setSource(@NonNull FunctionCall lastModification, @NonNull ISourceProvider sourceProvider) {
        this.setPreviousModificationFunction(lastModification);
        this.sourceProvider = sourceProvider;
    }

    public static interface ISourceProvider
    extends Serializable {
        public @NonNull String getConcatenatedString();
    }

    public static final class StringSourceProvider
    implements ISourceProvider {
        private static final long serialVersionUID = 1159866921853554850L;
        private final @NonNull String string;

        public StringSourceProvider(@NonNull String string) {
            this.string = string;
        }

        public boolean equals(Object obj) {
            if (obj instanceof StringSourceProvider) {
                return ((StringSourceProvider)obj).string.equals(this.string);
            }
            return false;
        }

        @Override
        public @NonNull String getConcatenatedString() {
            return this.string;
        }

        public int hashCode() {
            return this.string.hashCode();
        }
    }
}

