/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.UsageSpec;
import com.arm.mgd.kapi.gen.DisplayEnum;
import com.arm.mgd.utils.NullUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class LongsArgAttachmentProcessor {
    private final @NonNull KapiSpec kapiSpec;
    private final @NonNull Method processor;
    private final @Nullable UsageSpec usageSpec;

    public LongsArgAttachmentProcessor(@NonNull KapiSpec kapiSpec, @NonNull DisplayEnum display, @Nullable UsageSpec usageSpec) {
        Method procMethod = null;
        try {
            procMethod = LongsArgAttachmentProcessor.class.getDeclaredMethod("formatProcessor_" + display.value(), Long[].class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            assert (false) : "Unexpected format for ArraySpec: " + (Object)((Object)display);
            try {
                procMethod = LongsArgAttachmentProcessor.class.getDeclaredMethod("formatProcessor_default", Long[].class);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
        }
        this.kapiSpec = kapiSpec;
        this.processor = (Method)NullUtils.neverNull(procMethod);
        this.usageSpec = usageSpec;
    }

    public String valuesToString(@NonNull Long @NonNull [] values) {
        try {
            return "[" + this.processor.invoke((Object)this, new Object[]{values}) + "]";
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    public String valueToString(@NonNull Long value) {
        try {
            return this.processor.invoke((Object)this, new Object[]{new Long[]{value}}).toString();
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            assert (false);
            return null;
        }
    }

    protected String formatProcessor_constant(@NonNull Long @NonNull [] values) {
        Object[] constValues = new AbstractConstantOrAliasSpecExtended[values.length];
        int i = 0;
        while (i < values.length) {
            Long v = values[i];
            AbstractConstantOrAliasSpecExtended constantSpec = null;
            if (this.usageSpec != null) {
                constantSpec = this.usageSpec.getConstantSpecByValue(v);
            }
            if (constantSpec == null) {
                constantSpec = this.kapiSpec.getConstantSpecByValue(v);
            }
            constValues[i] = constantSpec;
            ++i;
        }
        return StringUtils.arrayToString(constValues);
    }

    protected static String formatProcessor_default(@NonNull Long @NonNull [] values) {
        return StringUtils.arrayToString(values);
    }

    protected static String formatProcessor_hex(@NonNull Long @NonNull [] values) {
        Object[] hexValues = new String[values.length];
        int i = 0;
        while (i < values.length) {
            Long v = values[i];
            hexValues[i] = "0x" + Long.toHexString(v);
            ++i;
        }
        return StringUtils.arrayToString(hexValues);
    }
}

