/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractGlVertexBufferBindingAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public class GlVertexBufferBindingAsset
extends AbstractGlVertexBufferBindingAsset {
    private static final long serialVersionUID = 6652946118160492482L;

    public static @NonNull GlVertexBufferBindingAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull GlVertexArrayObjectAsset parentAsset) {
        return new GlVertexBufferBindingAsset(createdByFunction, parentAsset, assetAttachment.getId());
    }

    public GlVertexBufferBindingAsset(FunctionCall createdByFunction, @NonNull GlVertexArrayObjectAsset parentAsset, long index) {
        super(createdByFunction, parentAsset, index);
    }

    @Override
    public @NonNull String getLabelText() {
        return String.format("VBO Binding %s", String.valueOf(this.getId()));
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        GlBufferAsset buffer = this.getBuffer();
        properties.put("Bound Buffer", buffer != null ? buffer : ValueAssetProperty.NONE);
        properties.put("Divisor", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getDivisor())));
        properties.put("Offset", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getOffset())));
        properties.put("Stride", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getStride())));
        return properties;
    }
}

