/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;

public class GlVertexAttributeNonArrayValueAsset
extends AbstractGlVertexAttributeNonArrayValueAsset {
    public static final @NonNull Number @NonNull [] DEFAULT_VERTEX = new Number[]{NullUtils.floatValueOf((float)0.0f), NullUtils.floatValueOf((float)0.0f), NullUtils.floatValueOf((float)0.0f), NullUtils.floatValueOf((float)1.0f)};
    private static final long serialVersionUID = -8562138816764166752L;

    public static @NonNull GlVertexAttributeNonArrayValueAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, Number[] value) {
        return new GlVertexAttributeNonArrayValueAsset(builder.getSnapshotAssetParent(), createdByFunction, assetAttachment.getId(), value);
    }

    public GlVertexAttributeNonArrayValueAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long index) {
        this(snapshotAssetParent, createdByFunction, index, (Number[])DEFAULT_VERTEX.clone());
    }

    public GlVertexAttributeNonArrayValueAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long index, Number[] value) {
        super(snapshotAssetParent, createdByFunction, index, (Number[])DEFAULT_VERTEX.clone());
        assert (value != null);
        assert (value.length <= DEFAULT_VERTEX.length);
        int i = 0;
        while (i < value.length) {
            assert (value[i] != null);
            this.setValue(i, value[i]);
            ++i;
        }
    }

    @Override
    public @NonNull String getLabelText() {
        return (String)NullUtils.neverNull((Object)this.getId().toString());
    }

    public @NonNull Number @NonNull [] getValue() {
        @NonNull Number @NonNull [] data = new Number[4];
        int i = 0;
        while (i < data.length) {
            Number n = this.getValue(i);
            data[i] = n != null ? (Number)n : (Number)NullUtils.floatValueOf((float)0.0f);
            ++i;
        }
        return data;
    }

    public void setValue(Number[] value) {
        assert (value.length <= DEFAULT_VERTEX.length);
        int i = 0;
        while (i < DEFAULT_VERTEX.length) {
            this.setValue(i, i < value.length ? (Number)value[i] : (Number)DEFAULT_VERTEX[i]);
            ++i;
        }
    }

    public void setValue(Number[] value, FunctionCall modifiedBy) {
        assert (modifiedBy != null);
        this.setValue(value);
        this.setPreviousModificationFunction(modifiedBy);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Value", ValueAssetProperty.create((String)NullUtils.neverNull((Object)Arrays.toString(this.getValue()))));
        return properties;
    }
}

