/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.GlVertexAttributeNonArrayValueAsset;
import com.arm.mgd.core.asset.GlVertexBufferBindingAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractGlVertexAttributeAsset;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.target.data.ApiUsageException;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IVertexProvider;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlVertexAttributeAsset
extends AbstractGlVertexAttributeAsset {
    private static final long serialVersionUID = -4229229570834008043L;
    private @Nullable IVertexProvider clientVertexProvider = null;

    public static @NonNull GlVertexAttributeAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull GlVertexArrayObjectAsset parentAsset) {
        Number[] defaultValue = AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeNonArrayValueAssetValue(builder.getSnapshotAssetParent().getTraceStateSnapshot(), createdByFunction, assetAttachment.getId());
        GlVertexAttributeNonArrayValueAsset nonArrayDataSource = AssetProcessorBase.getOrCreateNewGlVertexAttributeNonArrayValueAsset(builder.getSnapshotAssetParent().getTraceStateSnapshot(), createdByFunction, assetAttachment.getId(), defaultValue);
        return new GlVertexAttributeAsset(parentAsset, assetAttachment.getId(), nonArrayDataSource);
    }

    public GlVertexAttributeAsset(@NonNull GlVertexArrayObjectAsset parentAsset, long index, @NonNull GlVertexAttributeNonArrayValueAsset nonArrayDataSource) {
        super(parentAsset.getCreatedByFunction(), parentAsset, index, nonArrayDataSource);
    }

    @Override
    public String getLabelText() {
        return "Vertex Attribute " + this.getId();
    }

    @Override
    public boolean isAssetActive() {
        return this.getParentAsset().isAssetActive();
    }

    public static @NonNull GlVertexAttributeAsset getVertexAttributeAssetById(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, long id) {
        GlVertexArrayObjectAsset vao = GlVertexArrayObjectAsset.getOrCreateVertexArrayObjectAt(currentState, functionCall, null);
        return vao.getVertexAttributeAssetById(id);
    }

    public @NonNull Number @Nullable [] getVertex(int index, int instance) throws UnsupportedTypeException {
        assert (index >= 0);
        if (this.isArrayEnabled()) {
            @Nullable IVertexProvider vertexProvider = this.getVertexProvider();
            if (vertexProvider != null) {
                GlVertexBufferBindingAsset vboBinding = this.getVboBinding();
                if (vboBinding.getDivisor() != 0L) {
                    index = (int)((long)instance / vboBinding.getDivisor());
                }
                @NonNull Number @Nullable [] vertex = vertexProvider.getVertex(index, vboBinding.getStride(), vboBinding.getOffset() + this.getVboRelativeOffset(), this.getArraySize(), this.getArrayType());
                return GlVertexAttributeAsset.fillMissingValuesWithDefaults(vertex);
            }
            return null;
        }
        return this.getNonArrayDataSource().getValue();
    }

    static @NonNull Number @Nullable [] fillMissingValuesWithDefaults(@NonNull Number @Nullable [] inputVertex) {
        if (inputVertex == null || inputVertex.length == GlVertexAttributeNonArrayValueAsset.DEFAULT_VERTEX.length) {
            return inputVertex;
        }
        assert (inputVertex.length <= GlVertexAttributeNonArrayValueAsset.DEFAULT_VERTEX.length);
        @NonNull Number @NonNull [] completeVertex = new Number[GlVertexAttributeNonArrayValueAsset.DEFAULT_VERTEX.length];
        int i = 0;
        while (i < inputVertex.length) {
            completeVertex[i] = inputVertex[i];
            ++i;
        }
        i = inputVertex.length;
        while (i < GlVertexAttributeNonArrayValueAsset.DEFAULT_VERTEX.length) {
            completeVertex[i] = GlVertexAttributeNonArrayValueAsset.DEFAULT_VERTEX[i];
            ++i;
        }
        return completeVertex;
    }

    public void setClientVertexProvider(IVertexProvider vertexProvider) {
        this.clientVertexProvider = vertexProvider;
    }

    public void checkBounds() throws ApiUsageException {
        IVertexProvider vertexProvider;
        if (this.isArrayEnabled() && (vertexProvider = this.getVertexProvider()) != null) {
            vertexProvider.checkBounds(this.getVboBinding().getOffset());
        }
    }

    private @Nullable IVertexProvider getVertexProvider() {
        GlBufferAsset buffer = this.getVboBinding().getBuffer();
        if (buffer != null) {
            return buffer;
        }
        return this.clientVertexProvider;
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Array Enabled", ValueAssetProperty.fromBoolean(this.isArrayEnabled()));
        properties.put("Array Size", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getArraySize())));
        properties.put("Array Stride", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getArrayStride())));
        properties.put("Array Type", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getArrayType().getName())));
        properties.put("Array Normalized", ValueAssetProperty.fromBoolean(this.isArrayNormalized()));
        properties.put("Array Integer", ValueAssetProperty.fromBoolean(this.isArrayInteger()));
        properties.put("Array Pointer", ValueAssetProperty.create(this.getArrayPointer().toString()));
        properties.put("Binding", (IAssetProperty)NullUtils.neverNull((Object)this.getVboBinding()));
        properties.put("Relative Offset", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getVboRelativeOffset())));
        properties.put("Non-Array Data", ValueAssetProperty.create(NullUtils.toString((Object[])this.getNonArrayDataSource().getValue())));
        return properties;
    }
}

