/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlVertexAttributeAsset;
import com.arm.mgd.core.asset.GlVertexBufferBindingAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.IAssetItemWithParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlVertexArrayObjectAsset;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.utils.NullUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlVertexArrayObjectAsset
extends AbstractGlVertexArrayObjectAsset {
    private static final long serialVersionUID = -1033007982128663674L;
    private final Map<@NonNull Long, GlVertexBufferBindingAsset> vbos = new HashMap<Long, GlVertexBufferBindingAsset>();
    private final @NonNull Map<@NonNull Long, GlVertexAttributeAsset> vertexAttributes = new HashMap<Long, GlVertexAttributeAsset>();

    public static @NonNull GlVertexArrayObjectAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlVertexArrayObjectAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId());
    }

    public static GlVertexArrayObjectAsset getCurrentVertexArrayObject(TraceStateSnapshot currentSnapshot) {
        AssetTable at = currentSnapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS.SPEC);
        Long currentActiveVAO = currentSnapshot.getStateItemBySpec(KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING).getValue()[0].getValueAsLong();
        return (GlVertexArrayObjectAsset)at.get(currentActiveVAO);
    }

    public static @NonNull GlVertexArrayObjectAsset getOrCreateVertexArrayObjectAt(@NonNull TraceStateSnapshot currentSnapshot, @NonNull FunctionCall functionCall, @Nullable Long idOfVao) {
        AssetTable at = currentSnapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.VERTEX_ARRAY_OBJECT_TRAITS.SPEC);
        if (idOfVao == null) {
            idOfVao = currentSnapshot.getStateItemBySpec(KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING).getValue()[0].getValueAsLong();
        }
        assert (idOfVao != null);
        GlVertexArrayObjectAsset vao = (GlVertexArrayObjectAsset)at.get(idOfVao);
        if (vao == null) {
            vao = new GlVertexArrayObjectAsset(currentSnapshot.asSnapshotAssetParent(), functionCall, idOfVao);
            currentSnapshot.addAsset(vao);
        }
        return vao;
    }

    public GlVertexArrayObjectAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id);
    }

    public GlVertexArrayObjectAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
    }

    @Override
    public void addChildAssetForMidstreamTrace(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull IAssetItemWithParent<GlVertexArrayObjectAsset> childAsset) {
        if (childAsset instanceof GlVertexAttributeAsset) {
            GlVertexAttributeAsset attributeAsset = (GlVertexAttributeAsset)childAsset;
            this.vertexAttributes.put(attributeAsset.getId(), attributeAsset);
        } else if (childAsset instanceof GlVertexBufferBindingAsset) {
            GlVertexBufferBindingAsset vboAsset = (GlVertexBufferBindingAsset)childAsset;
            this.vbos.put(vboAsset.getId(), vboAsset);
        } else assert (false);
    }

    @Override
    public @NonNull String getLabelText() {
        return "Vertex Array Object " + this.getId();
    }

    public @NonNull GlVertexBufferBindingAsset getOrCreateNewGlVertexBufferBindingAsset(long id) {
        Long idObject = NullUtils.longValueOf((long)id);
        GlVertexBufferBindingAsset result = this.vbos.get(idObject);
        if (result == null) {
            result = new GlVertexBufferBindingAsset(this.getCreatedByFunction(), this, id);
            this.vbos.put(idObject, result);
        }
        return result;
    }

    public @NonNull GlVertexAttributeAsset getVertexAttributeAssetById(long attributeIndex) {
        Long attributeIndexObject = NullUtils.longValueOf((long)attributeIndex);
        GlVertexAttributeAsset result = this.vertexAttributes.get(attributeIndexObject);
        if (result == null) {
            Number[] defaultValue = AssetProcessorBase.getDefaultPropertyValueForGlVertexAttributeNonArrayValueAssetValue(this.getSnapshotAssetParent().getTraceStateSnapshot(), this.getCreatedByFunction(), attributeIndex);
            result = new GlVertexAttributeAsset(this, attributeIndex, AssetProcessorBase.getOrCreateNewGlVertexAttributeNonArrayValueAsset(this.getSnapshotAssetParent().getTraceStateSnapshot(), this.getCreatedByFunction(), attributeIndex, defaultValue));
            result.setVboBinding(this.getOrCreateNewGlVertexBufferBindingAsset(attributeIndex));
            this.vertexAttributes.put(attributeIndexObject, result);
        }
        return result;
    }

    public @NonNull Map<Long, GlVertexAttributeAsset> getVertexAttributesCollection() {
        return Collections.unmodifiableMap(this.vertexAttributes);
    }

    public void replaceElementArrayBufferBinding(TraceStateSnapshot snapshot) {
        AssetTable assetTableBySpec = snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.BUFFER_TRAITS.SPEC);
        GlBufferAsset boundBuffer = this.getElementArrayBufferBinding();
        Long bufferID = boundBuffer != null ? boundBuffer.getId() : Long.valueOf(0L);
        boundBuffer = (GlBufferAsset)(bufferID != 0L ? assetTableBySpec.get(bufferID) : null);
        Long l = bufferID = boundBuffer != null ? boundBuffer.getId() : Long.valueOf(0L);
        if (boundBuffer != null) {
            boundBuffer.setLastBoundTarget(KapiSpec.GLES.constants.GL_ELEMENT_ARRAY_BUFFER);
        }
    }

    @Override
    public boolean isAssetActive() {
        TraceStateSnapshot state = this.getSnapshotAssetParent().getTraceStateSnapshot();
        StateItem currentVAOState = state.getStateItemBySpec(KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING);
        return this.equals(currentVAOState.getValueAsAsset());
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        GlBufferAsset buffer = this.getElementArrayBufferBinding();
        properties.put("Element Array Buffer Binding", buffer != null ? buffer : ValueAssetProperty.NONE);
        AssetPropertyContainer attributes = new AssetPropertyContainer();
        for (Map.Entry<Long, GlVertexAttributeAsset> vertexAttribute : this.vertexAttributes.entrySet()) {
            attributes.put((String)NullUtils.neverNull((Object)vertexAttribute.getKey().toString()), (IAssetProperty)NullUtils.neverNull((Object)vertexAttribute.getValue()));
        }
        properties.put("Vertex Attributes", attributes);
        return properties;
    }
}

