/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlUniformBindingPointAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public class GlUniformBindingPointAsset
extends AbstractGlUniformBindingPointAsset {
    private static final long serialVersionUID = -350643369551523078L;

    public static @NonNull GlUniformBindingPointAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlUniformBindingPointAsset(builder.getSnapshotAssetParent(), createdByFunction, assetAttachment.getId());
    }

    public GlUniformBindingPointAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id) {
        super(snapshotAssetParent, createdByFunction, id);
    }

    @Override
    public @NonNull String getLabelText() {
        GlBufferAsset buffer = this.getBuffer();
        if (buffer == null) {
            return (String)NullUtils.neverNull((Object)String.format("%d : <not bound>", this.getId()));
        }
        return (String)NullUtils.neverNull((Object)String.format("%d : %s {offset=0x%s, length=0x%s}", this.getId(), buffer.getId(), Long.toHexString(this.getOffset()), Long.toHexString(this.getLength())));
    }

    public void setBufferBinding(@NonNull FunctionCall functionCall, GlBufferAsset buffer, long offset, long length) {
        assert (offset >= 0L && offset <= Integer.MAX_VALUE);
        assert (length >= 0L && length <= Integer.MAX_VALUE);
        assert (offset + length >= 0L && offset + length <= Integer.MAX_VALUE);
        this.setPreviousModificationFunction(functionCall);
        this.setBuffer(buffer);
        this.setOffset(offset);
        this.setLength(length);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        GlBufferAsset buffer = this.getBuffer();
        properties.put("Bound Buffer", buffer != null ? buffer : ValueAssetProperty.NONE);
        properties.put("Offset", ValueAssetProperty.create((String)NullUtils.neverNull((Object)Long.toHexString(this.getOffset()))));
        properties.put("Length", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getLength())));
        return properties;
    }

    @Override
    public boolean hasProperties() {
        return this.getBuffer() != null;
    }
}

