/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlSamplerAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlTextureUnitAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.gen.TargetBindingSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class GlTextureUnitAsset
extends AbstractGlTextureUnitAsset {
    private static final long serialVersionUID = -1294406986913640332L;

    public static @NonNull GlTextureUnitAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlTextureUnitAsset(builder.getSnapshotAssetParent(), createdByFunction, assetAttachment.getId());
    }

    public GlTextureUnitAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id) {
        super(snapshotAssetParent, createdByFunction, id);
        assert (id >= 0L && id < 256L) : "New texture unit has an unrealistic ID (" + id + ")";
    }

    @Override
    public String getLabelText() {
        return "GL_TEXTURE" + this.getId();
    }

    public @NonNull Set<@NonNull AbstractConstantOrAliasSpecExtended> getAllBoundTargets() {
        HashSet<@NonNull AbstractConstantOrAliasSpecExtended> result = new HashSet<AbstractConstantOrAliasSpecExtended>();
        for (TargetBindingSpec binding : KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject.getTargetBinding()) {
            AbstractConstantOrAliasSpecExtended target = (AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)binding.getTarget());
            GlTextureAsset texture = this.getTextureTargets(target);
            if (texture == null) continue;
            result.add(target);
        }
        return result;
    }

    public @NonNull Set<@NonNull GlTextureAsset> getAllBoundTextures() {
        HashSet<@NonNull GlTextureAsset> result = new HashSet<GlTextureAsset>();
        for (TargetBindingSpec binding : KapiSpec.GLES.targetBindingMaps.TEXTURE_TARGETS.specObject.getTargetBinding()) {
            AbstractConstantOrAliasSpecExtended target = (AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)binding.getTarget());
            GlTextureAsset texture = this.getTextureTargets(target);
            if (texture == null) continue;
            result.add(texture);
        }
        return result;
    }

    public static @NonNull AbstractConstantOrAliasSpecExtended convertTextureUnitIdToTextureUnitEnum(@NonNull Long id) {
        Long baseValue = KapiSpec.GLES.constants.GL_TEXTURE0.getResolvedValue();
        return KapiSpec.GLES.constantGroups.TEXTUREUNIT.getConstantSpecByValue((Long)NullUtils.neverNull((Object)(baseValue + id)));
    }

    public static @NonNull Long convertTextureUnitEnumToTextureUnitId(@NonNull AbstractConstantOrAliasSpecExtended e) {
        Long baseValue = KapiSpec.GLES.constants.GL_TEXTURE0.getResolvedValue();
        return NullUtils.longValueOf((long)(e.getResolvedValue() - baseValue));
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        GlSamplerAsset sampler = this.getSampler();
        if (sampler != null) {
            properties.put("Sampler", sampler);
        }
        @NonNull Map<AbstractConstantOrAliasSpecExtended, GlTextureAsset> textureTargets = this.getTextureTargetsCollection();
        for (Map.Entry<AbstractConstantOrAliasSpecExtended, GlTextureAsset> textureTarget : textureTargets.entrySet()) {
            properties.put((String)NullUtils.neverNull((Object)textureTarget.getKey().getName()), (IAssetProperty)NullUtils.neverNull((Object)textureTarget.getValue()));
        }
        return properties;
    }

    @Override
    public boolean hasProperties() {
        return this.getSampler() != null || this.getTextureTargetsCollection().size() != 0;
    }
}

