/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlImageOffset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.objects.IAssetItemWithParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlTextureSurfaceAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.texture.IGlTextureLayerData;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FramebufferAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.CoreLogging;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.core.util.TextureAssetUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlTextureSurfaceAsset
extends AbstractGlTextureSurfaceAsset {
    private static final long serialVersionUID = 4574402082376278219L;
    private final Map<Long, GlTextureImageAsset> textureLevelImages = new TreeMap<Long, GlTextureImageAsset>();

    public static @NonNull GlTextureSurfaceAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull GlTextureAsset parentAsset) {
        return parentAsset.getOrCreateTextureSurfaceById(createdByFunction, assetAttachment.getId());
    }

    public GlTextureSurfaceAsset(FunctionCall createdByFunction, @NonNull GlTextureAsset parentAsset, long id) {
        this(createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, parentAsset, id);
    }

    public GlTextureSurfaceAsset(FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, @NonNull GlTextureAsset parentAsset, long id) {
        super(createdByFunction, uniqueInstanceId, parentAsset, id);
    }

    @Override
    public void addChildAssetForMidstreamTrace(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull IAssetItemWithParent<GlTextureSurfaceAsset> childAsset) {
        assert (childAsset instanceof GlTextureImageAsset);
        GlTextureImageAsset imageAsset = (GlTextureImageAsset)childAsset;
        this.textureLevelImages.put(imageAsset.getId(), imageAsset);
    }

    public int getBaseMipMapLevel() {
        long result = this.getParentAsset().getBaseLevel();
        assert (result >= Integer.MIN_VALUE && result <= Integer.MAX_VALUE);
        return (int)result;
    }

    public @NonNull String getExportLabel() {
        AbstractConstantOrAliasSpecExtended target = this.getParentAsset().getTextureTarget();
        if (target == null || target.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D)) {
            return "";
        }
        if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP)) {
            return (String)NullUtils.neverNull((Object)TextureAssetUtils.CUBEMAP_EXPORT_ID_LABEL.get(this.getId()));
        }
        return "_" + String.valueOf(this.getId());
    }

    @Override
    public @NonNull String getLabelText() {
        int numLevels = this.textureLevelImages.size();
        return String.valueOf(String.valueOf(this.textureLevelImages.size())) + StringUtils.formatQuantity(numLevels, " Mip Level", " Mip Levels");
    }

    public @NonNull List<@NonNull GlTextureImageAsset> getMipmapImages() {
        int baseLevel = this.getBaseMipMapLevel();
        int numLevels = this.getNumMipMapLevels();
        List<@NonNull T> mipMapImages = this.textureLevelImages.values().stream().filter(imageLevel -> imageLevel.getId() >= (long)baseLevel && imageLevel.getId() < (long)(baseLevel + numLevels)).collect(Collectors.toList());
        return new ArrayList<GlTextureImageAsset>(mipMapImages);
    }

    public int getNumMipMapLevels() {
        int baseLevel = this.getBaseMipMapLevel();
        GlTextureImageAsset baseImage = this.textureLevelImages.get(baseLevel);
        if (baseImage == null) {
            return 1;
        }
        return TextureAssetUtils.getNumMipMapLevels(baseImage.getWidth(), baseImage.getHeight(), baseImage.hasDepthComponent() ? Long.valueOf(baseImage.getDepth()) : null);
    }

    public @NonNull GlTextureImageAsset getOrCreateTextureLevel(@NonNull FunctionCall functionCall, long level, boolean specifyingStorage) {
        Long id;
        GlTextureImageAsset result;
        if (!specifyingStorage && !this.isValidMipmapLevel(level)) {
            CoreLogging.warning(null, "Unexpected mimmap level : " + level + " vs [" + this.getBaseMipMapLevel() + ", " + this.getNumMipMapLevels() + ") in " + this.getParentAsset().getId() + "." + this.getId() + ": " + this.getParentAsset().getTextureTarget());
        }
        if ((result = this.textureLevelImages.get(id = Long.valueOf(level))) == null) {
            result = new GlTextureImageAsset(functionCall, this, level);
            this.textureLevelImages.put(id, result);
        }
        return result;
    }

    public @Nullable GlTextureImageAsset getTextureLevel(int level) {
        if (this.isValidMipmapLevel(level)) {
            return this.textureLevelImages.get(level);
        }
        return null;
    }

    public boolean isCubeMapCrossImageSurface() {
        AbstractConstantOrAliasSpecExtended textureTarget = this.getParentAsset().getTextureTarget();
        return this.getId() == -1L && textureTarget != null && textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP);
    }

    public boolean isValidMipmapLevel(long level) {
        int baseMipMapLevel = this.getBaseMipMapLevel();
        return level >= (long)baseMipMapLevel && level < (long)(baseMipMapLevel + this.getNumMipMapLevels());
    }

    public void addMidstreamTextureThumbnail(@NonNull FramebufferAttachment attachment) {
        GlTextureImageAsset imageAsset = this.getOrCreateTextureLevel(attachment.getParentFunctionCall(), this.getBaseMipMapLevel(), false);
        GlImageOffset offset = new GlImageOffset(0, 0);
        IGlTextureLayerData textureData = IGlTextureLayerData.create(attachment);
        Dimension size = attachment.size;
        AbstractConstantOrAliasSpecExtended format = attachment.format;
        AbstractConstantOrAliasSpecExtended type = attachment.type;
        imageAsset.addTextureLayerToLevel(attachment.getParentFunctionCall(), offset, textureData, size, format, type, true);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        for (Map.Entry<Long, GlTextureImageAsset> image : this.textureLevelImages.entrySet()) {
            properties.put("Level " + image.getKey(), (IAssetProperty)NullUtils.neverNull((Object)image.getValue()));
        }
        return properties;
    }
}

