/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlImageOffset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractGlTextureImageAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.asset.texture.GlTextureCompositor;
import com.arm.mgd.core.asset.texture.GlTextureLayer;
import com.arm.mgd.core.asset.texture.IGlTextureLayerData;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlTextureImageAsset
extends AbstractGlTextureImageAsset {
    private static final long serialVersionUID = 3233956723034887054L;
    private final @NonNull GlTextureCompositor compositor = new GlTextureCompositor();

    public static @NonNull GlTextureImageAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull GlTextureSurfaceAsset parentAsset) {
        return parentAsset.getOrCreateTextureLevel(createdByFunction, assetAttachment.getId(), true);
    }

    /*
     * Unable to fully structure code
     */
    public static long scaleMipmapDimension(long length, long currentLevel, long levels) {
        block2: {
            if (levels <= 0L) break block2;
            if (!GlTextureImageAsset.$assertionsDisabled && currentLevel >= levels) {
                throw new AssertionError();
            }
            if (GlTextureImageAsset.$assertionsDisabled || length > 0L) ** GOTO lbl7
            throw new AssertionError();
lbl-1000:
            // 1 sources

            {
                length /= 2L;
lbl7:
                // 2 sources

                ** while (currentLevel-- > 0L)
            }
        }
        return length > 0L ? length : 1L;
    }

    public GlTextureImageAsset(FunctionCall createdByFunction, @NonNull GlTextureSurfaceAsset parentAsset, long level) {
        this(createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, parentAsset, level);
    }

    public GlTextureImageAsset(FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, @NonNull GlTextureSurfaceAsset parentAsset, long level) {
        super(createdByFunction, uniqueInstanceId, parentAsset, level);
    }

    public void addTextureLayerToLevel(@NonNull FunctionCall lastModification, @NonNull GlImageOffset glImageOffset, @Nullable IGlTextureLayerData textureData, @NonNull Dimension size, @NonNull AbstractConstantOrAliasSpecExtended internalFormat, @Nullable AbstractConstantOrAliasSpecExtended type, boolean replaceExisting) {
        this.setPreviousModificationFunction(lastModification);
        if (replaceExisting) {
            this.compositor.removeElementsIf(glImageBuffer -> glImageOffset.target.equals(glImageBuffer.getOffset().target));
            this.setWidth(size.getWidth());
            this.setHeight(size.getHeight());
            this.setDepth(size.getDepth());
            this.setInternalFormat(internalFormat);
        }
        this.compositor.addElement(new GlTextureLayer(textureData, glImageOffset, size, internalFormat, type));
    }

    public @NonNull Dimension getSize() {
        if (this.hasDepthComponent()) {
            return new Dimension((int)this.getWidth(), (int)this.getHeight(), (int)this.getDepth());
        }
        return new Dimension((int)this.getWidth(), (int)this.getHeight());
    }

    public @NonNull GlTextureCompositor getGlTextureCompositor() {
        return this.compositor;
    }

    @Override
    public @NonNull String getLabelText() {
        return this.getSize().toString();
    }

    public boolean hasDepthComponent() {
        AbstractConstantOrAliasSpecExtended textureTarget = this.getParentAsset().getParentAsset().getTextureTarget();
        return textureTarget != null && textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D);
    }

    public boolean hasSamplesComponent() {
        AbstractConstantOrAliasSpecExtended textureTarget = this.getParentAsset().getParentAsset().getTextureTarget();
        return textureTarget != null && textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE);
    }

    public @Nullable GlTextureImageAsset mapCubeMapFaceCrossCompositorToAnyCubeMapFace() {
        if (this.getParentAsset().isCubeMapCrossImageSurface()) {
            for (GlTextureSurfaceAsset actualFace : this.getParentAsset().getParentAsset().getSurfaces()) {
                GlTextureImageAsset mipLevel;
                if (actualFace.isCubeMapCrossImageSurface() || (mipLevel = actualFace.getTextureLevel(this.getId().intValue())) == null) continue;
                return mipLevel;
            }
        }
        return null;
    }

    public void setStorageProperties(@NonNull AbstractConstantOrAliasSpecExtended internalformat, int levels, int width, int height, @Nullable Integer depth) {
        boolean isTexture3D = this.hasDepthComponent();
        assert (isTexture3D && depth != null || !isTexture3D) : "TEXTURE_3D is missing depth value";
        this.setInternalFormat(internalformat);
        this.setWidth(GlTextureImageAsset.scaleMipmapDimension(width, this.getId().intValue(), levels));
        this.setHeight(GlTextureImageAsset.scaleMipmapDimension(height, this.getId().intValue(), levels));
        this.setDepth(GlTextureImageAsset.scaleMipmapDimension(isTexture3D ? (Integer)NullUtils.neverNull((Object)depth) : 1, this.getId().intValue(), levels));
        this.compositor.resetImageDataAndClearTextureLayers();
        if (this.getDepth() == 1L) {
            this.compositor.addElement(new GlTextureLayer(null, new GlImageOffset(0, 0), new Dimension((int)this.getWidth(), (int)this.getHeight()), internalformat, null));
        }
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Internal Format", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getInternalFormat().toString())));
        properties.put("Width", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getWidth())));
        properties.put("Height", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getHeight())));
        if (this.hasDepthComponent()) {
            properties.put("Depth", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getDepth())));
        }
        if (this.hasSamplesComponent()) {
            properties.put("Samples", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getSamples())));
        }
        return properties;
    }

    @Override
    public IImageProvider getImageForm() {
        return this.getGlTextureCompositor();
    }
}

