/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.EglImageAsset;
import com.arm.mgd.core.asset.GlImageOffset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.asset.IGlFramebufferAttachment;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.IAssetItemWithParent;
import com.arm.mgd.core.asset.objects.OneShotPropertyFailureException;
import com.arm.mgd.core.asset.objects.gen.AbstractGlTextureAsset;
import com.arm.mgd.core.asset.processors.AssetProcessorBase;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.asset.texture.GlTextureCompositor;
import com.arm.mgd.core.asset.texture.IGlTextureLayerData;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.core.util.TextureAssetUtils;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlTextureAsset
extends AbstractGlTextureAsset
implements IGlFramebufferAttachment {
    private static final long serialVersionUID = 3351865141642356300L;
    private final @NonNull Map<@NonNull Long, Set<@NonNull AbstractConstantOrAliasSpecExtended>> framebufferAttachments = new HashMap<Long, Set<AbstractConstantOrAliasSpecExtended>>();
    private final Map<@NonNull Long, GlTextureSurfaceAsset> textureSurfaces = new TreeMap<Long, GlTextureSurfaceAsset>();
    private @Nullable Integer baseIndex;

    public static @NonNull GlTextureAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlTextureAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId());
    }

    private static void addTextureLayerToSurfaceLevel(@NonNull FunctionCall lastModification, int level, @NonNull GlImageOffset glImageOffset, @NonNull Dimension size, @NonNull AbstractConstantOrAliasSpecExtended internalFormat, @Nullable AbstractConstantOrAliasSpecExtended type, @Nullable IGlTextureLayerData textureData, boolean replaceExisting, @Nullable GlTextureSurfaceAsset surfaceAsset) {
        if (surfaceAsset == null) {
            return;
        }
        GlTextureImageAsset imageAsset = surfaceAsset.getOrCreateTextureLevel(lastModification, level, false);
        imageAsset.addTextureLayerToLevel(lastModification, glImageOffset, textureData, size, internalFormat, type, replaceExisting);
    }

    public GlTextureAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id);
    }

    public GlTextureAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
    }

    @Override
    public void addBoundTo(@NonNull Long framebufferId, @NonNull AbstractConstantOrAliasSpecExtended attachmentSpec, @NonNull FunctionCall functionCall) {
        this.setPreviousModificationFunction(functionCall);
        Set<@NonNull AbstractConstantOrAliasSpecExtended> attachment = this.framebufferAttachments.get(framebufferId);
        if (attachment == null) {
            attachment = new HashSet<AbstractConstantOrAliasSpecExtended>();
            attachment.add(attachmentSpec);
            this.framebufferAttachments.put(framebufferId, attachment);
            this.setEverBoundToFramebuffer(true);
        } else {
            attachment.add(attachmentSpec);
        }
        this.addBoundFramebuffersCommentToNotes();
    }

    private void addBoundFramebuffersCommentToNotes() {
        @NonNull Map<@NonNull Long, Set<AbstractConstantOrAliasSpecExtended>> framebuffersAttachedTo = this.getFramebuffersAttachedTo();
        if (framebuffersAttachedTo.isEmpty()) {
            return;
        }
        @NonNull StringJoiner fbStringJoiner = new StringJoiner(", ");
        for (Map.Entry<Long, Set<AbstractConstantOrAliasSpecExtended>> entry : framebuffersAttachedTo.entrySet()) {
            @NonNull StringJoiner fbAttachmentStringJoiner = new StringJoiner(", ");
            for (AbstractConstantOrAliasSpecExtended attachment : entry.getValue()) {
                fbAttachmentStringJoiner.add(String.valueOf(attachment));
            }
            fbStringJoiner.add("Framebuffer " + String.valueOf(entry.getKey()) + " (" + fbAttachmentStringJoiner.toString() + ")");
        }
        this.setNote("Texture bound to " + fbStringJoiner.toString());
    }

    @Override
    public void addChildAssetForMidstreamTrace(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall functionCall, @NonNull IAssetItemWithParent<GlTextureAsset> childAsset) {
        assert (childAsset instanceof GlTextureSurfaceAsset);
        GlTextureSurfaceAsset surfaceAsset = (GlTextureSurfaceAsset)childAsset;
        this.textureSurfaces.put(surfaceAsset.getId(), surfaceAsset);
        if (TextureAssetUtils.isTargetUsingDepthAsArrayIndex((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)this.getTextureTarget()))) {
            int localArrayIndex = TextureAssetUtils.getDepthFromSurfaceId((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)this.getTextureTarget()), surfaceAsset.getId());
            if (this.baseIndex == null || Integer.valueOf(localArrayIndex).compareTo(this.baseIndex) < 0) {
                this.baseIndex = localArrayIndex;
            }
        }
    }

    public void addTextureLayerToLevel(@NonNull FunctionCall lastModification, @NonNull AbstractConstantOrAliasSpecExtended target, @Nullable Integer arrayIndex, int level, @NonNull GlImageOffset glImageOffset, @NonNull Dimension size, @NonNull AbstractConstantOrAliasSpecExtended internalFormat, @Nullable AbstractConstantOrAliasSpecExtended type, @Nullable IGlTextureLayerData textureData, boolean replaceExisting) {
        this.setPreviousModificationFunction(lastModification);
        if (TextureAssetUtils.CUBE_MAP_FACE_TARGETS.contains(target)) {
            if ((long)level == this.getBaseLevel()) {
                GlTextureAsset.addTextureLayerToSurfaceLevel(lastModification, level, glImageOffset, size, internalFormat, type, textureData, replaceExisting, this.getOrCreateTextureSurfaceById(lastModification, -1L));
            }
            glImageOffset = new GlImageOffset(glImageOffset.originalX, glImageOffset.originalY);
        }
        GlTextureAsset.addTextureLayerToSurfaceLevel(lastModification, level, glImageOffset, size, internalFormat, type, textureData, replaceExisting, this.getOrCreateTextureSurface(lastModification, target, arrayIndex));
    }

    @Override
    public final @NonNull Map<@NonNull Long, Set<@NonNull AbstractConstantOrAliasSpecExtended>> getFramebuffersAttachedTo() {
        return Collections.unmodifiableMap(this.framebufferAttachments);
    }

    public @Nullable GlTextureCompositor getGlTextureCompositor() {
        return this.getGlTextureCompositor(0);
    }

    public @Nullable GlTextureCompositor getGlTextureCompositor(int level) {
        GlTextureImageAsset image = this.getTextureMipmapImage(level);
        return image != null ? image.getGlTextureCompositor() : null;
    }

    @Override
    public String getLabelText() {
        return "Texture " + this.getId();
    }

    public @Nullable GlTextureSurfaceAsset getOrCreateTextureSurface(@NonNull FunctionCall functionCall, @NonNull AbstractConstantOrAliasSpecExtended target, @Nullable Integer arrayIndex) {
        Long surfaceId = TextureAssetUtils.mapTargetAndDepthToSurfaceId(target, arrayIndex);
        if (surfaceId == null) {
            return null;
        }
        if (arrayIndex != null && (this.baseIndex == null || arrayIndex.compareTo(this.baseIndex) < 0)) {
            this.baseIndex = arrayIndex;
        }
        return this.getOrCreateTextureSurfaceById(functionCall, surfaceId);
    }

    public @NonNull GlTextureSurfaceAsset getOrCreateTextureSurfaceById(@NonNull FunctionCall functionCall, long surfaceId) {
        GlTextureSurfaceAsset result = this.textureSurfaces.get(surfaceId);
        if (result == null) {
            result = new GlTextureSurfaceAsset(functionCall, this, surfaceId);
            this.textureSurfaces.put(result.getId(), result);
        }
        return result;
    }

    public @NonNull List<@NonNull GlTextureSurfaceAsset> getSurfaces() {
        @NonNull Collection<@NonNull GlTextureSurfaceAsset> surfaces = this.textureSurfaces.values();
        return new ArrayList<GlTextureSurfaceAsset>(surfaces);
    }

    public @Nullable GlTextureImageAsset getTextureMipmapImage(@NonNull AbstractConstantOrAliasSpecExtended target, @Nullable Integer arrayIndex, int mipmapLevel) {
        Long surfaceId = TextureAssetUtils.mapTargetAndDepthToSurfaceId(target, arrayIndex);
        if (surfaceId == null) {
            return null;
        }
        GlTextureSurfaceAsset surface = this.textureSurfaces.get(surfaceId);
        if (surface == null) {
            return null;
        }
        return surface.getTextureLevel(mipmapLevel);
    }

    public @Nullable GlTextureImageAsset getTextureMipmapImage() {
        return this.getTextureMipmapImage((int)this.getBaseLevel());
    }

    private @Nullable GlTextureImageAsset getTextureMipmapImage(int mipmapLevel) {
        AbstractConstantOrAliasSpecExtended target = this.getTextureTarget();
        if (target == null) {
            return null;
        }
        if (target.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP)) {
            GlTextureSurfaceAsset surface = this.textureSurfaces.get(-1L);
            if (surface == null) {
                return null;
            }
            return (long)mipmapLevel == this.getBaseLevel() ? surface.getTextureLevel(mipmapLevel) : null;
        }
        if (TextureAssetUtils.isTargetUsingDepthAsArrayIndex(target) && this.baseIndex == null) {
            return null;
        }
        @Nullable Long surfaceId = TextureAssetUtils.mapTargetAndDepthToSurfaceId(target, this.baseIndex);
        if (surfaceId == null) {
            return null;
        }
        GlTextureSurfaceAsset surface = this.textureSurfaces.get(surfaceId);
        if (surface == null) {
            return null;
        }
        return surface.getTextureLevel(mipmapLevel);
    }

    public boolean hasMipmapLevel(@NonNull AbstractConstantOrAliasSpecExtended target, @Nullable Integer arrayIndex, int level) {
        Long surfaceId = TextureAssetUtils.mapTargetAndDepthToSurfaceId(target, arrayIndex);
        if (surfaceId == null) {
            return false;
        }
        GlTextureSurfaceAsset surface = this.textureSurfaces.get(surfaceId);
        if (surface == null) {
            return false;
        }
        GlTextureImageAsset image = surface.getTextureLevel(level);
        return image != null;
    }

    @Override
    public void removeBoundTo(@NonNull Long framebufferId, @NonNull AbstractConstantOrAliasSpecExtended attachmentSpec, @NonNull FunctionCall functionCall) {
        this.setPreviousModificationFunction(functionCall);
        Set<AbstractConstantOrAliasSpecExtended> attachment = this.framebufferAttachments.get(framebufferId);
        if (attachment != null) {
            attachment.remove(attachmentSpec);
            if (attachment.isEmpty()) {
                this.framebufferAttachments.remove(framebufferId);
            }
        }
    }

    public void setBorderColor(float[] borderColor) {
        int i = 0;
        while (i < 4) {
            this.setBorderColor(i, borderColor != null && i < borderColor.length ? borderColor[i] : 0.0f);
            ++i;
        }
    }

    @Override
    protected boolean handleOneShotPropertyTextureTargetSetFailure(AbstractConstantOrAliasSpecExtended currentValue, AbstractConstantOrAliasSpecExtended newValue) throws OneShotPropertyFailureException {
        if (this.getId().equals(0L)) {
            return true;
        }
        throw new OneShotPropertyFailureException(this, "A texture cannot be rebound to a different target once it has been bound", "Trying to change texture target from " + currentValue + " to " + newValue);
    }

    @Override
    public void doMidstreamTraceUpdatePostProcessing(@NonNull FunctionCall functionCall) {
        this.framebufferAttachments.clear();
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        AbstractConstantOrAliasSpecExtended textureTarget = this.getTextureTarget();
        properties.put("Target", textureTarget != null ? ValueAssetProperty.create((String)NullUtils.neverNull((Object)textureTarget.getName())) : ValueAssetProperty.NONE);
        AssetPropertyContainer parameters = new AssetPropertyContainer();
        String borderColorString = String.format("%.2f, %.2f, %.2f, %.2f", Float.valueOf(this.getBorderColor(0)), Float.valueOf(this.getBorderColor(1)), Float.valueOf(this.getBorderColor(2)), Float.valueOf(this.getBorderColor(3)));
        parameters.put("GL_DEPTH_STENCIL_TEXTURE_MODE", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getDepthStencilTextureMode().getName())));
        parameters.put("GL_TEXTURE_BASE_LEVEL", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getBaseLevel())));
        parameters.put("GL_TEXTURE_BORDER_COLOR", ValueAssetProperty.create((String)NullUtils.neverNull((Object)borderColorString)));
        parameters.put("GL_TEXTURE_COMPARE_MODE", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getCompareMode().getName())));
        parameters.put("GL_TEXTURE_COMPARE_FUNC", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getCompareFunc().getName())));
        parameters.put("GL_TEXTURE_MAG_FILTER", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getMagFilter().getName())));
        parameters.put("GL_TEXTURE_MAX_LEVEL", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getMaxLevel())));
        parameters.put("GL_TEXTURE_MAX_LOD", ValueAssetProperty.create(NullUtils.stringValueOf((float)this.getMaxLod())));
        parameters.put("GL_TEXTURE_MIN_FILTER", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getMinFilter().getName())));
        parameters.put("GL_TEXTURE_MIN_LOD", ValueAssetProperty.create(NullUtils.stringValueOf((float)this.getMinLod())));
        parameters.put("GL_TEXTURE_SWIZZLE_R", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getSwizzleR().getName())));
        parameters.put("GL_TEXTURE_SWIZZLE_G", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getSwizzleG().getName())));
        parameters.put("GL_TEXTURE_SWIZZLE_B", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getSwizzleB().getName())));
        parameters.put("GL_TEXTURE_SWIZZLE_A", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getSwizzleA().getName())));
        parameters.put("GL_TEXTURE_WRAP_S", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getWrapS().getName())));
        parameters.put("GL_TEXTURE_WRAP_T", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getWrapT().getName())));
        parameters.put("GL_TEXTURE_WRAP_R", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getWrapR().getName())));
        properties.put("Parameters", parameters);
        @Nullable EglImageAsset eglImageAsset = this.getEglImageAsset();
        if (eglImageAsset != null) {
            properties.put("EGL Image", eglImageAsset);
        }
        if (!this.getId().equals(0L) && textureTarget != null) {
            properties.put("Immutable Format", ValueAssetProperty.fromBoolean(this.isImmutableFormat()));
            if (textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D) || textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_3D) || textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE) || textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_EXTERNAL_OES) || textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_BUFFER)) {
                Long surfaceID = TextureAssetUtils.mapTargetAndDepthToSurfaceId(textureTarget, null);
                assert (surfaceID != null);
                GlTextureSurfaceAsset surface = this.textureSurfaces.get(surfaceID);
                properties.put("Texture", surface != null ? surface : ValueAssetProperty.NONE);
            } else if (textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP)) {
                AssetPropertyContainer faces = new AssetPropertyContainer();
                BiConsumer<@NonNull AbstractConstantOrAliasSpecExtended, @NonNull String> addFace = (target, name) -> {
                    Long surfaceID = TextureAssetUtils.mapTargetAndDepthToSurfaceId(target, null);
                    assert (surfaceID != null);
                    GlTextureSurfaceAsset surface = this.textureSurfaces.get(surfaceID);
                    faces.put((String)name, surface != null ? surface : ValueAssetProperty.NONE);
                };
                addFace.accept(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_X, "POSITIVE_X");
                addFace.accept(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_X, "NEGATIVE_X");
                addFace.accept(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Y, "POSITIVE_Y");
                addFace.accept(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y, "NEGATIVE_Y");
                addFace.accept(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Z, "POSITIVE_Z");
                addFace.accept(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z, "NEGATIVE_Z");
                properties.put("Cube Map Faces", faces);
            } else if (textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_ARRAY) || textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_2D_MULTISAMPLE_ARRAY)) {
                if (this.baseIndex != null) {
                    int index = this.baseIndex;
                    AssetPropertyContainer layers = new AssetPropertyContainer();
                    while (true) {
                        Long surfaceID = TextureAssetUtils.mapTargetAndDepthToSurfaceId(textureTarget, index);
                        assert (surfaceID != null);
                        GlTextureSurfaceAsset surface = this.textureSurfaces.get(surfaceID);
                        if (surface == null) break;
                        layers.put("Layer " + index, surface);
                        ++index;
                    }
                    properties.put("Layers", layers);
                }
            } else if (textureTarget.equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_ARRAY) && this.baseIndex != null) {
                int index = this.baseIndex;
                AssetPropertyContainer layers = new AssetPropertyContainer();
                int layerCount = index;
                int faceIndex = 0;
                AssetPropertyContainer faces = null;
                while (true) {
                    Long surfaceID = TextureAssetUtils.mapTargetAndDepthToSurfaceId(textureTarget, index);
                    assert (surfaceID != null);
                    GlTextureSurfaceAsset surface = this.textureSurfaces.get(surfaceID);
                    if (surface == null) break;
                    if (faces == null) {
                        assert (faceIndex == 0);
                        faces = new AssetPropertyContainer();
                    }
                    String faceName = null;
                    switch (faceIndex) {
                        case 0: {
                            faceName = "CUBEMAP_POSITIVE_X_ID";
                            break;
                        }
                        case 1: {
                            faceName = "CUBEMAP_NEGATIVE_X_ID";
                            break;
                        }
                        case 2: {
                            faceName = "CUBEMAP_POSITIVE_Y_ID";
                            break;
                        }
                        case 3: {
                            faceName = "CUBEMAP_NEGATIVE_Y_ID";
                            break;
                        }
                        case 4: {
                            faceName = "CUBEMAP_POSITIVE_Z_ID";
                            break;
                        }
                        case 5: {
                            faceName = "CUBEMAP_NEGATIVE_Z_ID";
                            break;
                        }
                        default: {
                            assert (false);
                            break;
                        }
                    }
                    assert (faceName != null);
                    faces.put(faceName, surface);
                    if (++faceIndex == 6) {
                        faceIndex = 0;
                        layers.put("Layer " + layerCount, faces);
                        ++layerCount;
                        faces = null;
                    }
                    ++index;
                }
                properties.put("Layers", layers);
            }
        }
        return properties;
    }

    @Override
    public IImageProvider getImageForm() {
        GlTextureImageAsset textureMipmapImage = this.getTextureMipmapImage();
        if (textureMipmapImage != null) {
            return textureMipmapImage.getGlTextureCompositor();
        }
        return null;
    }

    private @Nullable EglImageAsset getEglImageAsset() {
        @Nullable Pointer eglImagePointer = this.getEglImage();
        if (eglImagePointer == null) {
            return null;
        }
        long id = AssetProcessorBase.asAssetID(eglImagePointer.address());
        @NonNull TraceStateSnapshot currentState = this.getSnapshotAssetParent().getTraceStateSnapshot();
        AssetTable assetTableBySpec = currentState.getAssetTableBySpec(KapiSpec.EGL.assetTables.EGLIMAGE_TRAITS.SPEC);
        assert (assetTableBySpec != null);
        return (EglImageAsset)assetTableBySpec.get((Long)id);
    }
}

