/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AssetTable;
import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlShaderHelper {
    public static @NonNull List<@NonNull GlShaderAsset> getAllLinkedShaders(@NonNull TraceStateSnapshot snapshot, @NonNull AbstractConstantOrAliasSpecExtended targetShaderType) {
        return GlShaderHelper.getShaders(snapshot, targetShaderType, false);
    }

    public static @NonNull List<@NonNull GlShaderAsset> getAllLivingShaders(@NonNull TraceStateSnapshot snapshot) {
        return GlShaderHelper.getShaders(snapshot, null, true);
    }

    public static boolean snapshotHasShaders(@NonNull TraceStateSnapshot snapshot) {
        return !snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC).isEmpty();
    }

    private static @NonNull List<@NonNull GlShaderAsset> getShaders(@NonNull TraceStateSnapshot snapshot, @Nullable AbstractConstantOrAliasSpecExtended targetShaderType, boolean includeUnlinked) {
        ArrayList<@NonNull GlShaderAsset> shaderList = new ArrayList<GlShaderAsset>();
        AssetTable allShaders = snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.SHADER_TRAITS.SPEC);
        for (IAssetItem asset : allShaders) {
            GlShaderAsset shader = (GlShaderAsset)asset;
            if (targetShaderType != null && !targetShaderType.equals(shader.getType())) continue;
            @NonNull List<@NonNull GlProgramAsset> linkedProgramList = shader.getLinkedToProgramList();
            if (!includeUnlinked && linkedProgramList.isEmpty()) continue;
            shaderList.add(shader);
        }
        HashSet<@NonNull GlShaderAsset> deletedShaders = new HashSet<GlShaderAsset>();
        AssetTable allPrograms = snapshot.getAssetTableBySpec(KapiSpec.GLES.assetTables.PROGRAM_TRAITS.SPEC);
        for (IAssetItem asset : allPrograms) {
            GlShaderAsset shader2;
            if (targetShaderType == null) {
                for (GlShaderAsset shader2 : ((GlProgramAsset)asset).getLinkedShaders()) {
                    if (!shader2.isDeleted()) continue;
                    deletedShaders.add(shader2);
                }
                continue;
            }
            shader2 = ((GlProgramAsset)asset).getLinkedShader(targetShaderType);
            if (shader2 == null || !shader2.isDeleted()) continue;
            deletedShaders.add(shader2);
        }
        for (GlShaderAsset deletedShader : deletedShaders) {
            shaderList.add(deletedShader);
        }
        return shaderList;
    }
}

