/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.SourceAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractGlShaderAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ListAssetProperty;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.offlinecompiler.GlShaderCompiler;
import com.arm.mgd.core.offlinecompiler.GlShaderStats;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlShaderAsset
extends AbstractGlShaderAsset {
    private static final long serialVersionUID = -8527407245177045172L;
    private long currentFrameShaderInvocations = 0L;
    private BufferArgAttachment binaryData;
    private @NonNull List<@NonNull GlProgramAsset> attachedToProgramList = new ArrayList<GlProgramAsset>();
    private @NonNull List<@NonNull GlProgramAsset> linkedToProgramList = new ArrayList<GlProgramAsset>();

    public static @NonNull GlShaderAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull AbstractConstantOrAliasSpecExtended type) {
        return new GlShaderAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId(), type);
    }

    public GlShaderAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id, @NonNull AbstractConstantOrAliasSpecExtended type) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, type);
    }

    public GlShaderAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id, @NonNull AbstractConstantOrAliasSpecExtended type) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id, type);
        assert (KapiSpec.GLES.constantGroups.SHADERTYPE.contains(type));
    }

    @Override
    public String toString() {
        return "GlShaderAsset " + this.getId();
    }

    @Override
    public String getLabelText() {
        return "Shader " + this.getId();
    }

    public @NonNull CompletableFuture<@NonNull GlShaderStats> getShaderStats(@NonNull GlShaderCompiler shaderCompiler) {
        return this.getCreatedByFunction().getModel().getGlShaderStats(this, shaderCompiler);
    }

    @Override
    public boolean isAssetActive() {
        TraceStateSnapshot state = this.getSnapshotAssetParent().getTraceStateSnapshot();
        @NonNull Collection<GlProgramAsset> currentProgramAssets = GlProgramHelper.getCurrentProgramAssets(state);
        for (GlProgramAsset program : currentProgramAssets) {
            if (!program.containsShader(this)) continue;
            return true;
        }
        return false;
    }

    public long getCurrentFrameShaderInvocations() {
        return this.currentFrameShaderInvocations;
    }

    public void incrementCurrentFrameShaderInvocations(long increment) {
        assert (increment >= 0L);
        this.currentFrameShaderInvocations += increment;
    }

    public void resetCurrentFrameShaderInvocations() {
        this.currentFrameShaderInvocations = 0L;
    }

    public void setBinary(@NonNull FunctionCall functionCall, AbstractConstantOrAliasSpecExtended binaryFormat, BufferArgAttachment binaryData) {
        this.setPreviousModificationFunction(functionCall);
        this.setBinaryFormat(binaryFormat);
        this.binaryData = binaryData;
    }

    public @Nullable BufferArgAttachment getBinaryData() {
        return this.binaryData;
    }

    public void attachToProgram(@NonNull GlProgramAsset program) {
        this.attachedToProgramList.add(program);
    }

    public void detachFromProgram(GlProgramAsset program) {
        if (this.attachedToProgramList.contains(program)) {
            this.attachedToProgramList.remove(program);
        }
    }

    public void addLinkedToProgram(@NonNull GlProgramAsset program) {
        this.linkedToProgramList.add(program);
    }

    public void removeLinkedToProgram(GlProgramAsset unlinkedProgram) {
        if (this.linkedToProgramList.contains(unlinkedProgram)) {
            this.linkedToProgramList.remove(unlinkedProgram);
        }
    }

    public boolean isLinked() {
        return !this.linkedToProgramList.isEmpty();
    }

    public boolean isAttached() {
        return !this.attachedToProgramList.isEmpty();
    }

    public @NonNull List<@NonNull GlProgramAsset> getAttachedToProgramList() {
        return this.attachedToProgramList;
    }

    public @NonNull List<@NonNull GlProgramAsset> getLinkedToProgramList() {
        return this.linkedToProgramList;
    }

    public boolean shouldBeDeleted() {
        return !this.isAttached() && this.isFlaggedForDeletion();
    }

    @Override
    public String setShaderSource(@NonNull String shaderSource) {
        this.sourceProvider = new SourceAsset.StringSourceProvider(shaderSource);
        return super.setShaderSource(shaderSource);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Type", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getType().toString())));
        properties.put("Linked Programs", new ListAssetProperty(this.linkedToProgramList));
        properties.put("Attached Programs", new ListAssetProperty(this.attachedToProgramList));
        properties.put("Flagged for Deletion", ValueAssetProperty.fromBoolean(this.isFlaggedForDeletion()));
        properties.put("Deleted", ValueAssetProperty.fromBoolean(this.isDeleted()));
        return properties;
    }

    @Override
    public @NonNull String getTextForm() {
        String source = this.getSource();
        if (source != null) {
            return source;
        }
        return "";
    }
}

