/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlSamplerAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public class GlSamplerAsset
extends AbstractGlSamplerAsset {
    private static final long serialVersionUID = 1L;

    public static @NonNull GlSamplerAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlSamplerAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId());
    }

    public GlSamplerAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id) {
        super(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id);
    }

    public GlSamplerAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
    }

    @Override
    public @NonNull String getLabelText() {
        return String.format("Sampler %s", this.getId());
    }

    public void setBorderColor(float[] borderColor) {
        int i = 0;
        while (i < 4) {
            this.setBorderColor(i, borderColor != null && i < borderColor.length ? borderColor[i] : 0.0f);
            ++i;
        }
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        String borderColorString = String.format("%.2f, %.2f, %.2f, %.2f", Float.valueOf(this.getBorderColor(0)), Float.valueOf(this.getBorderColor(1)), Float.valueOf(this.getBorderColor(2)), Float.valueOf(this.getBorderColor(3)));
        properties.put("GL_TEXTURE_BORDER_COLOR", ValueAssetProperty.create((String)NullUtils.neverNull((Object)borderColorString)));
        properties.put("GL_TEXTURE_COMPARE_FUNC", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getCompareFunc().toString())));
        properties.put("GL_TEXTURE_COMPARE_MODE", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getCompareMode().toString())));
        properties.put("GL_TEXTURE_MAG_FILTER", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getMagFilter().toString())));
        properties.put("GL_TEXTURE_MAX_LOD", ValueAssetProperty.create(NullUtils.stringValueOf((float)this.getMaxLod())));
        properties.put("GL_TEXTURE_MIN_FILTER", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getMinFilter().toString())));
        properties.put("GL_TEXTURE_MIN_LOD", ValueAssetProperty.create(NullUtils.stringValueOf((float)this.getMinLod())));
        properties.put("GL_TEXTURE_WRAP_R", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getWrapR().toString())));
        properties.put("GL_TEXTURE_WRAP_S", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getWrapS().toString())));
        properties.put("GL_TEXTURE_WRAP_T", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getWrapT().toString())));
        return properties;
    }
}

