/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.IGlFramebufferAttachment;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlRenderbufferAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;

public class GlRenderbufferAsset
extends AbstractGlRenderbufferAsset
implements IGlFramebufferAttachment {
    private static final long serialVersionUID = 1251788909167289469L;
    private final @NonNull Map<Long, Set<AbstractConstantOrAliasSpecExtended>> framebufferAttachments = new HashMap<Long, Set<AbstractConstantOrAliasSpecExtended>>();

    public static @NonNull GlRenderbufferAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlRenderbufferAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId());
    }

    public GlRenderbufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id);
    }

    public GlRenderbufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
    }

    @Override
    public String getLabelText() {
        return (String)NullUtils.neverNull((Object)String.format("Renderbuffer %s", this.getId()));
    }

    @Override
    public void addBoundTo(@NonNull Long framebufferId, @NonNull AbstractConstantOrAliasSpecExtended attachmentSpec, @NonNull FunctionCall functionCall) {
        this.setPreviousModificationFunction(functionCall);
        Set<AbstractConstantOrAliasSpecExtended> attachment = this.framebufferAttachments.get(framebufferId);
        if (attachment == null) {
            attachment = new HashSet<AbstractConstantOrAliasSpecExtended>();
            attachment.add(attachmentSpec);
            this.framebufferAttachments.put(framebufferId, attachment);
        } else {
            attachment.add(attachmentSpec);
        }
    }

    @Override
    public void removeBoundTo(@NonNull Long framebufferId, @NonNull AbstractConstantOrAliasSpecExtended attachmentSpec, @NonNull FunctionCall functionCall) {
        this.setPreviousModificationFunction(functionCall);
        Set<AbstractConstantOrAliasSpecExtended> attachment = this.framebufferAttachments.get(framebufferId);
        if (attachment != null) {
            attachment.remove(attachmentSpec);
            if (attachment.isEmpty()) {
                this.framebufferAttachments.remove(framebufferId);
            }
        }
    }

    @Override
    public final Map<@NonNull Long, Set<AbstractConstantOrAliasSpecExtended>> getFramebuffersAttachedTo() {
        return Collections.unmodifiableMap(this.framebufferAttachments);
    }

    @Override
    public void doMidstreamTraceUpdatePostProcessing(@NonNull FunctionCall functionCall) {
        this.framebufferAttachments.clear();
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Internal format", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getInternalFormat().getName())));
        properties.put("Width", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getWidth())));
        properties.put("Height", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getHeight())));
        properties.put("Samples", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getSamples())));
        return properties;
    }
}

