/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlProgramPipelineAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlProgramPipelineAsset
extends AbstractGlProgramPipelineAsset {
    private static final long serialVersionUID = -6245850620505655610L;

    public GlProgramPipelineAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
    }

    public GlProgramPipelineAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id);
    }

    @Override
    public @NonNull String getLabelText() {
        return "Program Pipeline Object " + this.getId();
    }

    @Override
    public boolean isAssetActive() {
        TraceStateSnapshot state = this.getSnapshotAssetParent().getTraceStateSnapshot();
        return this.getId().equals(state.getStateItemBySpec((StateSpec)KapiSpec.GLES.states.GL_PROGRAM_PIPELINE_BINDING).getValue()[0].value);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        GlProgramAsset computeShaderProgram;
        GlProgramAsset geometryShaderProgram;
        GlProgramAsset fragmentShaderProgram;
        GlProgramAsset tessEvaluationShader;
        GlProgramAsset tessControlShaderProgram;
        GlProgramAsset vertexShaderProgram;
        AssetPropertyContainer properties = new AssetPropertyContainer();
        GlProgramAsset activeProgram = this.getActiveProgram();
        if (activeProgram != null) {
            properties.put("Active Program", activeProgram);
        }
        if ((vertexShaderProgram = this.getVertexShader()) != null) {
            properties.put("Vertex Shader Program", vertexShaderProgram);
        }
        if ((tessControlShaderProgram = this.getTessControlShader()) != null) {
            properties.put("Tessellation Control Shader Program", tessControlShaderProgram);
        }
        if ((tessEvaluationShader = this.getTessEvaluationShader()) != null) {
            properties.put("Tessellation Evaluation Shader Program", tessEvaluationShader);
        }
        if ((fragmentShaderProgram = this.getFragmentShader()) != null) {
            properties.put("Fragment Shader Program", fragmentShaderProgram);
        }
        if ((geometryShaderProgram = this.getGeometryShader()) != null) {
            properties.put("Geometry Shader Program", geometryShaderProgram);
        }
        if ((computeShaderProgram = this.getComputeShader()) != null) {
            properties.put("Compute Shader Program", computeShaderProgram);
        }
        return properties;
    }

    @Override
    public boolean hasProperties() {
        return this.getActiveProgram() != null || this.getVertexShader() != null || this.getTessControlShader() != null || this.getTessEvaluationShader() != null || this.getFragmentShader() != null || this.getComputeShader() != null;
    }

    public static GlProgramPipelineAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlProgramPipelineAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId());
    }

    public @Nullable GlProgramAsset getProgram(@NonNull AbstractConstantOrAliasSpecExtended pipelineStage) {
        if (pipelineStage.equals(KapiSpec.GLES.constants.GL_ACTIVE_PROGRAM)) {
            return this.getActiveProgram();
        }
        if (pipelineStage.equals(KapiSpec.GLES.constants.GL_VERTEX_SHADER)) {
            return this.getVertexShader();
        }
        if (pipelineStage.equals(KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER)) {
            return this.getTessControlShader();
        }
        if (pipelineStage.equals(KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER)) {
            return this.getTessEvaluationShader();
        }
        if (pipelineStage.equals(KapiSpec.GLES.constants.GL_GEOMETRY_SHADER)) {
            return this.getGeometryShader();
        }
        if (pipelineStage.equals(KapiSpec.GLES.constants.GL_FRAGMENT_SHADER)) {
            return this.getFragmentShader();
        }
        if (pipelineStage.equals(KapiSpec.GLES.constants.GL_COMPUTE_SHADER)) {
            return this.getComputeShader();
        }
        assert (false) : "Unknown shader program type: " + pipelineStage;
        return null;
    }

    public Collection<@NonNull GlProgramAsset> getPrograms() {
        GlProgramAsset geometryShaderProgram;
        GlProgramAsset computeShaderProgram;
        GlProgramAsset fragmentShaderProgram;
        GlProgramAsset tessEvaluationShader;
        GlProgramAsset tessControlShaderProgram;
        HashSet<@NonNull GlProgramAsset> programs = new HashSet<GlProgramAsset>();
        GlProgramAsset vertexShaderProgram = this.getVertexShader();
        if (vertexShaderProgram != null) {
            programs.add(vertexShaderProgram);
        }
        if ((tessControlShaderProgram = this.getTessControlShader()) != null) {
            programs.add(tessControlShaderProgram);
        }
        if ((tessEvaluationShader = this.getTessEvaluationShader()) != null) {
            programs.add(tessEvaluationShader);
        }
        if ((fragmentShaderProgram = this.getFragmentShader()) != null) {
            programs.add(fragmentShaderProgram);
        }
        if ((computeShaderProgram = this.getComputeShader()) != null) {
            programs.add(computeShaderProgram);
        }
        if ((geometryShaderProgram = this.getGeometryShader()) != null) {
            programs.add(geometryShaderProgram);
        }
        return programs;
    }
}

