/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlProgramAsset;
import com.arm.mgd.core.asset.GlProgramPipelineAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlProgramHelper {
    public static @Nullable GlProgramAsset getCurrentNormalProgramAsset(@NonNull TraceStateSnapshot state) {
        if (GlProgramHelper.isNormalProgramInUse(state)) {
            return GlProgramHelper.getCurrentNormalProgram(state);
        }
        return null;
    }

    public static GlProgramAsset getCurrentActiveProgram(@NonNull TraceStateSnapshot state) {
        return GlProgramHelper.getCurrentProgramAsset(state, KapiSpec.GLES.constants.GL_ACTIVE_PROGRAM);
    }

    public static @NonNull Collection<@NonNull GlProgramAsset> getCurrentProgramAssets(@NonNull TraceStateSnapshot state) {
        ArrayList<@NonNull GlProgramAsset> programs = new ArrayList<GlProgramAsset>();
        if (GlProgramHelper.isNormalProgramInUse(state)) {
            @Nullable GlProgramAsset currentNormalProgram = GlProgramHelper.getCurrentNormalProgram(state);
            if (currentNormalProgram != null) {
                programs.add(currentNormalProgram);
            }
        } else {
            GlProgramPipelineAsset currentProgramPipeline = GlProgramHelper.getCurrentProgramPipeline(state);
            if (currentProgramPipeline != null) {
                programs.addAll(currentProgramPipeline.getPrograms());
            }
        }
        return programs;
    }

    public static @Nullable GlProgramAsset getCurrentProgramAsset(@NonNull TraceStateSnapshot currentState, @NonNull AbstractConstantOrAliasSpecExtended pipelineStage) {
        if (GlProgramHelper.isNormalProgramInUse(currentState)) {
            return GlProgramHelper.getCurrentNormalProgram(currentState);
        }
        GlProgramPipelineAsset currentProgramPipeline = GlProgramHelper.getCurrentProgramPipeline(currentState);
        if (currentProgramPipeline != null) {
            return currentProgramPipeline.getProgram(pipelineStage);
        }
        return null;
    }

    private static boolean isNormalProgramInUse(@NonNull TraceStateSnapshot state) {
        StateItem currentProgramState = state.getStateItemBySpec(KapiSpec.GLES.states.GL_CURRENT_PROGRAM);
        return currentProgramState.getValue()[0].getValueAsLong() != 0L;
    }

    private static @Nullable GlProgramAsset getCurrentNormalProgram(@NonNull TraceStateSnapshot state) {
        StateItem currentProgramState = state.getStateItemBySpec(KapiSpec.GLES.states.GL_CURRENT_PROGRAM);
        return (GlProgramAsset)currentProgramState.getValueAsAsset();
    }

    private static @Nullable GlProgramPipelineAsset getCurrentProgramPipeline(@NonNull TraceStateSnapshot state) {
        StateItem currentProgramPipelineState = state.getStateItemBySpec(KapiSpec.GLES.states.GL_PROGRAM_PIPELINE_BINDING);
        return (GlProgramPipelineAsset)currentProgramPipelineState.getValueAsAsset();
    }
}

