/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.ComputeWorkgroupSize;
import com.arm.mgd.core.asset.GlProgramHelper;
import com.arm.mgd.core.asset.GlShaderAsset;
import com.arm.mgd.core.asset.GlUniformBindingPointAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.IAssetItemWithParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlProgramAsset;
import com.arm.mgd.core.asset.programvariable.ShaderAttribute;
import com.arm.mgd.core.asset.programvariable.ShaderUniform;
import com.arm.mgd.core.asset.programvariable.ShaderUniformContainer;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.ApiUsageException;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.ProgramColour;
import com.arm.mgd.core.target.data.ProgramGeometryShaderProperties;
import com.arm.mgd.core.target.data.ProgramResourceDescriptor;
import com.arm.mgd.core.target.data.ProgramResourceDescriptorMap;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlProgramAsset
extends AbstractGlProgramAsset
implements Comparable<GlProgramAsset> {
    private static final long serialVersionUID = -6659668040340217943L;
    private final @NonNull Map<Long, Long> blockBindingsMapping = new HashMap<Long, Long>();
    private @NonNull ProgramColour color = new ProgramColour(0.0f, 0.0f, 0.0f, 0.0f);
    private ComputeWorkgroupSize computeLocalWorkGroupSize = null;
    private @NonNull ProgramResourceDescriptorMap programResourceDescriptor = new ProgramResourceDescriptorMap();
    private static final Comparator<AbstractConstantOrAliasSpecExtended> shaderComparator = new ShaderPipelineComparator();
    private final @NonNull Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset> attachedShaders = new TreeMap<AbstractConstantOrAliasSpecExtended, GlShaderAsset>(shaderComparator);
    private final @NonNull Map<AbstractConstantOrAliasSpecExtended, GlShaderAsset> linkedShaders = new TreeMap<AbstractConstantOrAliasSpecExtended, GlShaderAsset>(shaderComparator);
    private final @NonNull ShaderUniformContainer uniforms = new ShaderUniformContainer(this);
    private final @NonNull Map<Long, ShaderAttribute> vertexAttributes = new TreeMap<Long, ShaderAttribute>();
    private @Nullable ProgramGeometryShaderProperties geometryShaderProperties;

    public static @NonNull GlProgramAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlProgramAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId());
    }

    public GlProgramAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id);
    }

    public GlProgramAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
    }

    public void addAttribute(ShaderAttribute shaderAttribute) {
        assert (shaderAttribute != null);
        this.vertexAttributes.put(shaderAttribute.getId(), shaderAttribute);
    }

    public void addUniformBufferBlockUniforms(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall createdByFunction) {
        this.uniforms.resetContents(currentState, createdByFunction, this.programResourceDescriptor);
    }

    public void attachShader(@NonNull FunctionCall lastModification, @NonNull GlShaderAsset shaderAsset) throws ApiUsageException {
        assert (KapiSpec.GLES.constantGroups.SHADERTYPE.contains(shaderAsset.getType()));
        if (this.attachedShaders.containsKey(shaderAsset.getType())) {
            throw new ApiUsageException("A shader of this type (" + shaderAsset.getType() + ") is already attached to program " + this.getId() + ".");
        }
        shaderAsset.attachToProgram(this);
        this.attachedShaders.put(shaderAsset.getType(), shaderAsset);
        this.setPreviousModificationFunction(lastModification);
    }

    public boolean detachShaderById(@NonNull FunctionCall lastModification, Long shaderToLocateById) {
        assert (shaderToLocateById > 0L);
        for (Map.Entry<AbstractConstantOrAliasSpecExtended, GlShaderAsset> entry : this.attachedShaders.entrySet()) {
            if (!entry.getValue().getId().equals(shaderToLocateById)) continue;
            @NonNull GlShaderAsset shader = (GlShaderAsset)NullUtils.neverNull((Object)this.attachedShaders.remove(entry.getKey()));
            shader.detachFromProgram(this);
            this.setPreviousModificationFunction(lastModification);
            return true;
        }
        return false;
    }

    public void link() {
        for (GlShaderAsset shader : this.linkedShaders.values()) {
            shader.removeLinkedToProgram(this);
        }
        for (GlShaderAsset shader : this.attachedShaders.values()) {
            shader.addLinkedToProgram(this);
        }
        this.linkedShaders.clear();
        this.linkedShaders.putAll(this.attachedShaders);
    }

    public void delete() {
        for (GlShaderAsset shader : this.linkedShaders.values()) {
            shader.removeLinkedToProgram(this);
        }
        for (GlShaderAsset shader : this.attachedShaders.values()) {
            shader.removeLinkedToProgram(this);
        }
    }

    public void clearUniformsAndAttributes(@NonNull FunctionCall functionCall) {
        this.vertexAttributes.clear();
        this.uniforms.clear();
        this.programResourceDescriptor = new ProgramResourceDescriptorMap();
        this.computeLocalWorkGroupSize = null;
        this.setPreviousModificationFunction(functionCall);
        this.resetBlockBindings();
    }

    public boolean containsShader(GlShaderAsset shaderToLocate) {
        return this.linkedShaders.containsValue(shaderToLocate);
    }

    public ShaderAttribute getAttributeByLocation(Long attributeIndex) {
        return this.vertexAttributes.get(attributeIndex);
    }

    public List<ShaderAttribute> getAttributes() {
        return new ArrayList<ShaderAttribute>(this.vertexAttributes.values());
    }

    public @Nullable GlShaderAsset getLinkedShader(@NonNull AbstractConstantOrAliasSpecExtended shaderType) {
        assert (KapiSpec.GLES.constantGroups.SHADERTYPE.contains(shaderType));
        return this.linkedShaders.get(shaderType);
    }

    public @Nullable GlShaderAsset getAttachedShader(@NonNull AbstractConstantOrAliasSpecExtended shaderType) {
        assert (KapiSpec.GLES.constantGroups.SHADERTYPE.contains(shaderType));
        return this.attachedShaders.get(shaderType);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull GlShaderAsset> getLinkedShaders() {
        @NonNull @NonNull Collection shaders = NullUtils.neverNullCollection(this.linkedShaders.values());
        return new ArrayList<GlShaderAsset>(shaders);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull List<@NonNull GlShaderAsset> getAttachedShaders() {
        @NonNull @NonNull Collection shaders = NullUtils.neverNullCollection(this.attachedShaders.values());
        return new ArrayList<GlShaderAsset>(shaders);
    }

    public @NonNull ProgramColour getColor() {
        return this.color;
    }

    public void setComputeLocalWorkGroupSize(@NonNull ComputeWorkgroupSize size) {
        this.computeLocalWorkGroupSize = size;
    }

    public @Nullable ComputeWorkgroupSize getComputeLocalWorkGroupSize() {
        return this.computeLocalWorkGroupSize;
    }

    @Override
    public String getLabelText() {
        return "Program " + this.getId();
    }

    public @NonNull ProgramResourceDescriptorMap getProgramResourceDescriptor() {
        return this.programResourceDescriptor;
    }

    public @NonNull Map<Long, Long> getUniformBlockBindings() {
        return Collections.unmodifiableMap(this.blockBindingsMapping);
    }

    public @NonNull Set<ProgramResourceDescriptor> getUniformBlocksBoundTo(@NonNull GlUniformBindingPointAsset bindingPoint) {
        HashSet<ProgramResourceDescriptor> result = new HashSet<ProgramResourceDescriptor>();
        @NonNull Map<@NonNull Long, ProgramResourceDescriptor> blockMap = this.programResourceDescriptor.getResourcesMap(KapiSpec.GLES.constants.GL_UNIFORM_BLOCK);
        for (Map.Entry<Long, Long> mapping : this.blockBindingsMapping.entrySet()) {
            ProgramResourceDescriptor block;
            if (!mapping.getValue().equals(bindingPoint.getId()) || (block = blockMap.get(mapping.getKey())) == null) continue;
            result.add(block);
        }
        return result;
    }

    public @NonNull ShaderUniformContainer getUniformsContainer() {
        return this.uniforms;
    }

    @Override
    public boolean isAssetActive() {
        TraceStateSnapshot state = this.getSnapshotAssetParent().getTraceStateSnapshot();
        @NonNull Collection<@NonNull GlProgramAsset> currentProgramAsset = GlProgramHelper.getCurrentProgramAssets(state);
        return currentProgramAsset.contains(this);
    }

    public void setColor(@NonNull ProgramColour shaderColor) {
        this.color = shaderColor;
    }

    public void setProgramResourceDescriptor(@NonNull ProgramResourceDescriptorMap programResources) {
        this.programResourceDescriptor = programResources;
        this.resetBlockBindings();
    }

    public void setUniformBlockBinding(long blockIndex, GlUniformBindingPointAsset bindingPoint) {
        Long bIndex = blockIndex;
        ProgramResourceDescriptor blockDescriptor = this.programResourceDescriptor.getResourcesMap(KapiSpec.GLES.constants.GL_UNIFORM_BLOCK).get(bIndex);
        if (blockDescriptor == null) {
            return;
        }
        if (bindingPoint != null) {
            this.blockBindingsMapping.put(bIndex, bindingPoint.getId());
        } else {
            this.blockBindingsMapping.put(bIndex, 0L);
        }
    }

    @Override
    public String toString() {
        return "GlProgramAsset " + this.getId();
    }

    private void resetBlockBindings() {
        this.blockBindingsMapping.clear();
        for (ProgramResourceDescriptor uBlock : this.programResourceDescriptor.getResourcesMap(KapiSpec.GLES.constants.GL_UNIFORM_BLOCK).values()) {
            this.blockBindingsMapping.put(uBlock.getIndex(), Long.valueOf(uBlock.resolveBufferBinding()));
        }
    }

    public void setGeometryShaderProperties(@Nullable ProgramGeometryShaderProperties geometryShaderProperties) {
        this.geometryShaderProperties = geometryShaderProperties;
    }

    public @Nullable ProgramGeometryShaderProperties getGeometryShaderProperties() {
        return this.geometryShaderProperties;
    }

    public void setAttachedShadersCollection(@NonNull Map<?, GlShaderAsset> newShaders) {
        this.setAttachedShadersCollection(newShaders.values());
    }

    public void setAttachedShadersCollection(@NonNull Collection<GlShaderAsset> newShaders) {
        for (GlShaderAsset oldShader : this.attachedShaders.values()) {
            oldShader.detachFromProgram(this);
        }
        this.attachedShaders.clear();
        for (GlShaderAsset newShader : newShaders) {
            newShader.attachToProgram(this);
            this.attachedShaders.put(newShader.getType(), newShader);
        }
    }

    public void setLinkedShadersCollection(@NonNull Map<?, GlShaderAsset> newShaders) {
        this.setLinkedShadersCollection(newShaders.values());
    }

    public void setLinkedShadersCollection(@NonNull Collection<GlShaderAsset> newShaders) {
        for (GlShaderAsset oldShader : this.linkedShaders.values()) {
            oldShader.removeLinkedToProgram(this);
        }
        this.linkedShaders.clear();
        for (GlShaderAsset newShader : newShaders) {
            newShader.addLinkedToProgram(this);
            this.linkedShaders.put(newShader.getType(), newShader);
        }
    }

    @Override
    public void addChildAssetForMidstreamTrace(TraceStateSnapshot currentState, FunctionCall functionCall, IAssetItemWithParent<GlProgramAsset> childAsset) {
        assert (childAsset instanceof ShaderUniform);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        AssetPropertyContainer linkedShadersProperties = new AssetPropertyContainer();
        for (Map.Entry<AbstractConstantOrAliasSpecExtended, GlShaderAsset> shader : this.linkedShaders.entrySet()) {
            linkedShadersProperties.put((String)NullUtils.neverNull((Object)shader.getKey().getName()), (IAssetProperty)NullUtils.neverNull((Object)shader.getValue()));
        }
        properties.put("Linked Shaders", linkedShadersProperties);
        AssetPropertyContainer attachedShadersProperties = new AssetPropertyContainer();
        for (Map.Entry<AbstractConstantOrAliasSpecExtended, GlShaderAsset> shader : this.attachedShaders.entrySet()) {
            attachedShadersProperties.put((String)NullUtils.neverNull((Object)shader.getKey().getName()), (IAssetProperty)NullUtils.neverNull((Object)shader.getValue()));
        }
        properties.put("Attached Shaders", attachedShadersProperties);
        AssetPropertyContainer attributesMap = new AssetPropertyContainer();
        for (Map.Entry<Long, ShaderAttribute> attribute : this.vertexAttributes.entrySet()) {
            attributesMap.put(NullUtils.stringValueOf((long)attribute.getValue().getId()), (IAssetProperty)NullUtils.neverNull((Object)attribute.getValue()));
        }
        properties.put("Attributes", attributesMap);
        AssetPropertyContainer uniformMap = new AssetPropertyContainer();
        for (ShaderUniform uniform : this.uniforms.getAllVariables()) {
            uniformMap.put(NullUtils.stringValueOf((long)uniform.getId()), uniform);
        }
        properties.put("Uniforms", uniformMap);
        properties.put("Separable", ValueAssetProperty.fromBoolean(this.isSeparable()));
        return properties;
    }

    @Override
    public int compareTo(GlProgramAsset o) {
        if (o == null) {
            return 1;
        }
        return this.getId().compareTo(o.getId());
    }

    private static final class ShaderPipelineComparator
    implements Comparator<AbstractConstantOrAliasSpecExtended>,
    Serializable {
        private static final long serialVersionUID = 2766561789296353979L;
        private static final List<@NonNull AbstractConstantOrAliasSpecExtended> SHADER_PIPELINE_ORDER = List.of(KapiSpec.GLES.constants.GL_VERTEX_SHADER, KapiSpec.GLES.constants.GL_TESS_CONTROL_SHADER, KapiSpec.GLES.constants.GL_TESS_EVALUATION_SHADER, KapiSpec.GLES.constants.GL_GEOMETRY_SHADER, KapiSpec.GLES.constants.GL_FRAGMENT_SHADER, KapiSpec.GLES.constants.GL_COMPUTE_SHADER);

        private ShaderPipelineComparator() {
            assert (KapiSpec.GLES.constantGroups.SHADERTYPE.size() == SHADER_PIPELINE_ORDER.size()) : "A new shader type has been added but its order in the pipeline has not been set.";
        }

        @Override
        public int compare(AbstractConstantOrAliasSpecExtended o1, AbstractConstantOrAliasSpecExtended o2) {
            assert (SHADER_PIPELINE_ORDER.indexOf(o1) != -1) : "Unknown shader type: " + o1.getName();
            assert (SHADER_PIPELINE_ORDER.indexOf(o2) != -1) : "Unknown shader type: " + o2.getName();
            return Integer.compare(SHADER_PIPELINE_ORDER.indexOf(o1), SHADER_PIPELINE_ORDER.indexOf(o2));
        }
    }
}

