/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlImageUnitAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public class GlImageUnitAsset
extends AbstractGlImageUnitAsset {
    private static final long serialVersionUID = 1L;

    public static @NonNull GlImageUnitAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlImageUnitAsset(builder.getSnapshotAssetParent(), createdByFunction, assetAttachment.getId());
    }

    public GlImageUnitAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id) {
        super(snapshotAssetParent, createdByFunction, id);
    }

    @Override
    public @NonNull String getLabelText() {
        return NullUtils.formattedString((String)"Image Unit %s", (Object[])new Object[]{this.getId()});
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        GlTextureAsset texture = this.getTexture();
        if (texture != null) {
            properties.put("Texture", texture);
        }
        properties.put("Level", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getLevel())));
        properties.put("Layered", ValueAssetProperty.fromBoolean(this.isLayered()));
        properties.put("Layer", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getLevel())));
        properties.put("Access", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getAccess().toString())));
        properties.put("Format", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getFormat().toString())));
        return properties;
    }
}

