/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.io.Serializable;
import org.eclipse.jdt.annotation.NonNull;

public class GlImageOffset
implements Serializable {
    private static final long serialVersionUID = -5536092983720665356L;
    public static final @NonNull GlImageOffset ZERO = new GlImageOffset(0, 0);
    public final int originalX;
    public final int originalY;
    public final int originalZ;
    public final int x;
    public final int y;
    public final int z;
    public final @NonNull AbstractConstantOrAliasSpecExtended target;

    public GlImageOffset(int xOffset, int yOffset) {
        this(xOffset, yOffset, 0, KapiSpec.GLES.constants.GL_TEXTURE_2D, 0, 0, 0);
    }

    public GlImageOffset(int offsetX, int offsetY, @NonNull AbstractConstantOrAliasSpecExtended target, int width, int height) {
        this(offsetX, offsetY, 0, target, width, height, 0);
    }

    public GlImageOffset(int offsetX, int offsetY, int offsetZ, @NonNull AbstractConstantOrAliasSpecExtended target, int width, int height, int depth) {
        this.target = target;
        this.originalX = offsetX;
        this.originalY = offsetY;
        this.originalZ = offsetZ;
        int cubemapOffsetX = 0;
        int cubemapOffsetY = 0;
        if (KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_X.equals(target)) {
            cubemapOffsetX = 0;
            cubemapOffsetY = height;
        } else if (KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_X.equals(target)) {
            cubemapOffsetX = width * 2;
            cubemapOffsetY = height;
        } else if (KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Y.equals(target)) {
            cubemapOffsetX = width;
            cubemapOffsetY = height * 2;
        } else if (KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Y.equals(target)) {
            cubemapOffsetX = width;
            cubemapOffsetY = 0;
        } else if (KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_NEGATIVE_Z.equals(target)) {
            cubemapOffsetX = width * 3;
            cubemapOffsetY = height;
        } else if (KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP_POSITIVE_Z.equals(target)) {
            cubemapOffsetX = width;
            cubemapOffsetY = height;
        }
        this.x = cubemapOffsetX + offsetX;
        this.y = cubemapOffsetY + offsetY;
        this.z = offsetZ;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GlImageOffset) {
            GlImageOffset other = (GlImageOffset)obj;
            return this.x == other.x && this.y == other.y && this.z == other.z;
        }
        return false;
    }

    public String toString() {
        return "GlImageOffset(" + this.x + ", " + this.y + ", " + this.z + ")";
    }

    public int hashCode() {
        return super.hashCode();
    }
}

