/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureSurfaceAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.objects.gen.AbstractGlFramebufferTextureMultiviewAttachmentAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlFramebufferTextureMultiviewAttachmentAsset
extends AbstractGlFramebufferTextureMultiviewAttachmentAsset {
    private static final long serialVersionUID = -5305401430257860202L;

    public static GlFramebufferTextureMultiviewAttachmentAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall functionCall, @NonNull GlFramebufferAsset parentAsset, GlTextureAsset arrayTexture, long arrayTextureLevel, long baseViewIndex, int numViews, int samples) {
        return new GlFramebufferTextureMultiviewAttachmentAsset(functionCall, parentAsset, assetAttachment.getId(), (GlTextureAsset)NullUtils.neverNull((Object)arrayTexture), arrayTextureLevel, baseViewIndex, numViews, samples);
    }

    public GlFramebufferTextureMultiviewAttachmentAsset(FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, @NonNull GlFramebufferAsset parentAsset, long attachment, @NonNull GlTextureAsset arrayTexture, long arrayTextureLevel, long baseViewIndex, int numViews, int samples) {
        super(createdByFunction, uniqueInstanceId, parentAsset, attachment, arrayTexture, arrayTextureLevel, baseViewIndex, numViews, samples);
    }

    public GlFramebufferTextureMultiviewAttachmentAsset(FunctionCall createdByFunction, @NonNull GlFramebufferAsset parentAsset, long attachment, @NonNull GlTextureAsset arrayTexture, long arrayTextureLevel, long baseViewIndex, int numViews, int samples) {
        this(createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, parentAsset, attachment, arrayTexture, arrayTextureLevel, baseViewIndex, numViews, samples);
    }

    @Override
    public @Nullable IImageProvider getImageForm() {
        return null;
    }

    @Override
    public @Nullable String getTextForm() {
        return "Multiview attachment";
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        @NonNull GlTextureAsset textureAsset = this.getArrayTexture();
        properties.put("Texture", textureAsset);
        properties.put("Level", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getArrayTextureLevel())));
        if (this.getSamples() > 0) {
            properties.put("Samples", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getSamples())));
        }
        properties.put("Base View Index", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getBaseViewIndex())));
        int baseViewIndex = Long.valueOf(this.getBaseViewIndex()).intValue();
        int numViews = Long.valueOf(this.getNumViews()).intValue();
        if (numViews < 1 || (long)numViews > KapiSpec.GLES.constants.GL_MAX_VIEWS_OVR.getResolvedValue()) {
            return properties;
        }
        if ((long)(baseViewIndex + numViews) > KapiSpec.GLES.constants.GL_MAX_ARRAY_TEXTURE_LAYERS.getResolvedValue()) {
            return properties;
        }
        if (baseViewIndex + numViews > textureAsset.getSurfaces().size()) {
            return properties;
        }
        int index = baseViewIndex;
        while (index < baseViewIndex + this.getNumViews()) {
            @NonNull GlTextureSurfaceAsset textureLayerAsset = textureAsset.getSurfaces().get(index);
            final int viewId = index - baseViewIndex;
            AssetPropertyContainer multiviewProperty = new AssetPropertyContainer(){

                @Override
                public @Nullable IImageProvider getImageForm() {
                    return GlFramebufferTextureMultiviewAttachmentAsset.this.getParentAsset().getGlMultiviewAttachmentImageProvider(GlFramebufferTextureMultiviewAttachmentAsset.this.getAttachment(), viewId);
                }
            };
            multiviewProperty.put("Attached Texture Layer", textureLayerAsset);
            properties.put("View " + String.valueOf(viewId), multiviewProperty);
            ++index;
        }
        return properties;
    }

    @Override
    public @Nullable IAssetItem getAsset() {
        return this.getArrayTexture();
    }

    @Override
    public void doMidstreamTraceUpdatePostProcessing(@NonNull FunctionCall functionCall) {
        GlTextureAsset textureAsset = this.getArrayTexture();
        textureAsset.setEverBoundToFramebuffer(true);
        textureAsset.addBoundTo(this.getParentAsset().getId(), this.getAttachment(), functionCall);
    }

    @Override
    public @NonNull String getLabelText() {
        GlTextureAsset texture = this.getArrayTexture();
        return (String)NullUtils.neverNull((Object)String.format("Texture %s", texture.getId()));
    }
}

