/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.objects.gen.AbstractGlFramebufferTextureAttachmentAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public final class GlFramebufferTextureAttachmentAsset
extends AbstractGlFramebufferTextureAttachmentAsset {
    private static final long serialVersionUID = -737996318543763751L;
    private final boolean isTexture2D;

    public static @NonNull GlFramebufferTextureAttachmentAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull GlFramebufferAsset parentAsset, @NonNull GlTextureAsset texture, @Nullable AbstractConstantOrAliasSpecExtended textureCubeMapFace, @Nullable Integer textureLayer, long textureLevel) {
        if (textureLayer == null || !KapiSpec.GLES.constantGroups.TEXTURE3DTARGET.contains(texture.getTextureTarget())) {
            return new GlFramebufferTextureAttachmentAsset(createdByFunction, UniqueInstanceId.createFor(assetAttachment), parentAsset, assetAttachment.getId(), texture, textureCubeMapFace, textureLevel);
        }
        return new GlFramebufferTextureAttachmentAsset(createdByFunction, UniqueInstanceId.createFor(assetAttachment), parentAsset, assetAttachment.getId(), texture, textureLayer, textureLevel);
    }

    public GlFramebufferTextureAttachmentAsset(FunctionCall createdByFunction, @NonNull GlFramebufferAsset parentAsset, long attachment, @NonNull GlTextureAsset texture, @Nullable AbstractConstantOrAliasSpecExtended textureCubeMapFace, long textureLevel) {
        this(createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, parentAsset, attachment, texture, textureCubeMapFace, textureLevel);
    }

    public GlFramebufferTextureAttachmentAsset(FunctionCall createdByFunction, @NonNull GlFramebufferAsset parentAsset, long attachment, @NonNull GlTextureAsset texture, int textureLayer, long textureLevel) {
        this(createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, parentAsset, attachment, texture, textureLayer, textureLevel);
    }

    public GlFramebufferTextureAttachmentAsset(FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, @NonNull GlFramebufferAsset parentAsset, long attachment, @NonNull GlTextureAsset texture, @Nullable AbstractConstantOrAliasSpecExtended textureCubeMapFace, long textureLevel) {
        super(createdByFunction, uniqueInstanceId, parentAsset, attachment, texture, textureCubeMapFace, null, textureLevel);
        if (textureCubeMapFace == null) {
            textureCubeMapFace = KapiSpec.GLES.constants.GL_NONE;
        }
        assert (texture.getTextureTarget() != null);
        this.isTexture2D = true;
        assert (KapiSpec.GLES.constantGroups.TEXTURE2DTARGET.contains(texture.getTextureTarget()));
        assert (textureCubeMapFace.equals(KapiSpec.GLES.constants.GL_NONE) || KapiSpec.GLES.constantGroups.TEXTURE2DTARGET.contains(textureCubeMapFace));
        assert (textureCubeMapFace.equals(KapiSpec.GLES.constants.GL_NONE) || texture.getTextureTarget().equals(KapiSpec.GLES.constants.GL_TEXTURE_CUBE_MAP));
    }

    public GlFramebufferTextureAttachmentAsset(FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, @NonNull GlFramebufferAsset parentAsset, long attachment, @NonNull GlTextureAsset texture, int textureLayer, long textureLevel) {
        super(createdByFunction, uniqueInstanceId, parentAsset, attachment, texture, null, textureLayer, textureLevel);
        assert (texture.getTextureTarget() != null);
        this.isTexture2D = false;
        assert (KapiSpec.GLES.constantGroups.TEXTURE3DTARGET.contains(texture.getTextureTarget()));
    }

    @Override
    public @NonNull GlTextureAsset getAsset() {
        return this.getTexture();
    }

    @Override
    public @NonNull String getLabelText() {
        GlTextureAsset texture = this.getTexture();
        return (String)NullUtils.neverNull((Object)String.format("Texture %s", texture.getId()));
    }

    @Override
    public void doMidstreamTraceUpdatePostProcessing(@NonNull FunctionCall functionCall) {
        @NonNull GlTextureAsset textureAsset = this.getTexture();
        textureAsset.addBoundTo(this.getParentAsset().getId(), this.getAttachment(), functionCall);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        GlTextureAsset texture = this.getTexture();
        properties.put("Texture", texture);
        if (this.isTexture2D) {
            AbstractConstantOrAliasSpecExtended textureCubeMapFace = this.getTextureCubeMapFace();
            String targetString = (String)NullUtils.neverNull((Object)(textureCubeMapFace != null ? textureCubeMapFace : texture.getTextureTarget()).toString());
            properties.put("Target", ValueAssetProperty.create(targetString));
            properties.put("Level", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getTextureLevel())));
        } else {
            properties.put("Level", ValueAssetProperty.create(NullUtils.stringValueOf((long)this.getTextureLevel())));
            properties.put("Layer", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getTextureLayer().toString())));
        }
        return properties;
    }
}

