/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.GlFramebufferAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.objects.gen.AbstractGlFramebufferAttachmentAsset;
import com.arm.mgd.core.asset.texture.IImageProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class GlFramebufferAttachmentAsset
extends AbstractGlFramebufferAttachmentAsset {
    private static final long serialVersionUID = -5580706092695201318L;

    public GlFramebufferAttachmentAsset(FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, @NonNull GlFramebufferAsset parentAsset, long attachment) {
        super(createdByFunction, uniqueInstanceId, parentAsset, attachment);
    }

    public abstract @Nullable IAssetItem getAsset();

    public @NonNull AbstractConstantOrAliasSpecExtended getAttachment() {
        return KapiSpec.GLES.constantGroups.FRAMEBUFFERATTACHMENT.getConstantSpecByValue(this.getId());
    }

    @Override
    public @NonNull String getLabelText() {
        return (String)NullUtils.neverNull((Object)this.getId().toString());
    }

    public @NonNull GlFramebufferAttachmentType getAttachmentType() {
        @NonNull AbstractConstantOrAliasSpecExtended type = this.getAttachment();
        if (type.equals(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT)) {
            return GlFramebufferAttachmentType.DEPTH;
        }
        if (type.equals(KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT)) {
            return GlFramebufferAttachmentType.STENCIL;
        }
        if (type.equals(KapiSpec.GLES.constants.GL_DEPTH_STENCIL_ATTACHMENT)) {
            return GlFramebufferAttachmentType.DEPTH_STENCIL;
        }
        return GlFramebufferAttachmentType.COLOR;
    }

    @Override
    public IImageProvider getImageForm() {
        return this.getParentAsset().getGlAttachmentImageProvider(this.getAttachment());
    }

    public static enum GlFramebufferAttachmentType {
        COLOR,
        DEPTH,
        STENCIL,
        DEPTH_STENCIL;

    }
}

