/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AttachmentViewId;
import com.arm.mgd.core.asset.EglSurfaceAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferAttachmentBinding;
import com.arm.mgd.core.asset.GlFramebufferTextureAttachmentAsset;
import com.arm.mgd.core.asset.GlFramebufferZeroAttachmentAsset;
import com.arm.mgd.core.asset.GlTextureAsset;
import com.arm.mgd.core.asset.GlTextureImageAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.IAssetItemWithParent;
import com.arm.mgd.core.asset.objects.gen.AbstractGlFramebufferAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.IAssetProperty;
import com.arm.mgd.core.asset.texture.GlFramebufferCompositor;
import com.arm.mgd.core.asset.texture.IGlImageProvider;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.FrameFeaturesFlagsEnum;
import com.arm.mgd.core.target.data.FramebufferAttachment;
import com.arm.mgd.core.target.data.FramebufferDiffAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.util.ConstantNameComparator;
import com.arm.mgd.core.util.Dimension;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlFramebufferAsset
extends AbstractGlFramebufferAsset {
    private static final long serialVersionUID = -4745483049845650590L;
    private final Map<@NonNull AbstractConstantOrAliasSpecExtended, GlFramebufferAttachmentAsset> attachments = new TreeMap<AbstractConstantOrAliasSpecExtended, GlFramebufferAttachmentAsset>(new ConstantNameComparator());
    private final Map<@NonNull AttachmentViewId, GlFramebufferCompositor> captureData = new HashMap<AttachmentViewId, GlFramebufferCompositor>();

    public static @NonNull GlFramebufferAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull List<AbstractConstantOrAliasSpecExtended> drawBuffers, @NonNull AbstractConstantOrAliasSpecExtended readBuffer) {
        if (assetAttachment.getId() == 0L) {
            return GlFramebufferAsset.createFramebufferZero(builder.getSnapshotAssetParent(), createdByFunction);
        }
        return new GlFramebufferAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId(), drawBuffers, readBuffer);
    }

    public static @NonNull GlFramebufferAsset createFramebufferZero(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall currentFunctionCall) {
        GlFramebufferAsset result = new GlFramebufferAsset(snapshotAssetParent, currentFunctionCall, 0L, GlFramebufferAsset.getDefaultDrawBuffers(0L), GlFramebufferAsset.getDefaultReadBuffer(0L));
        result.attachAsset(new GlFramebufferZeroAttachmentAsset(result, KapiSpec.GLES.constants.GL_BACK.getResolvedValue()));
        result.attachAsset(new GlFramebufferZeroAttachmentAsset(result, KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT.getResolvedValue()));
        result.attachAsset(new GlFramebufferZeroAttachmentAsset(result, KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT.getResolvedValue()));
        return result;
    }

    public static GlFramebufferAsset getBoundFramebufferAsset(@NonNull TraceStateSnapshot currentState, @NonNull StateSpec binding) {
        assert (GlFramebufferAsset.isValidStateSpecBinding(binding));
        StateItem stateItem = currentState.getStateItemBySpec(binding);
        GlFramebufferAsset assetItem = (GlFramebufferAsset)stateItem.getValueAsAsset();
        if (assetItem == null) {
            Long stateValue = stateItem.getValue()[0].getValueAsLong();
            assetItem = new GlFramebufferAsset(currentState.asSnapshotAssetParent(), stateItem.getLastAffectedByFunction(), stateValue, GlFramebufferAsset.getDefaultDrawBuffers(stateValue), GlFramebufferAsset.getDefaultReadBuffer(stateValue));
            currentState.addAsset(assetItem);
        }
        return assetItem;
    }

    public static @NonNull List<@NonNull AbstractConstantOrAliasSpecExtended> getDefaultDrawBuffers(long id) {
        return new ArrayList<AbstractConstantOrAliasSpecExtended>(Arrays.asList(GlFramebufferAsset.getDefaultReadBuffer(id)));
    }

    public static @NonNull AbstractConstantOrAliasSpecExtended getDefaultReadBuffer(long id) {
        return id == 0L ? KapiSpec.GLES.constants.GL_BACK : KapiSpec.GLES.constants.GL_COLOR_ATTACHMENT0;
    }

    public static boolean isValidConstantSpecTarget(@NonNull AbstractConstantOrAliasSpecExtended constant) {
        return KapiSpec.GLES.constants.GL_FRAMEBUFFER.equals(constant) || KapiSpec.GLES.constants.GL_DRAW_FRAMEBUFFER.equals(constant) || KapiSpec.GLES.constants.GL_READ_FRAMEBUFFER.equals(constant);
    }

    public static boolean isValidStateSpecBinding(@NonNull StateSpec binding) {
        return binding == KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING || binding == KapiSpec.GLES.states.GL_READ_FRAMEBUFFER_BINDING;
    }

    public static @Nullable StateSpec mapTargetToStateSpec(@NonNull AbstractConstantOrAliasSpecExtended target) {
        if (KapiSpec.GLES.constants.GL_FRAMEBUFFER.equals(target) || KapiSpec.GLES.constants.GL_FRAMEBUFFER_BINDING.equals(target)) {
            return KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING;
        }
        if (KapiSpec.GLES.constants.GL_DRAW_FRAMEBUFFER.equals(target) || KapiSpec.GLES.constants.GL_DRAW_FRAMEBUFFER_BINDING.equals(target)) {
            return KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING;
        }
        if (KapiSpec.GLES.constants.GL_READ_FRAMEBUFFER.equals(target) || KapiSpec.GLES.constants.GL_READ_FRAMEBUFFER_BINDING.equals(target)) {
            return KapiSpec.GLES.states.GL_READ_FRAMEBUFFER_BINDING;
        }
        assert (false);
        return null;
    }

    public GlFramebufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id) {
        this(snapshotAssetParent, createdByFunction, id, GlFramebufferAsset.getDefaultDrawBuffers(id), GlFramebufferAsset.getDefaultReadBuffer(id));
    }

    public GlFramebufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, long id, @NonNull List<AbstractConstantOrAliasSpecExtended> drawBuffers, @NonNull AbstractConstantOrAliasSpecExtended readBuffer) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, drawBuffers, readBuffer);
    }

    public GlFramebufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id, @NonNull List<AbstractConstantOrAliasSpecExtended> drawBuffers, @NonNull AbstractConstantOrAliasSpecExtended readBuffer) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id, drawBuffers, readBuffer);
    }

    public void addFramebufferDiff(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall parentFunctionCall, FramebufferDiffAttachment framebufferDiffAttachment) {
        this.setPreviousModificationFunction(parentFunctionCall);
        GlFramebufferCompositor compositor = this.getCaptureCompositor(currentState, framebufferDiffAttachment.getAttachment(), framebufferDiffAttachment.getViewId());
        compositor.addElement(framebufferDiffAttachment);
    }

    public @Nullable GlFramebufferAttachmentAsset @NonNull [] attachAsset(@NonNull GlFramebufferAttachmentAsset asset) {
        AbstractConstantOrAliasSpecExtended attachment = asset.getAttachment();
        if (KapiSpec.GLES.constants.GL_DEPTH_STENCIL_ATTACHMENT.equals(attachment)) {
            return new GlFramebufferAttachmentAsset[]{this.attachments.put(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT, asset), this.attachments.put(KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT, asset)};
        }
        return new GlFramebufferAttachmentAsset[]{this.attachments.put(attachment, asset)};
    }

    public @Nullable GlFramebufferAttachmentAsset @NonNull [] clearAttachment(@NonNull AbstractConstantOrAliasSpecExtended attachment) {
        assert (KapiSpec.GLES.constantGroups.FRAMEBUFFERATTACHMENT.contains(attachment)) : "Unexpected attachment " + attachment;
        if (KapiSpec.GLES.constants.GL_DEPTH_STENCIL_ATTACHMENT.equals(attachment)) {
            return new GlFramebufferAttachmentAsset[]{this.attachments.remove(KapiSpec.GLES.constants.GL_DEPTH_ATTACHMENT), this.attachments.remove(KapiSpec.GLES.constants.GL_STENCIL_ATTACHMENT)};
        }
        return new GlFramebufferAttachmentAsset[]{this.attachments.remove(attachment)};
    }

    public void removeFramebuffer(@NonNull FunctionCall parentFunctionCall) {
        this.setPreviousModificationFunction(parentFunctionCall);
        for (GlFramebufferCompositor capture : this.captureData.values()) {
            capture.removeElementsIf(image -> true);
            capture.setFullBufferInvalid(parentFunctionCall);
        }
    }

    public @NonNull Collection<@NonNull GlFramebufferCompositor> getAllCaptureItems() {
        @NonNull Collection<@NonNull GlFramebufferCompositor> captureItems = this.captureData.values();
        return NullUtils.unmodifiableCollection(captureItems);
    }

    public @Nullable GlFramebufferAttachmentBinding getAttachmentBinding(AbstractConstantOrAliasSpecExtended attachment) {
        GlFramebufferAttachmentAsset asset = this.attachments.get(attachment);
        if (asset == null) {
            return null;
        }
        return new GlFramebufferAttachmentBinding(this, asset);
    }

    public @NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, GlFramebufferAttachmentAsset> getAttachmentMap() {
        return Collections.unmodifiableMap(this.attachments);
    }

    public @NonNull List<@NonNull GlFramebufferAttachmentBinding> getAttachmentBindings() {
        ArrayList<@NonNull GlFramebufferAttachmentBinding> bindings = new ArrayList<GlFramebufferAttachmentBinding>();
        for (Map.Entry<AbstractConstantOrAliasSpecExtended, GlFramebufferAttachmentAsset> entry : this.attachments.entrySet()) {
            bindings.add(new GlFramebufferAttachmentBinding(this, entry.getValue()));
        }
        return bindings;
    }

    public @Nullable IGlImageProvider getFirstAvailableCaptureData() {
        AbstractConstantOrAliasSpecExtended availableAttachment = this.getFirstAvailableCaptureDataAttachment();
        if (availableAttachment == null) {
            return null;
        }
        return this.getGlAttachmentImageProvider(availableAttachment);
    }

    public @Nullable AbstractConstantOrAliasSpecExtended getFirstAvailableCaptureDataAttachment() {
        if (this.captureData.isEmpty()) {
            return null;
        }
        AbstractConstantOrAliasSpecExtended mainColourAttachment = this.getMainColourAttachment();
        if (this.captureData.containsKey(AttachmentViewId.valueOf(mainColourAttachment, 0))) {
            return mainColourAttachment;
        }
        return this.captureData.keySet().iterator().next().getAttachment();
    }

    public @NonNull IGlImageProvider getGlAttachmentImageProvider(@NonNull AbstractConstantOrAliasSpecExtended attachment) {
        return this.getCaptureCompositor(null, attachment, 0);
    }

    public @NonNull IGlImageProvider getGlMultiviewAttachmentImageProvider(@NonNull AbstractConstantOrAliasSpecExtended attachment, int viewId) {
        return this.getCaptureCompositor(null, attachment, viewId);
    }

    @Override
    public @NonNull String getLabelText() {
        return "Framebuffer " + this.getId();
    }

    public @NonNull Dimension getSize() {
        IGlImageProvider imageProvider = this.getFirstAvailableCaptureData();
        if (imageProvider != null) {
            return imageProvider.getSize();
        }
        return new Dimension(0, 0);
    }

    @Override
    public boolean isAssetActive() {
        TraceStateSnapshot state = this.getSnapshotAssetParent().getTraceStateSnapshot();
        GlFramebufferAsset fbDrawBinding = (GlFramebufferAsset)state.getStateItemBySpec(KapiSpec.GLES.states.GL_DRAW_FRAMEBUFFER_BINDING).getValueAsAsset();
        GlFramebufferAsset fbReadBinding = (GlFramebufferAsset)state.getStateItemBySpec(KapiSpec.GLES.states.GL_READ_FRAMEBUFFER_BINDING).getValueAsAsset();
        return fbDrawBinding != null && this.equals(fbDrawBinding) || fbReadBinding != null && this.equals(fbReadBinding);
    }

    public void setFullBuffer(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall parentFunctionCall, @NonNull FramebufferAttachment framebufferAttachment) {
        this.setPreviousModificationFunction(parentFunctionCall);
        @NonNull Set<@NonNull FrameFeaturesFlagsEnum> features = parentFunctionCall.getFeaturesEnabled();
        boolean treatAsInternalFormat = features.contains((Object)FrameFeaturesFlagsEnum.OVERDRAW_ENABLED) || features.contains((Object)FrameFeaturesFlagsEnum.SHADER_MAP_ENABLED);
        int viewId = framebufferAttachment.getViewId();
        @NonNull GlFramebufferCompositor compositor = this.getCaptureCompositor(currentState, framebufferAttachment.getAttachment(), viewId);
        compositor.setFullBuffer(framebufferAttachment, treatAsInternalFormat);
    }

    public static boolean isCaptureAffectedByFunction(FunctionCall functionCall) {
        return functionCall.findFreeAttachment(FramebufferAttachment.class) == null && functionCall.findFreeAttachment(FramebufferDiffAttachment.class) == null;
    }

    private @NonNull GlFramebufferCompositor getCaptureCompositor(@Nullable TraceStateSnapshot currentState, @NonNull AbstractConstantOrAliasSpecExtended attachment, int viewId) {
        GlFramebufferCompositor data;
        assert (!KapiSpec.GLES.constants.GL_DEPTH_STENCIL_ATTACHMENT.equals(attachment));
        if (this.getId() == 0L && KapiSpec.GLES.constants.GL_COLOR_ATTACHMENT0.equals(attachment)) {
            attachment = KapiSpec.GLES.constants.GL_BACK;
        }
        if ((data = this.captureData.get(AttachmentViewId.valueOf(attachment, viewId))) != null) {
            return data;
        }
        data = new GlFramebufferCompositor(attachment, this.getAttachmentInternalFormat(currentState, attachment));
        this.captureData.put(AttachmentViewId.valueOf(attachment, viewId), data);
        return data;
    }

    private @Nullable AbstractConstantOrAliasSpecExtended getAttachmentInternalFormat(@Nullable TraceStateSnapshot currentState, @NonNull AbstractConstantOrAliasSpecExtended attachment) {
        IAssetItem assetItem;
        @Nullable GlFramebufferAttachmentAsset attachmentAsset = this.attachments.get(attachment);
        if (attachmentAsset instanceof GlFramebufferTextureAttachmentAsset) {
            @NonNull GlTextureAsset textureAsset = ((GlFramebufferTextureAttachmentAsset)attachmentAsset).getTexture();
            @Nullable GlTextureImageAsset mipmapImage = textureAsset.getTextureMipmapImage();
            if (mipmapImage != null) {
                return mipmapImage.getInternalFormat();
            }
        } else if (attachmentAsset instanceof GlFramebufferZeroAttachmentAsset && currentState != null && (assetItem = currentState.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_DRAW_SURFACE).getValueAsAsset()) instanceof EglSurfaceAsset) {
            return ((EglSurfaceAsset)assetItem).isSrgb() ? KapiSpec.GLES.constants.GL_SRGB8_ALPHA8 : KapiSpec.GLES.constants.GL_RGBA8;
        }
        return null;
    }

    @Override
    public void addChildAssetForMidstreamTrace(TraceStateSnapshot currentState, FunctionCall functionCall, IAssetItemWithParent<GlFramebufferAsset> childAsset) {
        assert (childAsset instanceof GlFramebufferAttachmentAsset);
        this.attachAsset((GlFramebufferAttachmentAsset)childAsset);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        for (Map.Entry<AbstractConstantOrAliasSpecExtended, GlFramebufferAttachmentAsset> attachment : this.attachments.entrySet()) {
            properties.put((String)NullUtils.neverNull((Object)attachment.getKey().getName()), (IAssetProperty)NullUtils.neverNull((Object)attachment.getValue()));
        }
        return properties;
    }

    private @NonNull AbstractConstantOrAliasSpecExtended getMainColourAttachment() {
        if (this.getId() == 0L) {
            return KapiSpec.GLES.constants.GL_BACK;
        }
        return KapiSpec.GLES.constants.GL_COLOR_ATTACHMENT0;
    }

    public IGlImageProvider getMainColourAttachmentImageProvider() {
        return this.getGlAttachmentImageProvider(this.getMainColourAttachment());
    }
}

