/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.AssetProcessor;
import com.arm.mgd.core.asset.GlVertexAttributeHelper;
import com.arm.mgd.core.asset.IBufferItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.IBufferUsage;
import com.arm.mgd.core.asset.objects.KAPIBufferUsage;
import com.arm.mgd.core.asset.objects.OneShotPropertyFailureException;
import com.arm.mgd.core.asset.objects.gen.AbstractGlBufferAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.target.data.ApiUsageException;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.IVertexProvider;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.StringUtils;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.StateSpec;
import com.arm.mgd.kapi.gen.TargetBindingSpec;
import com.arm.mgd.utils.NullUtils;
import java.util.Arrays;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class GlBufferAsset
extends AbstractGlBufferAsset
implements IVertexProvider,
IBufferItem {
    private static final long serialVersionUID = 8330301740725880115L;

    public static @NonNull GlBufferAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction) {
        return new GlBufferAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId());
    }

    public GlBufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id);
    }

    public GlBufferAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id);
    }

    @Override
    public String getLabelText() {
        return "Buffer " + this.getId();
    }

    @Deprecated
    public void setData(@NonNull TraceStateSnapshot currentState, FunctionCall lastModification, AbstractConstantOrAliasSpecExtended usage, int size, BufferArgAttachment attachmentData) {
        assert (KapiSpec.GLES.constantGroups.VERTEXBUFFEROBJECTUSAGE.contains(usage));
        assert (usage != null);
        assert (lastModification != null);
        this.setUsage(usage);
        this.setData(currentState, lastModification, attachmentData, size);
    }

    public void setSubData(@NonNull TraceStateSnapshot currentState, FunctionCall lastModification, BufferArgAttachment attachmentData, long offset) throws ApiUsageException {
        assert (offset >= 0L);
        assert (offset < Integer.MAX_VALUE);
        assert (lastModification != null);
        assert (attachmentData != null);
        this.setPreviousModificationFunction(lastModification);
        IByteDataProvider subBufferData = attachmentData.getData();
        if (subBufferData == null) {
            return;
        }
        if (this.getData() == null) {
            long size = this.getSize();
            if (size == 0L) {
                size = (long)subBufferData.getLength() + offset;
                this.setSize((int)size);
            }
            assert ((size & 0xFFFFFFFF00000000L) == 0L);
            this.setData(new byte[(int)size]);
        }
        byte @Nullable [] data = this.getData();
        assert (data != null);
        if (offset + (long)subBufferData.getLength() > (long)data.length) {
            throw new ApiUsageException("Out-of-bounds when setting sub-data buffer in " + this + ".");
        }
        subBufferData.getData().get(data, (int)offset, subBufferData.getLength());
        AssetProcessor.processUniformBufferBlockDataFor(currentState, lastModification, this);
    }

    @Override
    public @NonNull Number @Nullable [] getVertex(int index, long stride, long offset, long numberOfComponents, @NonNull AbstractConstantOrAliasSpecExtended type) throws UnsupportedTypeException {
        assert (index >= 0);
        assert (numberOfComponents > 0L && numberOfComponents <= 4L);
        assert (stride >= 0L && stride <= Integer.MAX_VALUE);
        long elementSize = GlVertexAttributeHelper.getElementSize(numberOfComponents, type);
        byte[] vertexBufferData = this.getVertexBufferData(index, (int)stride, (int)offset, (int)elementSize);
        if (vertexBufferData != null) {
            return type.getNumberArray(vertexBufferData);
        }
        return null;
    }

    private byte @Nullable [] getVertexBufferData(int index, int stride, int offset, int elementSize) {
        int vertexOffset = index * stride;
        int totalOffset = vertexOffset + offset;
        byte[] data = this.getData();
        if (data != null && vertexOffset >= 0 && totalOffset >= vertexOffset && totalOffset <= data.length - elementSize && totalOffset >= 0) {
            return Arrays.copyOfRange(data, totalOffset, totalOffset + elementSize);
        }
        return null;
    }

    @Override
    public void checkBounds(long offset) throws ApiUsageException {
        long size = this.getSize();
        if (size == 0L) {
            throw new ApiUsageException("Buffer size is zero.");
        }
        if (offset >= size) {
            throw new ApiUsageException("Offset is beyond the end of the buffer.");
        }
        if (offset > 0xA00000L) {
            throw new ApiUsageException("Large (>10MB) offset passed for vertex attribute array. Generally offsets are relatively small values, could this be a pointer passed by accident?");
        }
    }

    public void setData(@NonNull TraceStateSnapshot currentState, @NonNull FunctionCall lastModification, BufferArgAttachment attachmentData, long size) {
        byte[] dataToSet;
        IByteDataProvider dataFromAttachment;
        assert (lastModification != null);
        assert (size >= 0L);
        this.setSize(size);
        this.setPreviousModificationFunction(lastModification);
        IByteDataProvider iByteDataProvider = dataFromAttachment = attachmentData == null ? null : attachmentData.getData();
        if (dataFromAttachment == null || dataFromAttachment.isEmpty()) {
            dataToSet = null;
        } else {
            dataToSet = dataFromAttachment.cloneData();
            assert ((long)dataToSet.length == size);
        }
        this.setData(dataToSet);
        AssetProcessor.processUniformBufferBlockDataFor(currentState, lastModification, this);
    }

    @Override
    protected boolean handleOneShotPropertyFirstBindingSetFailure(AbstractConstantOrAliasSpecExtended currentValue, AbstractConstantOrAliasSpecExtended newValue) throws OneShotPropertyFailureException {
        if (currentValue == null) {
            return true;
        }
        String alwaysWarnAbout = "Binding a buffer that was initially bound to " + currentValue.getName() + " is not recommended.";
        if (KapiSpec.GLES.constants.GL_ELEMENT_ARRAY_BUFFER.equals(newValue)) {
            throw new OneShotPropertyFailureException(this, "Buffer re-binding to GL_ELEMENT_ARRAY_BUFFER is not supported by the interceptor (client vertex attributes not available).", alwaysWarnAbout);
        }
        throw new OneShotPropertyFailureException(this, alwaysWarnAbout);
    }

    @Override
    public long getSizeOfBuffer() {
        return this.getSize();
    }

    @Override
    public @NonNull IBufferUsage getBufferUsage() {
        return new KAPIBufferUsage(this.getUsage());
    }

    @Override
    public byte @Nullable [] getDataForBuffer() {
        return this.getData();
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        byte[] data = this.getData();
        if (data != null) {
            properties.put("Size", ValueAssetProperty.create(String.valueOf(data.length) + StringUtils.formatQuantity(data.length, " byte", " bytes")));
        } else {
            properties.put("Size", ValueAssetProperty.create("<unknown>"));
        }
        properties.put("Usage", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getUsage().getName())));
        TraceStateSnapshot snapshot = this.getSnapshotAssetParent().getTraceStateSnapshot();
        StringBuilder boundTo = new StringBuilder();
        for (TargetBindingSpec bindingSpec : KapiSpec.GLES.targetBindingMaps.BUFFER_TARGETS.specObject.getTargetBinding()) {
            if (snapshot.getStateItemBySpec((StateSpec)NullUtils.neverNull((Object)bindingSpec.getState())).getValueAsAsset() != this) continue;
            boundTo.append(bindingSpec.getBinding().getName()).append('\n');
        }
        if (boundTo.length() != 0) {
            properties.put("Bound To", ValueAssetProperty.create((String)NullUtils.neverNull((Object)boundTo.toString())));
        }
        if (this.getLastBoundTarget() != null) {
            properties.put("Last Bound To", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getLastBoundTarget().getName())));
        }
        return properties;
    }
}

