/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.EglAttribAssetProcessor;
import com.arm.mgd.core.asset.EglConfigAsset;
import com.arm.mgd.core.asset.EglDisplayAsset;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractEglSurfaceAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public abstract class EglSurfaceAsset
extends AbstractEglSurfaceAsset {
    private static final long serialVersionUID = 6274590632629063621L;

    public EglSurfaceAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id, @NonNull EglConfigAsset config, EglDisplayAsset parentAsset) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id, config, parentAsset);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        Boolean locked;
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Config", this.getConfig());
        this.addSurfaceProperties(properties);
        Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> attributeMap = this.getAttributesCollection();
        properties.put("Attributes", EglAttribAssetProcessor.attributesToProperties(attributeMap));
        @NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> pendingAttributeMap = this.getPendingAttributesCollection();
        if (!pendingAttributeMap.isEmpty()) {
            properties.put("Pending Attributes", EglAttribAssetProcessor.attributesToProperties(pendingAttributeMap));
        }
        if ((locked = this.getLocked()) != null) {
            properties.put("Locked", ValueAssetProperty.fromBoolean(locked));
        }
        return properties;
    }

    protected abstract void addSurfaceProperties(@NonNull AssetPropertyContainer var1);

    @Override
    public boolean isAssetActive() {
        TraceStateSnapshot state = this.getSnapshotAssetParent().getTraceStateSnapshot();
        StateItem currentDrawSurface = state.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_DRAW_SURFACE);
        StateItem currentReadSurface = state.getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_READ_SURFACE);
        return this.equals(currentDrawSurface.getValueAsAsset()) || this.equals(currentReadSurface.getValueAsAsset());
    }

    public boolean isSrgb() {
        return KapiSpec.EGL.constants.ALIAS_EGL_GL_COLORSPACE_SRGB_KHR.getResolvedValue().equals(this.getAttribute(KapiSpec.EGL.constants.ALIAS_EGL_GL_COLORSPACE_KHR));
    }
}

