/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.ReferenceCounter;
import com.arm.mgd.core.asset.objects.IRetainableAssetItem;
import com.arm.mgd.core.asset.objects.gen.AbstractEglDisplayAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.utils.NullUtils;
import org.eclipse.jdt.annotation.NonNull;

public class EglDisplayAsset
extends AbstractEglDisplayAsset
implements IRetainableAssetItem {
    private static final long serialVersionUID = 3945507605592772766L;
    private final @NonNull ReferenceCounter referenceCounter = new ReferenceCounter(0L);

    public static @NonNull EglDisplayAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull Pointer nativeDisplayID) {
        return new EglDisplayAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId(), nativeDisplayID);
    }

    public EglDisplayAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id, @NonNull Pointer nativeDisplayID) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, nativeDisplayID);
    }

    public EglDisplayAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id, @NonNull Pointer nativeDisplayID) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id, nativeDisplayID);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        properties.put("Native Display", ValueAssetProperty.create((String)NullUtils.neverNull((Object)this.getNativeDisplayId().toString())));
        return properties;
    }

    @Override
    public boolean isAssetActive() {
        StateItem currentDisplay = this.getSnapshotAssetParent().getTraceStateSnapshot().getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_DISPLAY);
        IAssetItem asset = currentDisplay.getValueAsAsset();
        return this.equals(asset);
    }

    @Override
    public @NonNull ReferenceCounter getReferenceCounter() {
        return this.referenceCounter;
    }
}

