/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.EglAttribAssetProcessor;
import com.arm.mgd.core.asset.EglConfigAsset;
import com.arm.mgd.core.asset.EglDisplayAsset;
import com.arm.mgd.core.asset.IAssetItem;
import com.arm.mgd.core.asset.ISnapshotAssetParent;
import com.arm.mgd.core.asset.objects.gen.AbstractEglContextAsset;
import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.midstream.MidstreamAssetItem;
import com.arm.mgd.core.midstream.TraceStateSnapshotAssetBuilder;
import com.arm.mgd.core.midstream.UniqueInstanceId;
import com.arm.mgd.core.state.GLESApiVersion;
import com.arm.mgd.core.state.StateItem;
import com.arm.mgd.core.target.data.FunctionCall;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.utils.NullUtils;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EglContextAsset
extends AbstractEglContextAsset {
    private static final long serialVersionUID = -7653535291008124751L;

    public static @NonNull EglContextAsset createForMidstreamTrace(@NonNull TraceStateSnapshotAssetBuilder builder, @NonNull MidstreamAssetItem assetAttachment, @NonNull FunctionCall createdByFunction, @NonNull EglConfigAsset config, EglDisplayAsset parentDisplay, EglContextAsset sharedContext) {
        return new EglContextAsset(builder.getSnapshotAssetParent(), createdByFunction, UniqueInstanceId.createFor(assetAttachment), assetAttachment.getId(), config, parentDisplay, sharedContext);
    }

    public EglContextAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, long id, @NonNull EglConfigAsset config, EglDisplayAsset parentAsset, EglContextAsset sharedContext) {
        this(snapshotAssetParent, createdByFunction, UniqueInstanceId.NO_UNIQUE_INSTANCE_ID, id, config, parentAsset, sharedContext);
    }

    public EglContextAsset(@NonNull ISnapshotAssetParent snapshotAssetParent, @NonNull FunctionCall createdByFunction, @NonNull UniqueInstanceId uniqueInstanceId, long id, @NonNull EglConfigAsset config, EglDisplayAsset parentAsset, EglContextAsset sharedContext) {
        super(snapshotAssetParent, createdByFunction, uniqueInstanceId, id, config, parentAsset, sharedContext);
    }

    @Override
    public @NonNull AssetPropertyContainer getProperties() {
        AssetPropertyContainer properties = new AssetPropertyContainer();
        EglContextAsset sharedContext = this.getSharedContext();
        properties.put("Shared Context", sharedContext != null ? sharedContext : ValueAssetProperty.NONE);
        properties.put("Config", this.getConfig());
        Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> attributeMap = this.getAttributesCollection();
        properties.put("Attributes", EglAttribAssetProcessor.attributesToProperties(attributeMap));
        return properties;
    }

    @Override
    public boolean isAssetActive() {
        StateItem currentContext = this.getSnapshotAssetParent().getTraceStateSnapshot().getStateItemBySpec(KapiSpec.EGL.states.EGL_CURRENT_CONTEXT);
        IAssetItem asset = currentContext.getValueAsAsset();
        return this.equals(asset);
    }

    public @NonNull GLESApiVersion getRequestedApiVersion() {
        Long majorVersion = this.getAttribute((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)KapiSpec.EGL.constants.EGL_CONTEXT_CLIENT_VERSION));
        Long minorVersion = this.getAttribute((AbstractConstantOrAliasSpecExtended)NullUtils.neverNull((Object)KapiSpec.EGL.constants.EGL_CONTEXT_MINOR_VERSION_KHR));
        if (majorVersion != null) {
            return GLESApiVersion.fromVersion(majorVersion, minorVersion != null ? minorVersion : 0L);
        }
        return GLESApiVersion.GLES1x;
    }
}

