/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.properties.AssetPropertyContainer;
import com.arm.mgd.core.asset.properties.ValueAssetProperty;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.target.data.Bitfield;
import com.arm.mgd.core.target.data.IArgumentParent;
import com.arm.mgd.core.target.data.LongsArgAttachment;
import com.arm.mgd.kapi.AbstractConstantOrAliasSpec;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.EGLAttributeListUsageSpec;
import com.arm.mgd.kapi.extended.EnumerationSpec;
import com.arm.mgd.utils.NullUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class EglAttribAssetProcessor {
    public static @NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> convertEglAttributesToMap(@Nullable LongsArgAttachment attributesAttachment) {
        if (attributesAttachment == null) {
            return new HashMap<AbstractConstantOrAliasSpecExtended, Long>();
        }
        IArgumentParent parent = attributesAttachment.getParent();
        int argIndex = attributesAttachment.getArgumentId();
        ArgumentSpec argSpec = parent.getChildArgumentSpec(argIndex);
        assert (argSpec.getUsage() != null);
        assert (argSpec.getUsage().getEglAttributeList() != null);
        return EglAttribAssetProcessor.convertEglAttributesToMap(argSpec.getUsage().getEglAttributeList(), attributesAttachment);
    }

    public static @NonNull List<@NonNull String> attributesToStrings(@NonNull LongsArgAttachment attributesAttachment) {
        List<@NonNull String> strings = EglAttribAssetProcessor.attributesToStrings(EglAttribAssetProcessor.convertEglAttributesToMap(attributesAttachment));
        strings.add("EGL_NONE");
        return strings;
    }

    private static @NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> convertEglAttributesToMap(EGLAttributeListUsageSpec eglattriblistFormatSpec, @NonNull LongsArgAttachment attributes) {
        EnumerationSpec attributeKeys = eglattriblistFormatSpec.getEglAttributeKeys();
        LinkedHashMap<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> attribEntries = new LinkedHashMap<AbstractConstantOrAliasSpecExtended, Long>();
        int i = 0;
        while (i < attributes.size()) {
            Long key = attributes.get(i);
            Long value = null;
            if (i + 1 < attributes.size()) {
                value = attributes.get(i + 1);
            }
            if (!key.equals(KapiSpec.EGL.constants.EGL_NONE.getResolvedValue())) {
                AbstractConstantOrAliasSpecExtended constantKey = null;
                if (attributeKeys != null) {
                    constantKey = attributeKeys.getConstantSpecByValue(key);
                }
                if (constantKey == null || constantKey.isAnonymous()) {
                    constantKey = KapiSpec.EGL.getConstantSpecByValue(key);
                }
                attribEntries.put(constantKey, value);
            } else assert (i >= attributes.size() - 2);
            i += 2;
        }
        return attribEntries;
    }

    public static @NonNull List<@NonNull String> attributesToStrings(@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> attributes) {
        ArrayList<@NonNull String> output = new ArrayList<String>();
        Map<@NonNull String, @NonNull String> stringEntries = EglAttribAssetProcessor.attributesToStringMap(attributes);
        for (Map.Entry<String, String> stringEntry : stringEntries.entrySet()) {
            output.add(stringEntry.getKey());
            output.add(stringEntry.getValue());
        }
        return output;
    }

    public static @NonNull AssetPropertyContainer attributesToProperties(@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> attributes) {
        Map<@NonNull String, @NonNull String> attributeStringMap = EglAttribAssetProcessor.attributesToStringMap(attributes);
        AssetPropertyContainer attributeProperties = new AssetPropertyContainer();
        for (Map.Entry<String, String> attributeString : attributeStringMap.entrySet()) {
            attributeProperties.put(attributeString.getKey(), ValueAssetProperty.create(attributeString.getValue()));
        }
        return attributeProperties;
    }

    private static @NonNull Map<@NonNull String, @NonNull String> attributesToStringMap(@NonNull Map<@NonNull AbstractConstantOrAliasSpecExtended, @Nullable Long> attributes) {
        HashMap<@NonNull String, @NonNull String> output = new HashMap<String, String>();
        for (Map.Entry<AbstractConstantOrAliasSpecExtended, Long> pairs : attributes.entrySet()) {
            String stringValue;
            AbstractConstantOrAliasSpecExtended key = pairs.getKey();
            Long value = pairs.getValue();
            EnumerationSpec attributeValues = key.getAsConstantSpec().getEglAttributeValues();
            if (value != null) {
                if (attributeValues != null) {
                    Serializable valueConst;
                    if (attributeValues.isBitfield()) {
                        valueConst = attributeValues.getBitfieldByValue(value);
                        stringValue = (String)NullUtils.neverNull((Object)((Bitfield)valueConst).toString());
                    } else {
                        valueConst = attributeValues.getConstantSpecByValue(value);
                        stringValue = (String)NullUtils.neverNull((Object)((AbstractConstantOrAliasSpec)((Object)valueConst)).getName());
                    }
                } else {
                    stringValue = (String)NullUtils.neverNull((Object)value.toString());
                }
            } else {
                stringValue = "0";
            }
            output.put((String)NullUtils.neverNull((Object)key.getName()), stringValue);
        }
        return output;
    }
}

