/*
 * Decompiled with CFR 0.152.
 */
package com.arm.mgd.core.asset;

import com.arm.mgd.core.asset.DrawCallData;
import com.arm.mgd.core.asset.GlBufferAsset;
import com.arm.mgd.core.asset.GlVertexArrayObjectAsset;
import com.arm.mgd.core.kapi.KapiSpec;
import com.arm.mgd.core.lang.Pointer;
import com.arm.mgd.core.target.data.BufferArgAttachment;
import com.arm.mgd.core.target.data.DrawFunctionCall;
import com.arm.mgd.core.target.data.tracestatedata.TraceStateSnapshot;
import com.arm.mgd.core.target.marshaller.bytedata.IByteDataProvider;
import com.arm.mgd.core.util.NumberUtils;
import com.arm.mgd.core.util.TraceAnalysisLogger;
import com.arm.mgd.core.util.UnsupportedTypeException;
import com.arm.mgd.core.util.executors.NamedSingleThreadExecutor;
import com.arm.mgd.kapi.extended.AbstractConstantOrAliasSpecExtended;
import com.arm.mgd.kapi.extended.ArgumentSpec;
import com.arm.mgd.kapi.extended.DrawCallInfoSpec;
import com.arm.mgd.utils.NullUtils;
import com.arm.mgd.utils.VersionProperties;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class DrawElementsCallData
extends DrawCallData {
    private static final long serialVersionUID = 9021521726429028353L;
    private final @NonNull DrawFunctionCall functionCall;
    private final int serverSideIndicesOffset;
    private final boolean serverSideIndices;
    private final int baseVertex;
    private final DrawCallInfoSpec drawCallInfo;
    private final @NonNull AbstractConstantOrAliasSpecExtended type;
    private final int serverBufferInUse;
    private final int numberOfIndices;
    private final int numberOfInstances;
    private @Nullable Future<?> uniqueIndicesFuture = null;
    private long indexRange = 0L;
    private float sparseness = 1.0f;
    private int numberOfUniqueIndices = 0;
    private static final @NonNull NamedSingleThreadExecutor executor = new NamedSingleThreadExecutor("DrawElementsCallData unique indices calculator", true);

    public DrawElementsCallData(@NonNull DrawFunctionCall functionCall, @NonNull TraceStateSnapshot currentState) {
        super(functionCall);
        this.functionCall = functionCall;
        this.drawCallInfo = functionCall.getFunctionSpec().getDrawCallInfo();
        ArgumentSpec indicesTypeArg = this.drawCallInfo.getIndicesTypeArg();
        Serializable typeArg = functionCall.getArgValue(indicesTypeArg.getArgIndex());
        assert (typeArg instanceof AbstractConstantOrAliasSpecExtended);
        this.type = (AbstractConstantOrAliasSpecExtended)typeArg;
        if (this.drawCallInfo.isIndirect()) {
            int commandStructSize = this.drawCallInfo.getIndirectCmdSize().intValue();
            int[] integerIndirectBuffer = this.getIntegerIndirectBuffer(functionCall, currentState, 4 * commandStructSize);
            this.serverSideIndices = true;
            this.serverBufferInUse = DrawElementsCallData.getBoundElementArrayBufferID(currentState);
            if (integerIndirectBuffer == null) {
                this.numberOfIndices = 0;
                this.numberOfInstances = 0;
                this.serverSideIndicesOffset = 0;
                this.baseVertex = 0;
                TraceAnalysisLogger.info(currentState, functionCall, "A draw call takes its parameters from a buffer for which " + VersionProperties.FULL_PRODUCT_NAME + " doesn't have the data ", "It may be that the buffer has been written by the GPU. Turning on \"Send Output Data\" will allow " + VersionProperties.SHORT_PRODUCT_NAME + " to recover those buffers.");
                return;
            }
            assert (integerIndirectBuffer.length == commandStructSize);
            this.numberOfIndices = integerIndirectBuffer[0];
            this.numberOfInstances = integerIndirectBuffer[1];
            this.serverSideIndicesOffset = integerIndirectBuffer[2];
            this.baseVertex = integerIndirectBuffer[3];
        } else {
            ArgumentSpec instancesArg = this.drawCallInfo.getInstanceCountArg();
            this.numberOfInstances = instancesArg != null ? ((Number)functionCall.getArgValue(instancesArg.getArgIndex())).intValue() : 1;
            this.baseVertex = 0;
            this.serverBufferInUse = DrawElementsCallData.getBoundElementArrayBufferID(currentState);
            this.serverSideIndices = this.serverBufferInUse != 0;
            ArgumentSpec indicesArg = this.drawCallInfo.getIndicesArg();
            if (this.serverSideIndices) {
                Pointer p = (Pointer)functionCall.getArgValue(indicesArg.getArgIndex());
                this.serverSideIndicesOffset = p.addressAsInt();
            } else {
                this.serverSideIndicesOffset = 0;
            }
            ArgumentSpec verticesArg = this.drawCallInfo.getVerticesArg();
            this.numberOfIndices = ((Number)functionCall.getArgValue(verticesArg.getArgIndex())).intValue();
        }
        int[] indices = this.getIndices(currentState);
        this.uniqueIndicesFuture = executor.runLater(() -> {
            int[] orderedUniqueIndices = DrawElementsCallData.calculateOrderedUniqueIndices(indices);
            this.indexRange = orderedUniqueIndices.length == 0 ? 0L : (long)(orderedUniqueIndices[orderedUniqueIndices.length - 1] - orderedUniqueIndices[0] + 1);
            this.sparseness = DrawElementsCallData.calculateSparseness(this.indexRange, orderedUniqueIndices.length);
            this.numberOfUniqueIndices = orderedUniqueIndices.length;
        });
    }

    private void blockUntilUniqueIndicesFutureComplete() {
        Future<?> localFuture = this.uniqueIndicesFuture;
        if (localFuture != null) {
            try {
                localFuture.get();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.uniqueIndicesFuture = null;
        }
    }

    private static int getBoundElementArrayBufferID(TraceStateSnapshot currentState) {
        GlBufferAsset elementBufferAsset = DrawElementsCallData.getBoundElementArrayBuffer(currentState);
        if (elementBufferAsset != null) {
            return elementBufferAsset.getId().intValue();
        }
        return 0;
    }

    private static @Nullable GlBufferAsset getBoundElementArrayBuffer(TraceStateSnapshot currentState) {
        GlVertexArrayObjectAsset vertexArrayObjectAsset = (GlVertexArrayObjectAsset)currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_VERTEX_ARRAY_BINDING).getValueAsAsset();
        if (vertexArrayObjectAsset != null) {
            return vertexArrayObjectAsset.getElementArrayBufferBinding();
        }
        GlBufferAsset elementBufferAsset = (GlBufferAsset)currentState.getStateItemBySpec(KapiSpec.GLES.states.GL_ELEMENT_ARRAY_BUFFER_BINDING).getValueAsAsset();
        if (elementBufferAsset != null && elementBufferAsset.getData() != null) {
            return elementBufferAsset;
        }
        return null;
    }

    private Number[] getServerSideIndices(@NonNull TraceStateSnapshot currentState) throws UnsupportedTypeException, ArrayIndexOutOfBoundsException {
        byte[] data;
        assert (this.type.getCtype() != null && this.type.getCtype().getByteSize() != null);
        int length = this.numberOfIndices * this.type.getCtype().getByteSize();
        GlBufferAsset elementBufferAsset = DrawElementsCallData.getBoundElementArrayBuffer(currentState);
        byte[] byArray = data = elementBufferAsset != null ? elementBufferAsset.getData() : null;
        if (data != null) {
            return this.type.getNumberArray(NullUtils.neverNull((byte[])Arrays.copyOfRange(data, this.serverSideIndicesOffset, this.serverSideIndicesOffset + length)));
        }
        return new Integer[0];
    }

    private Number[] getClientSideIndices() throws UnsupportedTypeException {
        IByteDataProvider data;
        ArgumentSpec indicesArg = this.drawCallInfo.getIndicesArg();
        @NonNull Serializable indices = this.functionCall.getArgValue(indicesArg.getArgIndex());
        if (indices instanceof BufferArgAttachment && (data = ((BufferArgAttachment)indices).getData()) != null) {
            return this.type.getNumberArray(data.cloneData());
        }
        return new Integer[0];
    }

    private Number[] incrementByBaseVertex(Number[] indices) {
        Number[] offsetIndices = new Long[indices.length];
        int indiciesIndex = 0;
        while (indiciesIndex < indices.length) {
            offsetIndices[indiciesIndex] = indices[indiciesIndex].longValue() + (long)this.baseVertex;
            ++indiciesIndex;
        }
        return offsetIndices;
    }

    @Override
    public int @NonNull [] getIndices(@NonNull TraceStateSnapshot currentState) {
        Number[] indicesObjects = null;
        try {
            indicesObjects = this.serverSideIndices ? this.getServerSideIndices(currentState) : this.getClientSideIndices();
        }
        catch (UnsupportedTypeException e) {
            TraceAnalysisLogger.error(currentState, this.functionCall, "Cannot convert indices data of type: " + this.type);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            TraceAnalysisLogger.error(currentState, this.functionCall, "Out-of-bounds offset for indexed draw call.");
        }
        if (indicesObjects == null) {
            indicesObjects = new Integer[]{};
        }
        if (this.baseVertex != 0) {
            indicesObjects = this.incrementByBaseVertex(indicesObjects);
        }
        if (this.numberOfIndices != indicesObjects.length) {
            TraceAnalysisLogger.warning(currentState, this.functionCall, "The length of the indices data array does not match the number of indices requested");
        }
        int[] indices = new int[indicesObjects.length];
        int i = 0;
        while (i < indicesObjects.length) {
            indices[i] = indicesObjects[i].intValue();
            ++i;
        }
        return indices;
    }

    public static float calculateSparseness(long range, long count) {
        if (count == 0L) {
            return Float.POSITIVE_INFINITY;
        }
        return (float)range / (float)count;
    }

    @Override
    public @NonNull List<AbstractMap.SimpleImmutableEntry<@NonNull String, @NonNull String>> getInformation() {
        List<AbstractMap.SimpleImmutableEntry<@NonNull String, @NonNull String>> information = super.getInformation();
        information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Base vertex", "" + this.baseVertex));
        information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Server side indices", "" + this.serverSideIndices));
        information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Indices range", "" + this.indexRange));
        if (this.serverSideIndices) {
            information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Server side indices offset", "" + this.serverSideIndicesOffset));
            information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Element array buffer in use", "" + this.serverBufferInUse));
        }
        if (!Float.isInfinite(this.sparseness) && !Float.isNaN(this.sparseness)) {
            information.add(new AbstractMap.SimpleImmutableEntry<String, String>("Indices sparseness", (String)NullUtils.neverNull((Object)String.format("%.2f", Float.valueOf(this.getSparseness())))));
        }
        return information;
    }

    @Override
    public long getNumberOfIndices() {
        return this.numberOfIndices;
    }

    public float getSparseness() {
        this.blockUntilUniqueIndicesFutureComplete();
        return this.sparseness;
    }

    public long getIndexRange() {
        this.blockUntilUniqueIndicesFutureComplete();
        return this.indexRange;
    }

    @Override
    public long getNumberOfUniqueIndices() {
        this.blockUntilUniqueIndicesFutureComplete();
        return this.numberOfUniqueIndices;
    }

    @Override
    public long getNumberOfInstances() {
        return this.numberOfInstances;
    }

    @Override
    public int[] getOrderedUniqueIndices(@NonNull TraceStateSnapshot currentState) {
        return DrawElementsCallData.calculateOrderedUniqueIndices(this.getIndices(currentState));
    }

    private static int @NonNull [] calculateOrderedUniqueIndices(int @NonNull [] indices) {
        return NumberUtils.sortIntArrayAndRemoveDuplicates(indices);
    }
}

